/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.util;

import org.apache.batik.util.XMLConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class XMLSupport
implements XMLConstants {
    private XMLSupport() {
    }

    public static String getXMLLang(Element elt) {
        Attr attr = elt.getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "lang");
        if (attr != null) {
            return attr.getNodeValue();
        }
        Node n = elt.getParentNode();
        while (n != null) {
            if (n.getNodeType() == 1 && (attr = ((Element)n).getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "lang")) != null) {
                return attr.getNodeValue();
            }
            n = n.getParentNode();
        }
        return "en";
    }

    public static String getXMLSpace(Element elt) {
        Attr attr = elt.getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "space");
        if (attr != null) {
            return attr.getNodeValue();
        }
        Node n = elt.getParentNode();
        while (n != null) {
            if (n.getNodeType() == 1 && (attr = ((Element)n).getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "space")) != null) {
                return attr.getNodeValue();
            }
            n = n.getParentNode();
        }
        return "default";
    }

    public static String defaultXMLSpace(String data) {
        int nChars = data.length();
        StringBuffer result = new StringBuffer(nChars);
        boolean space = false;
        int i2 = 0;
        while (i2 < nChars) {
            char c = data.charAt(i2);
            switch (c) {
                case '\n': 
                case '\r': {
                    space = false;
                    break;
                }
                case '\t': 
                case ' ': {
                    if (space) break;
                    result.append(' ');
                    space = true;
                    break;
                }
                default: {
                    result.append(c);
                    space = false;
                }
            }
            ++i2;
        }
        return result.toString().trim();
    }

    public static String preserveXMLSpace(String data) {
        int nChars = data.length();
        StringBuffer result = new StringBuffer(nChars);
        int i2 = 0;
        while (i2 < data.length()) {
            char c = data.charAt(i2);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': {
                    result.append(' ');
                    break;
                }
                default: {
                    result.append(c);
                }
            }
            ++i2;
        }
        return result.toString();
    }
}

