/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.batik.gvt.AbstractGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.RootGraphicsNode;
import org.apache.batik.util.HaltingThread;

public class CompositeGraphicsNode
extends AbstractGraphicsNode
implements List {
    public static final Rectangle2D VIEWPORT = new Rectangle();
    public static final Rectangle2D NULL_RECT = new Rectangle();
    protected GraphicsNode[] children;
    protected volatile int count;
    protected volatile int modCount;
    protected Rectangle2D backgroundEnableRgn = null;
    private volatile Rectangle2D geometryBounds;
    private volatile Rectangle2D primitiveBounds;
    private volatile Rectangle2D sensitiveBounds;
    private Shape outline;

    public List getChildren() {
        return this;
    }

    public void setBackgroundEnable(Rectangle2D bgRgn) {
        this.backgroundEnableRgn = bgRgn;
    }

    public Rectangle2D getBackgroundEnable() {
        return this.backgroundEnableRgn;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public void primitivePaint(Graphics2D g2d) {
        if (this.count == 0) {
            return;
        }
        Thread currentThread = Thread.currentThread();
        int i2 = 0;
        while (i2 < this.count) {
            if (HaltingThread.hasBeenHalted(currentThread)) {
                return;
            }
            GraphicsNode node = this.children[i2];
            if (node != null) {
                node.paint(g2d);
            }
            ++i2;
        }
    }

    protected void invalidateGeometryCache() {
        super.invalidateGeometryCache();
        this.geometryBounds = null;
        this.primitiveBounds = null;
        this.sensitiveBounds = null;
        this.outline = null;
    }

    public Rectangle2D getPrimitiveBounds() {
        if (this.primitiveBounds != null) {
            if (this.primitiveBounds == NULL_RECT) {
                return null;
            }
            return this.primitiveBounds;
        }
        Thread currentThread = Thread.currentThread();
        int i2 = 0;
        Rectangle2D bounds = null;
        while (bounds == null && i2 < this.count) {
            bounds = this.children[i2++].getTransformedBounds(GraphicsNode.IDENTITY);
            if ((i2 & 0xF) == 0 && HaltingThread.hasBeenHalted(currentThread)) break;
        }
        if (HaltingThread.hasBeenHalted(currentThread)) {
            this.invalidateGeometryCache();
            return null;
        }
        if (bounds == null) {
            this.primitiveBounds = NULL_RECT;
            return null;
        }
        this.primitiveBounds = bounds;
        while (i2 < this.count) {
            Rectangle2D ctb;
            if ((ctb = this.children[i2++].getTransformedBounds(GraphicsNode.IDENTITY)) != null) {
                if (this.primitiveBounds == null) {
                    return null;
                }
                this.primitiveBounds.add(ctb);
            }
            if ((i2 & 0xF) == 0 && HaltingThread.hasBeenHalted(currentThread)) break;
        }
        if (HaltingThread.hasBeenHalted(currentThread)) {
            this.invalidateGeometryCache();
        }
        return this.primitiveBounds;
    }

    public static Rectangle2D getTransformedBBox(Rectangle2D r2d, AffineTransform t) {
        if (t == null || r2d == null) {
            return r2d;
        }
        double x = r2d.getX();
        double w = r2d.getWidth();
        double y = r2d.getY();
        double h = r2d.getHeight();
        double sx = t.getScaleX();
        double sy = t.getScaleY();
        if (sx < 0.0) {
            x = -(x + w);
            sx = -sx;
        }
        if (sy < 0.0) {
            y = -(y + h);
            sy = -sy;
        }
        return new Rectangle2D.Float((float)(x * sx + t.getTranslateX()), (float)(y * sy + t.getTranslateY()), (float)(w * sx), (float)(h * sy));
    }

    public Rectangle2D getTransformedPrimitiveBounds(AffineTransform txf) {
        AffineTransform t = txf;
        if (this.transform != null) {
            t = new AffineTransform(txf);
            t.concatenate(this.transform);
        }
        if (t == null || t.getShearX() == 0.0 && t.getShearY() == 0.0) {
            return CompositeGraphicsNode.getTransformedBBox(this.getPrimitiveBounds(), t);
        }
        int i2 = 0;
        Rectangle2D tpb = null;
        while (tpb == null && i2 < this.count) {
            tpb = this.children[i2++].getTransformedBounds(t);
        }
        while (i2 < this.count) {
            Rectangle2D ctb;
            if ((ctb = this.children[i2++].getTransformedBounds(t)) == null) continue;
            tpb.add(ctb);
        }
        return tpb;
    }

    public Rectangle2D getGeometryBounds() {
        if (this.geometryBounds == null) {
            int i2 = 0;
            while (this.geometryBounds == null && i2 < this.count) {
                this.geometryBounds = this.children[i2++].getTransformedGeometryBounds(GraphicsNode.IDENTITY);
            }
            while (i2 < this.count) {
                Rectangle2D cgb;
                if ((cgb = this.children[i2++].getTransformedGeometryBounds(GraphicsNode.IDENTITY)) == null) continue;
                if (this.geometryBounds == null) {
                    return this.getGeometryBounds();
                }
                this.geometryBounds.add(cgb);
            }
        }
        return this.geometryBounds;
    }

    public Rectangle2D getTransformedGeometryBounds(AffineTransform txf) {
        AffineTransform t = txf;
        if (this.transform != null) {
            t = new AffineTransform(txf);
            t.concatenate(this.transform);
        }
        if (t == null || t.getShearX() == 0.0 && t.getShearY() == 0.0) {
            return CompositeGraphicsNode.getTransformedBBox(this.getGeometryBounds(), t);
        }
        Rectangle2D gb = null;
        int i2 = 0;
        while (gb == null && i2 < this.count) {
            gb = this.children[i2++].getTransformedGeometryBounds(t);
        }
        Rectangle2D cgb = null;
        while (i2 < this.count) {
            if ((cgb = this.children[i2++].getTransformedGeometryBounds(t)) == null) continue;
            gb.add(cgb);
        }
        return gb;
    }

    public Rectangle2D getSensitiveBounds() {
        if (this.sensitiveBounds != null) {
            return this.sensitiveBounds;
        }
        int i2 = 0;
        while (this.sensitiveBounds == null && i2 < this.count) {
            this.sensitiveBounds = this.children[i2++].getTransformedSensitiveBounds(GraphicsNode.IDENTITY);
        }
        while (i2 < this.count) {
            Rectangle2D cgb;
            if ((cgb = this.children[i2++].getTransformedSensitiveBounds(GraphicsNode.IDENTITY)) == null) continue;
            if (this.sensitiveBounds == null) {
                return this.getSensitiveBounds();
            }
            this.sensitiveBounds.add(cgb);
        }
        return this.sensitiveBounds;
    }

    public Rectangle2D getTransformedSensitiveBounds(AffineTransform txf) {
        AffineTransform t = txf;
        if (this.transform != null) {
            t = new AffineTransform(txf);
            t.concatenate(this.transform);
        }
        if (t == null || t.getShearX() == 0.0 && t.getShearY() == 0.0) {
            return CompositeGraphicsNode.getTransformedBBox(this.getSensitiveBounds(), t);
        }
        Rectangle2D sb = null;
        int i2 = 0;
        while (sb == null && i2 < this.count) {
            sb = this.children[i2++].getTransformedSensitiveBounds(t);
        }
        while (i2 < this.count) {
            Rectangle2D csb;
            if ((csb = this.children[i2++].getTransformedSensitiveBounds(t)) == null) continue;
            sb.add(csb);
        }
        return sb;
    }

    public boolean contains(Point2D p) {
        Rectangle2D bounds = this.getSensitiveBounds();
        if (this.count > 0 && bounds != null && bounds.contains(p)) {
            Point2D pt = null;
            Point2D cp = null;
            int i2 = 0;
            while (i2 < this.count) {
                AffineTransform t = this.children[i2].getInverseTransform();
                cp = t != null ? (pt = t.transform(p, pt)) : p;
                if (this.children[i2].contains(cp)) {
                    return true;
                }
                ++i2;
            }
        }
        return false;
    }

    public GraphicsNode nodeHitAt(Point2D p) {
        Rectangle2D bounds = this.getSensitiveBounds();
        if (this.count > 0 && bounds != null && bounds.contains(p)) {
            Point2D pt = null;
            Point2D cp = null;
            int i2 = this.count - 1;
            while (i2 >= 0) {
                AffineTransform t = this.children[i2].getInverseTransform();
                cp = t != null ? (pt = t.transform(p, pt)) : p;
                GraphicsNode node = this.children[i2].nodeHitAt(cp);
                if (node != null) {
                    return node;
                }
                --i2;
            }
        }
        return null;
    }

    public Shape getOutline() {
        if (this.outline != null) {
            return this.outline;
        }
        this.outline = new GeneralPath();
        int i2 = 0;
        while (i2 < this.count) {
            Shape childOutline = this.children[i2].getOutline();
            if (childOutline != null) {
                AffineTransform tr = this.children[i2].getTransform();
                if (tr != null) {
                    ((GeneralPath)this.outline).append(tr.createTransformedShape(childOutline), false);
                } else {
                    ((GeneralPath)this.outline).append(childOutline, false);
                }
            }
            ++i2;
        }
        return this.outline;
    }

    protected void setRoot(RootGraphicsNode newRoot) {
        super.setRoot(newRoot);
        int i2 = 0;
        while (i2 < this.count) {
            GraphicsNode node = this.children[i2];
            ((AbstractGraphicsNode)node).setRoot(newRoot);
            ++i2;
        }
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean contains(Object node) {
        return this.indexOf(node) >= 0;
    }

    public Iterator iterator() {
        return new Itr();
    }

    public Object[] toArray() {
        Object[] result = new GraphicsNode[this.count];
        System.arraycopy(this.children, 0, result, 0, this.count);
        return result;
    }

    public Object[] toArray(Object[] a) {
        if (a.length < this.count) {
            a = new GraphicsNode[this.count];
        }
        System.arraycopy(this.children, 0, a, 0, this.count);
        if (a.length > this.count) {
            a[this.count] = null;
        }
        return a;
    }

    public Object get(int index) {
        this.checkRange(index);
        return this.children[index];
    }

    public Object set(int index, Object o) {
        if (!(o instanceof GraphicsNode)) {
            throw new IllegalArgumentException(o + " is not a GraphicsNode");
        }
        this.checkRange(index);
        GraphicsNode node = (GraphicsNode)o;
        this.fireGraphicsNodeChangeStarted(node);
        if (node.getParent() != null) {
            node.getParent().getChildren().remove(node);
        }
        GraphicsNode oldNode = this.children[index];
        this.children[index] = node;
        ((AbstractGraphicsNode)node).setParent(this);
        ((AbstractGraphicsNode)oldNode).setParent(null);
        ((AbstractGraphicsNode)node).setRoot(this.getRoot());
        ((AbstractGraphicsNode)oldNode).setRoot(null);
        this.invalidateGeometryCache();
        this.fireGraphicsNodeChangeCompleted();
        return oldNode;
    }

    public boolean add(Object o) {
        if (!(o instanceof GraphicsNode)) {
            throw new IllegalArgumentException(o + " is not a GraphicsNode");
        }
        GraphicsNode node = (GraphicsNode)o;
        this.fireGraphicsNodeChangeStarted(node);
        if (node.getParent() != null) {
            node.getParent().getChildren().remove(node);
        }
        this.ensureCapacity(this.count + 1);
        this.children[this.count++] = node;
        ((AbstractGraphicsNode)node).setParent(this);
        ((AbstractGraphicsNode)node).setRoot(this.getRoot());
        this.invalidateGeometryCache();
        this.fireGraphicsNodeChangeCompleted();
        return true;
    }

    public void add(int index, Object o) {
        if (!(o instanceof GraphicsNode)) {
            throw new IllegalArgumentException(o + " is not a GraphicsNode");
        }
        if (index > this.count || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.count);
        }
        GraphicsNode node = (GraphicsNode)o;
        this.fireGraphicsNodeChangeStarted(node);
        if (node.getParent() != null) {
            node.getParent().getChildren().remove(node);
        }
        this.ensureCapacity(this.count + 1);
        System.arraycopy(this.children, index, this.children, index + 1, this.count - index);
        this.children[index] = node;
        ++this.count;
        ((AbstractGraphicsNode)node).setParent(this);
        ((AbstractGraphicsNode)node).setRoot(this.getRoot());
        this.invalidateGeometryCache();
        this.fireGraphicsNodeChangeCompleted();
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int index, Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object o) {
        if (!(o instanceof GraphicsNode)) {
            throw new IllegalArgumentException(o + " is not a GraphicsNode");
        }
        GraphicsNode node = (GraphicsNode)o;
        if (node.getParent() != this) {
            return false;
        }
        int index = 0;
        while (node != this.children[index]) {
            ++index;
        }
        this.remove(index);
        return true;
    }

    public Object remove(int index) {
        this.checkRange(index);
        GraphicsNode oldNode = this.children[index];
        this.fireGraphicsNodeChangeStarted(oldNode);
        ++this.modCount;
        int numMoved = this.count - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.children, index + 1, this.children, index, numMoved);
        }
        this.children[--this.count] = null;
        if (this.count == 0) {
            this.children = null;
        }
        ((AbstractGraphicsNode)oldNode).setParent(null);
        ((AbstractGraphicsNode)oldNode).setRoot(null);
        this.invalidateGeometryCache();
        this.fireGraphicsNodeChangeCompleted();
        return oldNode;
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean containsAll(Collection c) {
        Iterator i2 = c.iterator();
        while (i2.hasNext()) {
            if (this.contains(i2.next())) continue;
            return false;
        }
        return true;
    }

    public int indexOf(Object node) {
        if (node == null || !(node instanceof GraphicsNode)) {
            return -1;
        }
        if (((GraphicsNode)node).getParent() == this) {
            int iCount = this.count;
            GraphicsNode[] workList = this.children;
            int i2 = 0;
            while (i2 < iCount) {
                if (node == workList[i2]) {
                    return i2;
                }
                ++i2;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object node) {
        if (node == null || !(node instanceof GraphicsNode)) {
            return -1;
        }
        if (((GraphicsNode)node).getParent() == this) {
            int i2 = this.count - 1;
            while (i2 >= 0) {
                if (node == this.children[i2]) {
                    return i2;
                }
                --i2;
            }
        }
        return -1;
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int index) {
        if (index < 0 || index > this.count) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new ListItr(index);
    }

    public List subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    private void checkRange(int index) {
        if (index >= this.count || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.count);
        }
    }

    public void ensureCapacity(int minCapacity) {
        if (this.children == null) {
            this.children = new GraphicsNode[4];
        }
        ++this.modCount;
        int oldCapacity = this.children.length;
        if (minCapacity > oldCapacity) {
            GraphicsNode[] oldData = this.children;
            int newCapacity = oldCapacity + oldCapacity / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.children = new GraphicsNode[newCapacity];
            System.arraycopy(oldData, 0, this.children, 0, this.count);
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator {
        ListItr(int index) {
            this.cursor = index;
        }

        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        public Object previous() {
            try {
                Object previous = CompositeGraphicsNode.this.get(--this.cursor);
                this.checkForComodification();
                this.lastRet = this.cursor;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        public int nextIndex() {
            return this.cursor;
        }

        public int previousIndex() {
            return this.cursor - 1;
        }

        public void set(Object o) {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                CompositeGraphicsNode.this.set(this.lastRet, o);
                this.expectedModCount = CompositeGraphicsNode.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(Object o) {
            this.checkForComodification();
            try {
                CompositeGraphicsNode.this.add(this.cursor++, o);
                this.lastRet = -1;
                this.expectedModCount = CompositeGraphicsNode.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr
    implements Iterator {
        int cursor = 0;
        int lastRet = -1;
        int expectedModCount;

        private Itr() {
            this.expectedModCount = CompositeGraphicsNode.this.modCount;
        }

        public boolean hasNext() {
            return this.cursor != CompositeGraphicsNode.this.count;
        }

        public Object next() {
            try {
                Object next = CompositeGraphicsNode.this.get(this.cursor);
                this.checkForComodification();
                this.lastRet = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                CompositeGraphicsNode.this.remove(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
                this.expectedModCount = CompositeGraphicsNode.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkForComodification() {
            if (CompositeGraphicsNode.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

