/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.util.Stack;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.batik.ext.awt.g2d.TransformStackElement;
import org.apache.batik.svggen.AbstractSVGConverter;
import org.apache.batik.svggen.SVGDescriptor;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGTransformDescriptor;

public class SVGTransform
extends AbstractSVGConverter {
    private static double radiansToDegrees = 57.29577951308232;

    public SVGTransform(SVGGeneratorContext generatorContext) {
        super(generatorContext);
    }

    public SVGDescriptor toSVG(GraphicContext gc) {
        return new SVGTransformDescriptor(this.toSVGTransform(gc));
    }

    public final String toSVGTransform(GraphicContext gc) {
        return this.toSVGTransform(gc.getTransformStack());
    }

    public final String toSVGTransform(TransformStackElement[] transformStack) {
        int nTransforms = transformStack.length;
        Stack presentation = new Stack(){

            public Object push(Object o) {
                Object element;
                if (((TransformStackElement)o).isIdentity()) {
                    element = this.pop();
                } else {
                    super.push(o);
                    element = null;
                }
                return element;
            }

            public Object pop() {
                Object element = null;
                if (!super.empty()) {
                    element = super.pop();
                }
                return element;
            }
        };
        boolean canConcatenate = false;
        int i2 = 0;
        int j = 0;
        int next = 0;
        TransformStackElement element = null;
        while (i2 < nTransforms) {
            next = i2;
            if (element == null) {
                element = (TransformStackElement)transformStack[i2].clone();
            }
            canConcatenate = true;
            j = ++next;
            while (j < nTransforms) {
                canConcatenate = element.concatenate(transformStack[j]);
                if (!canConcatenate) break;
                ++j;
            }
            i2 = j;
            element = presentation.push(element);
        }
        if (element != null) {
            presentation.push(element);
        }
        int nPresentations = presentation.size();
        StringBuffer transformStackBuffer = new StringBuffer(nPresentations * 8);
        i2 = 0;
        while (i2 < nPresentations) {
            transformStackBuffer.append(this.convertTransform((TransformStackElement)presentation.get(i2)));
            transformStackBuffer.append(" ");
            ++i2;
        }
        String transformValue = transformStackBuffer.toString().trim();
        return transformValue;
    }

    final String convertTransform(TransformStackElement transformElement) {
        StringBuffer transformString = new StringBuffer();
        double[] transformParameters = transformElement.getTransformParameters();
        switch (transformElement.getType().toInt()) {
            case 0: {
                if (transformElement.isIdentity()) break;
                transformString.append("translate");
                transformString.append("(");
                transformString.append(this.doubleString(transformParameters[0]));
                transformString.append(",");
                transformString.append(this.doubleString(transformParameters[1]));
                transformString.append(")");
                break;
            }
            case 1: {
                if (transformElement.isIdentity()) break;
                transformString.append("rotate");
                transformString.append("(");
                transformString.append(this.doubleString(radiansToDegrees * transformParameters[0]));
                transformString.append(")");
                break;
            }
            case 2: {
                if (transformElement.isIdentity()) break;
                transformString.append("scale");
                transformString.append("(");
                transformString.append(this.doubleString(transformParameters[0]));
                transformString.append(",");
                transformString.append(this.doubleString(transformParameters[1]));
                transformString.append(")");
                break;
            }
            case 3: {
                if (transformElement.isIdentity()) break;
                transformString.append("matrix");
                transformString.append("(");
                transformString.append(1);
                transformString.append(",");
                transformString.append(this.doubleString(transformParameters[1]));
                transformString.append(",");
                transformString.append(this.doubleString(transformParameters[0]));
                transformString.append(",");
                transformString.append(1);
                transformString.append(",");
                transformString.append(0);
                transformString.append(",");
                transformString.append(0);
                transformString.append(")");
                break;
            }
            case 4: {
                if (transformElement.isIdentity()) break;
                transformString.append("matrix");
                transformString.append("(");
                transformString.append(this.doubleString(transformParameters[0]));
                transformString.append(",");
                transformString.append(this.doubleString(transformParameters[1]));
                transformString.append(",");
                transformString.append(this.doubleString(transformParameters[2]));
                transformString.append(",");
                transformString.append(this.doubleString(transformParameters[3]));
                transformString.append(",");
                transformString.append(this.doubleString(transformParameters[4]));
                transformString.append(",");
                transformString.append(this.doubleString(transformParameters[5]));
                transformString.append(")");
                break;
            }
            default: {
                throw new Error();
            }
        }
        return transformString.toString();
    }
}

