/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.CmapFormat;

public class CmapFormat4
extends CmapFormat {
    public int language;
    private int segCountX2;
    private int searchRange;
    private int entrySelector;
    private int rangeShift;
    private int[] endCode;
    private int[] startCode;
    private int[] idDelta;
    private int[] idRangeOffset;
    private int[] glyphIdArray;
    private int segCount;
    private int first;
    private int last;

    protected CmapFormat4(RandomAccessFile raf) throws IOException {
        super(raf);
        this.format = 4;
        this.segCountX2 = raf.readUnsignedShort();
        this.segCount = this.segCountX2 / 2;
        this.endCode = new int[this.segCount];
        this.startCode = new int[this.segCount];
        this.idDelta = new int[this.segCount];
        this.idRangeOffset = new int[this.segCount];
        this.searchRange = raf.readUnsignedShort();
        this.entrySelector = raf.readUnsignedShort();
        this.rangeShift = raf.readUnsignedShort();
        this.last = -1;
        int i2 = 0;
        while (i2 < this.segCount) {
            this.endCode[i2] = raf.readUnsignedShort();
            if (this.endCode[i2] > this.last) {
                this.last = this.endCode[i2];
            }
            ++i2;
        }
        raf.readUnsignedShort();
        int i3 = 0;
        while (i3 < this.segCount) {
            this.startCode[i3] = raf.readUnsignedShort();
            if (i3 == 0 || this.startCode[i3] < this.first) {
                this.first = this.startCode[i3];
            }
            ++i3;
        }
        int i4 = 0;
        while (i4 < this.segCount) {
            this.idDelta[i4] = raf.readUnsignedShort();
            ++i4;
        }
        int i5 = 0;
        while (i5 < this.segCount) {
            this.idRangeOffset[i5] = raf.readUnsignedShort();
            ++i5;
        }
        int count = (this.length - 16 - this.segCount * 8) / 2;
        this.glyphIdArray = new int[count];
        int i6 = 0;
        while (i6 < count) {
            this.glyphIdArray[i6] = raf.readUnsignedShort();
            ++i6;
        }
    }

    public int getFirst() {
        return this.first;
    }

    public int getLast() {
        return this.last;
    }

    public int mapCharCode(int charCode) {
        try {
            if (charCode < 0 || charCode >= 65534) {
                return 0;
            }
            int i2 = 0;
            while (i2 < this.segCount) {
                if (this.endCode[i2] >= charCode) {
                    if (this.startCode[i2] <= charCode) {
                        if (this.idRangeOffset[i2] > 0) {
                            return this.glyphIdArray[this.idRangeOffset[i2] / 2 + (charCode - this.startCode[i2]) - (this.segCount - i2)];
                        }
                        return (this.idDelta[i2] + charCode) % 65536;
                    }
                    break;
                }
                ++i2;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println("error: Array out of bounds - " + e.getMessage());
        }
        return 0;
    }

    public String toString() {
        return new StringBuffer(80).append(super.toString()).append(", segCountX2: ").append(this.segCountX2).append(", searchRange: ").append(this.searchRange).append(", entrySelector: ").append(this.entrySelector).append(", rangeShift: ").append(this.rangeShift).append(", endCode: ").append(CmapFormat4.intToStr(this.endCode)).append(", startCode: ").append(CmapFormat4.intToStr(this.startCode)).append(", idDelta: ").append(CmapFormat4.intToStr(this.idDelta)).append(", idRangeOffset: ").append(CmapFormat4.intToStr(this.idRangeOffset)).toString();
    }

    private static String intToStr(int[] array) {
        int nSlots = array.length;
        StringBuffer workBuff = new StringBuffer(nSlots * 8);
        workBuff.append('[');
        int i2 = 0;
        while (i2 < nSlots) {
            workBuff.append(array[i2]);
            if (i2 < nSlots - 1) {
                workBuff.append(',');
            }
            ++i2;
        }
        workBuff.append(']');
        return workBuff.toString();
    }
}

