/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.IOException;
import java.io.RandomAccessFile;

public class NameRecord {
    private short platformId;
    private short encodingId;
    private short languageId;
    private short nameId;
    private short stringLength;
    private short stringOffset;
    private String record;

    protected NameRecord(RandomAccessFile raf) throws IOException {
        this.platformId = raf.readShort();
        this.encodingId = raf.readShort();
        this.languageId = raf.readShort();
        this.nameId = raf.readShort();
        this.stringLength = raf.readShort();
        this.stringOffset = raf.readShort();
    }

    public short getEncodingId() {
        return this.encodingId;
    }

    public short getLanguageId() {
        return this.languageId;
    }

    public short getNameId() {
        return this.nameId;
    }

    public short getPlatformId() {
        return this.platformId;
    }

    public String getRecordString() {
        return this.record;
    }

    protected void loadString(RandomAccessFile raf, int stringStorageOffset) throws IOException {
        StringBuffer sb = new StringBuffer();
        raf.seek(stringStorageOffset + this.stringOffset);
        if (this.platformId == 0) {
            int i2 = 0;
            while (i2 < this.stringLength / 2) {
                sb.append(raf.readChar());
                ++i2;
            }
        } else if (this.platformId == 1) {
            int i3 = 0;
            while (i3 < this.stringLength) {
                sb.append((char)raf.readByte());
                ++i3;
            }
        } else if (this.platformId == 2) {
            int i4 = 0;
            while (i4 < this.stringLength) {
                sb.append((char)raf.readByte());
                ++i4;
            }
        } else if (this.platformId == 3) {
            int i5 = 0;
            while (i5 < this.stringLength / 2) {
                char c = raf.readChar();
                sb.append(c);
                ++i5;
            }
        }
        this.record = sb.toString();
    }
}

