/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.Script;
import org.apache.batik.svggen.font.table.ScriptRecord;

public class ScriptList {
    private int scriptCount = 0;
    private ScriptRecord[] scriptRecords;
    private Script[] scripts;

    protected ScriptList(RandomAccessFile raf, int offset) throws IOException {
        raf.seek(offset);
        this.scriptCount = raf.readUnsignedShort();
        this.scriptRecords = new ScriptRecord[this.scriptCount];
        this.scripts = new Script[this.scriptCount];
        int i2 = 0;
        while (i2 < this.scriptCount) {
            this.scriptRecords[i2] = new ScriptRecord(raf);
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.scriptCount) {
            this.scripts[i3] = new Script(raf, offset + this.scriptRecords[i3].getOffset());
            ++i3;
        }
    }

    public int getScriptCount() {
        return this.scriptCount;
    }

    public ScriptRecord getScriptRecord(int i2) {
        return this.scriptRecords[i2];
    }

    public Script findScript(String tag) {
        if (tag.length() != 4) {
            return null;
        }
        int tagVal = tag.charAt(0) << 24 | tag.charAt(1) << 16 | tag.charAt(2) << 8 | tag.charAt(3);
        int i2 = 0;
        while (i2 < this.scriptCount) {
            if (this.scriptRecords[i2].getTag() == tagVal) {
                return this.scripts[i2];
            }
            ++i2;
        }
        return null;
    }
}

