/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.gvt;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.text.CharacterIterator;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.event.AWTEventDispatcher;
import org.apache.batik.gvt.event.EventDispatcher;
import org.apache.batik.gvt.event.SelectionAdapter;
import org.apache.batik.gvt.event.SelectionEvent;
import org.apache.batik.gvt.renderer.ConcreteImageRendererFactory;
import org.apache.batik.gvt.renderer.ImageRenderer;
import org.apache.batik.gvt.renderer.ImageRendererFactory;
import org.apache.batik.gvt.text.Mark;
import org.apache.batik.swing.gvt.AbstractJGVTComponent;
import org.apache.batik.swing.gvt.AbstractZoomInteractor;
import org.apache.batik.swing.gvt.GVTTreeRenderer;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.GVTTreeRendererListener;
import org.apache.batik.swing.gvt.Interactor;
import org.apache.batik.swing.gvt.JGVTComponentListener;
import org.apache.batik.swing.gvt.Overlay;
import org.apache.batik.swing.gvt.TextSelectionManager;
import org.apache.batik.util.HaltingThread;
import org.apache.batik.util.Platform;

public abstract class AbstractJGVTComponent
extends JComponent {
    protected Listener listener;
    protected GVTTreeRenderer gvtTreeRenderer;
    protected GraphicsNode gvtRoot;
    protected ImageRendererFactory rendererFactory = new ConcreteImageRendererFactory();
    protected ImageRenderer renderer;
    protected List gvtTreeRendererListeners = Collections.synchronizedList(new LinkedList());
    protected boolean needRender;
    protected boolean progressivePaint;
    protected HaltingThread progressivePaintThread;
    protected BufferedImage image;
    protected AffineTransform initialTransform = new AffineTransform();
    protected AffineTransform renderingTransform = new AffineTransform();
    protected AffineTransform paintingTransform;
    protected List interactors = new LinkedList();
    protected Interactor interactor;
    protected List overlays = new LinkedList();
    protected List jgvtListeners = null;
    protected AWTEventDispatcher eventDispatcher;
    protected TextSelectionManager textSelectionManager;
    protected boolean doubleBufferedRendering;
    protected boolean eventsEnabled;
    protected boolean selectableText;
    protected boolean useUnixTextSelection = true;
    protected boolean suspendInteractions;
    protected boolean disableInteractions;

    public AbstractJGVTComponent() {
        this(false, false);
    }

    public AbstractJGVTComponent(boolean eventsEnabled, boolean selectableText) {
        this.setBackground(Color.white);
        this.eventsEnabled = eventsEnabled;
        this.selectableText = selectableText;
        this.listener = this.createListener();
        this.addAWTListeners();
        this.addGVTTreeRendererListener(this.listener);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                if (AbstractJGVTComponent.this.updateRenderingTransform()) {
                    AbstractJGVTComponent.this.scheduleGVTRendering();
                }
            }
        });
    }

    protected void addAWTListeners() {
        this.addKeyListener(this.listener);
        this.addMouseListener(this.listener);
        this.addMouseMotionListener(this.listener);
    }

    public void setDisableInteractions(boolean b) {
        this.disableInteractions = b;
    }

    public boolean getDisableInteractions() {
        return this.disableInteractions;
    }

    public void setUseUnixTextSelection(boolean b) {
        this.useUnixTextSelection = b;
    }

    public void getUseUnixTextSelection(boolean b) {
        this.useUnixTextSelection = b;
    }

    public List getInteractors() {
        return this.interactors;
    }

    public List getOverlays() {
        return this.overlays;
    }

    public BufferedImage getOffScreen() {
        return this.image;
    }

    public void addJGVTComponentListener(JGVTComponentListener listener) {
        if (this.jgvtListeners == null) {
            this.jgvtListeners = new LinkedList();
        }
        this.jgvtListeners.add(listener);
    }

    public void removeJGVTComponentListener(JGVTComponentListener listener) {
        if (this.jgvtListeners == null) {
            return;
        }
        this.jgvtListeners.remove(listener);
    }

    public void resetRenderingTransform() {
        this.setRenderingTransform(this.initialTransform);
    }

    public void stopProcessing() {
        if (this.gvtTreeRenderer != null) {
            this.needRender = false;
            this.gvtTreeRenderer.halt();
            this.haltProgressivePaintThread();
        }
    }

    public GraphicsNode getGraphicsNode() {
        return this.gvtRoot;
    }

    public void setGraphicsNode(GraphicsNode gn) {
        this.setGraphicsNode(gn, true);
        this.initialTransform = new AffineTransform();
        this.updateRenderingTransform();
        this.setRenderingTransform(this.initialTransform, true);
    }

    protected void setGraphicsNode(GraphicsNode gn, boolean createDispatcher) {
        this.gvtRoot = gn;
        if (gn != null && createDispatcher) {
            this.initializeEventHandling();
        }
        if (this.eventDispatcher != null) {
            this.eventDispatcher.setRootNode(gn);
        }
    }

    protected void initializeEventHandling() {
        if (this.eventsEnabled) {
            this.eventDispatcher = new AWTEventDispatcher();
            if (this.selectableText) {
                this.textSelectionManager = this.createTextSelectionManager(this.eventDispatcher);
                this.textSelectionManager.addSelectionListener(new UnixTextSelectionListener());
            }
        }
    }

    protected TextSelectionManager createTextSelectionManager(EventDispatcher ed) {
        return new TextSelectionManager(this, ed);
    }

    public TextSelectionManager getTextSelectionManager() {
        return this.textSelectionManager;
    }

    public void setSelectionOverlayColor(Color color) {
        if (this.textSelectionManager != null) {
            this.textSelectionManager.setSelectionOverlayColor(color);
        }
    }

    public Color getSelectionOverlayColor() {
        if (this.textSelectionManager != null) {
            return this.textSelectionManager.getSelectionOverlayColor();
        }
        return null;
    }

    public void setSelectionOverlayStrokeColor(Color color) {
        if (this.textSelectionManager != null) {
            this.textSelectionManager.setSelectionOverlayStrokeColor(color);
        }
    }

    public Color getSelectionOverlayStrokeColor() {
        if (this.textSelectionManager != null) {
            return this.textSelectionManager.getSelectionOverlayStrokeColor();
        }
        return null;
    }

    public void setSelectionOverlayXORMode(boolean state) {
        if (this.textSelectionManager != null) {
            this.textSelectionManager.setSelectionOverlayXORMode(state);
        }
    }

    public boolean isSelectionOverlayXORMode() {
        if (this.textSelectionManager != null) {
            return this.textSelectionManager.isSelectionOverlayXORMode();
        }
        return false;
    }

    public void select(Mark start, Mark end) {
        if (this.textSelectionManager != null) {
            this.textSelectionManager.setSelection(start, end);
        }
    }

    public void deselectAll() {
        if (this.textSelectionManager != null) {
            this.textSelectionManager.clearSelection();
        }
    }

    public void setProgressivePaint(boolean b) {
        if (this.progressivePaint != b) {
            this.progressivePaint = b;
            this.haltProgressivePaintThread();
        }
    }

    public boolean getProgressivePaint() {
        return this.progressivePaint;
    }

    public Rectangle getRenderRect() {
        Dimension d = this.getSize();
        return new Rectangle(0, 0, d.width, d.height);
    }

    public void immediateRepaint() {
        if (EventQueue.isDispatchThread()) {
            Rectangle visRect = this.getRenderRect();
            if (this.doubleBufferedRendering) {
                this.repaint(visRect.x, visRect.y, visRect.width, visRect.height);
            } else {
                this.paintImmediately(visRect.x, visRect.y, visRect.width, visRect.height);
            }
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        Rectangle visRect = AbstractJGVTComponent.this.getRenderRect();
                        if (AbstractJGVTComponent.this.doubleBufferedRendering) {
                            AbstractJGVTComponent.this.repaint(visRect.x, visRect.y, visRect.width, visRect.height);
                        } else {
                            AbstractJGVTComponent.this.paintImmediately(visRect.x, visRect.y, visRect.width, visRect.height);
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        Rectangle visRect = this.getRenderRect();
        g2d.setComposite(AlphaComposite.SrcOver);
        g2d.setPaint(this.getBackground());
        g2d.fillRect(visRect.x, visRect.y, visRect.width, visRect.height);
        if (this.image != null) {
            if (this.paintingTransform != null) {
                g2d.transform(this.paintingTransform);
            }
            g2d.drawRenderedImage(this.image, null);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            Iterator it = this.overlays.iterator();
            while (it.hasNext()) {
                ((Overlay)it.next()).paint(g);
            }
        }
    }

    public void setPaintingTransform(AffineTransform at) {
        this.paintingTransform = at;
        this.immediateRepaint();
    }

    public AffineTransform getPaintingTransform() {
        return this.paintingTransform;
    }

    public void setRenderingTransform(AffineTransform at) {
        this.setRenderingTransform(at, true);
    }

    public void setRenderingTransform(AffineTransform at, boolean performRedraw) {
        this.renderingTransform = new AffineTransform(at);
        this.suspendInteractions = true;
        if (this.eventDispatcher != null) {
            try {
                this.eventDispatcher.setBaseTransform(this.renderingTransform.createInverse());
            }
            catch (NoninvertibleTransformException e) {
                this.handleException(e);
            }
        }
        if (this.jgvtListeners != null) {
            Iterator iter = this.jgvtListeners.iterator();
            ComponentEvent ce = new ComponentEvent(this, 1337);
            while (iter.hasNext()) {
                JGVTComponentListener l = (JGVTComponentListener)iter.next();
                l.componentTransformChanged(ce);
            }
        }
        if (performRedraw) {
            this.scheduleGVTRendering();
        }
    }

    public AffineTransform getInitialTransform() {
        return new AffineTransform(this.initialTransform);
    }

    public AffineTransform getRenderingTransform() {
        return new AffineTransform(this.renderingTransform);
    }

    public void setDoubleBufferedRendering(boolean b) {
        this.doubleBufferedRendering = b;
    }

    public boolean getDoubleBufferedRendering() {
        return this.doubleBufferedRendering;
    }

    public void addGVTTreeRendererListener(GVTTreeRendererListener l) {
        this.gvtTreeRendererListeners.add(l);
    }

    public void removeGVTTreeRendererListener(GVTTreeRendererListener l) {
        this.gvtTreeRendererListeners.remove(l);
    }

    public void flush() {
        this.renderer.flush();
    }

    public void flush(Rectangle r) {
        this.renderer.flush(r);
    }

    protected ImageRenderer createImageRenderer() {
        return this.rendererFactory.createStaticImageRenderer();
    }

    protected void renderGVTTree() {
        AffineTransform inv;
        Rectangle visRect = this.getRenderRect();
        if (this.gvtRoot == null || visRect.width <= 0 || visRect.height <= 0) {
            return;
        }
        if (this.renderer == null || this.renderer.getTree() != this.gvtRoot) {
            this.renderer = this.createImageRenderer();
            this.renderer.setTree(this.gvtRoot);
        }
        try {
            inv = this.renderingTransform.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            throw new IllegalStateException("NoninvertibleTransformEx:" + e.getMessage());
        }
        Shape s = inv.createTransformedShape(visRect);
        this.gvtTreeRenderer = new GVTTreeRenderer(this.renderer, this.renderingTransform, this.doubleBufferedRendering, s, visRect.width, visRect.height);
        this.gvtTreeRenderer.setPriority(1);
        Iterator it = this.gvtTreeRendererListeners.iterator();
        while (it.hasNext()) {
            this.gvtTreeRenderer.addGVTTreeRendererListener((GVTTreeRendererListener)it.next());
        }
        if (this.eventDispatcher != null) {
            this.eventDispatcher.setEventDispatchEnabled(false);
        }
        this.gvtTreeRenderer.start();
    }

    protected boolean computeRenderingTransform() {
        this.initialTransform = new AffineTransform();
        if (!this.initialTransform.equals(this.renderingTransform)) {
            this.setRenderingTransform(this.initialTransform, false);
            return true;
        }
        return false;
    }

    protected boolean updateRenderingTransform() {
        return false;
    }

    protected void handleException(Exception e) {
    }

    protected void releaseRenderingReferences() {
        this.eventDispatcher = null;
        if (this.textSelectionManager != null) {
            this.overlays.remove(this.textSelectionManager.getSelectionOverlay());
            this.textSelectionManager = null;
        }
        this.renderer = null;
        this.image = null;
        this.gvtRoot = null;
    }

    protected void scheduleGVTRendering() {
        if (this.gvtTreeRenderer != null) {
            this.needRender = true;
            this.gvtTreeRenderer.halt();
        } else {
            this.renderGVTTree();
        }
    }

    private void haltProgressivePaintThread() {
        if (this.progressivePaintThread != null) {
            this.progressivePaintThread.halt();
            this.progressivePaintThread = null;
        }
    }

    protected Listener createListener() {
        return new Listener();
    }

    protected class UnixTextSelectionListener
    extends SelectionAdapter {
        protected UnixTextSelectionListener() {
        }

        public void selectionDone(SelectionEvent evt) {
            int sz;
            if (!AbstractJGVTComponent.this.useUnixTextSelection) {
                return;
            }
            Object o = evt.getSelection();
            if (!(o instanceof CharacterIterator)) {
                return;
            }
            CharacterIterator iter = (CharacterIterator)o;
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                try {
                    securityManager.checkSystemClipboardAccess();
                }
                catch (SecurityException e) {
                    return;
                }
            }
            if ((sz = iter.getEndIndex() - iter.getBeginIndex()) == 0) {
                return;
            }
            char[] cbuff = new char[sz];
            cbuff[0] = iter.first();
            int i2 = 1;
            while (i2 < cbuff.length) {
                cbuff[i2] = iter.next();
                ++i2;
            }
            String strSel = new String(cbuff);
            new Thread(this, strSel){
                private final /* synthetic */ String val$strSel;
                private final /* synthetic */ UnixTextSelectionListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$strSel = val$strSel;
                }

                public void run() {
                    Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                    StringSelection sel = new StringSelection(this.val$strSel);
                    cb.setContents(sel, sel);
                }
            }.start();
        }
    }

    protected class Listener
    implements GVTTreeRendererListener,
    KeyListener,
    MouseListener,
    MouseMotionListener {
        boolean checkClick = false;
        boolean hadDrag = false;
        int startX;
        int startY;
        long startTime;
        long fakeClickTime;
        int MAX_DISP = 16;
        long CLICK_TIME = 200L;

        protected Listener() {
        }

        public void gvtRenderingPrepare(GVTTreeRendererEvent e) {
            AbstractJGVTComponent.this.suspendInteractions = true;
            if (!AbstractJGVTComponent.this.progressivePaint && !AbstractJGVTComponent.this.doubleBufferedRendering) {
                AbstractJGVTComponent.this.image = null;
            }
        }

        public void gvtRenderingStarted(GVTTreeRendererEvent e) {
            if (AbstractJGVTComponent.this.progressivePaint && !AbstractJGVTComponent.this.doubleBufferedRendering) {
                AbstractJGVTComponent.this.image = e.getImage();
                AbstractJGVTComponent.this.progressivePaintThread = new HaltingThread(this){
                    private final /* synthetic */ Listener this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        3 thisThread = this;
                        try {
                            while (!HaltingThread.hasBeenHalted()) {
                                EventQueue.invokeLater(new Runnable(this, thisThread){
                                    private final /* synthetic */ Thread val$thisThread;
                                    private final /* synthetic */ 3 this$2;
                                    {
                                        this.this$2 = this$2;
                                        this.val$thisThread = val$thisThread;
                                    }

                                    public void run() {
                                        if (Listener.access$100((Listener)3.access$000(this.this$2)).progressivePaintThread == this.val$thisThread) {
                                            Rectangle vRect = Listener.access$100(3.access$000(this.this$2)).getRenderRect();
                                            Listener.access$100(3.access$000(this.this$2)).repaint(vRect.x, vRect.y, vRect.width, vRect.height);
                                        }
                                    }
                                });
                                Thread.sleep(200L);
                            }
                        }
                        catch (InterruptedException ie) {
                        }
                        catch (ThreadDeath td) {
                            throw td;
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }

                    static /* synthetic */ Listener access$000(3 x0) {
                        return x0.this$1;
                    }
                };
                AbstractJGVTComponent.this.progressivePaintThread.setPriority(2);
                AbstractJGVTComponent.this.progressivePaintThread.start();
            }
            if (!AbstractJGVTComponent.this.doubleBufferedRendering) {
                AbstractJGVTComponent.this.paintingTransform = null;
                AbstractJGVTComponent.this.suspendInteractions = false;
            }
        }

        public void gvtRenderingCompleted(GVTTreeRendererEvent e) {
            AbstractJGVTComponent.this.haltProgressivePaintThread();
            if (AbstractJGVTComponent.this.doubleBufferedRendering) {
                AbstractJGVTComponent.this.paintingTransform = null;
                AbstractJGVTComponent.this.suspendInteractions = false;
            }
            AbstractJGVTComponent.this.gvtTreeRenderer = null;
            if (AbstractJGVTComponent.this.needRender) {
                AbstractJGVTComponent.this.renderGVTTree();
                AbstractJGVTComponent.this.needRender = false;
            } else {
                AbstractJGVTComponent.this.image = e.getImage();
                AbstractJGVTComponent.this.immediateRepaint();
            }
            if (AbstractJGVTComponent.this.eventDispatcher != null) {
                AbstractJGVTComponent.this.eventDispatcher.setEventDispatchEnabled(true);
            }
        }

        public void gvtRenderingCancelled(GVTTreeRendererEvent e) {
            this.renderingStopped();
        }

        public void gvtRenderingFailed(GVTTreeRendererEvent e) {
            this.renderingStopped();
        }

        private void renderingStopped() {
            AbstractJGVTComponent.this.haltProgressivePaintThread();
            if (AbstractJGVTComponent.this.doubleBufferedRendering) {
                AbstractJGVTComponent.this.suspendInteractions = false;
            }
            AbstractJGVTComponent.this.gvtTreeRenderer = null;
            if (AbstractJGVTComponent.this.needRender) {
                AbstractJGVTComponent.this.renderGVTTree();
                AbstractJGVTComponent.this.needRender = false;
            } else {
                AbstractJGVTComponent.this.immediateRepaint();
            }
            if (AbstractJGVTComponent.this.eventDispatcher != null) {
                AbstractJGVTComponent.this.eventDispatcher.setEventDispatchEnabled(true);
            }
        }

        public void keyTyped(KeyEvent e) {
            this.selectInteractor(e);
            if (AbstractJGVTComponent.this.interactor != null) {
                AbstractJGVTComponent.this.interactor.keyTyped(e);
                this.deselectInteractor();
            } else if (AbstractJGVTComponent.this.eventDispatcher != null) {
                this.dispatchKeyTyped(e);
            }
        }

        protected void dispatchKeyTyped(KeyEvent e) {
            AbstractJGVTComponent.this.eventDispatcher.keyTyped(e);
        }

        public void keyPressed(KeyEvent e) {
            this.selectInteractor(e);
            if (AbstractJGVTComponent.this.interactor != null) {
                AbstractJGVTComponent.this.interactor.keyPressed(e);
                this.deselectInteractor();
            } else if (AbstractJGVTComponent.this.eventDispatcher != null) {
                this.dispatchKeyPressed(e);
            }
        }

        protected void dispatchKeyPressed(KeyEvent e) {
            AbstractJGVTComponent.this.eventDispatcher.keyPressed(e);
        }

        public void keyReleased(KeyEvent e) {
            this.selectInteractor(e);
            if (AbstractJGVTComponent.this.interactor != null) {
                AbstractJGVTComponent.this.interactor.keyReleased(e);
                this.deselectInteractor();
            } else if (AbstractJGVTComponent.this.eventDispatcher != null) {
                this.dispatchKeyReleased(e);
            }
        }

        protected void dispatchKeyReleased(KeyEvent e) {
            AbstractJGVTComponent.this.eventDispatcher.keyReleased(e);
        }

        public void mouseClicked(MouseEvent e) {
            if (this.fakeClickTime != e.getWhen()) {
                this.handleMouseClicked(e);
            }
        }

        public void handleMouseClicked(MouseEvent e) {
            this.selectInteractor(e);
            if (AbstractJGVTComponent.this.interactor != null) {
                AbstractJGVTComponent.this.interactor.mouseClicked(e);
                this.deselectInteractor();
            } else if (AbstractJGVTComponent.this.eventDispatcher != null) {
                this.dispatchMouseClicked(e);
            }
        }

        protected void dispatchMouseClicked(MouseEvent e) {
            AbstractJGVTComponent.this.eventDispatcher.mouseClicked(e);
        }

        public void mousePressed(MouseEvent e) {
            this.startX = e.getX();
            this.startY = e.getY();
            this.startTime = e.getWhen();
            this.checkClick = true;
            this.selectInteractor(e);
            if (AbstractJGVTComponent.this.interactor != null) {
                AbstractJGVTComponent.this.interactor.mousePressed(e);
                this.deselectInteractor();
            } else if (AbstractJGVTComponent.this.eventDispatcher != null) {
                this.dispatchMousePressed(e);
            }
        }

        protected void dispatchMousePressed(MouseEvent e) {
            AbstractJGVTComponent.this.eventDispatcher.mousePressed(e);
        }

        public void mouseReleased(MouseEvent e) {
            if (this.checkClick && this.hadDrag) {
                int dx = this.startX - e.getX();
                int dy = this.startY - e.getY();
                long cTime = e.getWhen();
                if (dx * dx + dy * dy < this.MAX_DISP && cTime - this.startTime < this.CLICK_TIME) {
                    MouseEvent click = new MouseEvent(e.getComponent(), 500, e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger());
                    this.fakeClickTime = click.getWhen();
                    this.handleMouseClicked(click);
                }
            }
            this.checkClick = false;
            this.hadDrag = false;
            this.selectInteractor(e);
            if (AbstractJGVTComponent.this.interactor != null) {
                AbstractJGVTComponent.this.interactor.mouseReleased(e);
                this.deselectInteractor();
            } else if (AbstractJGVTComponent.this.eventDispatcher != null) {
                this.dispatchMouseReleased(e);
            }
        }

        protected void dispatchMouseReleased(MouseEvent e) {
            AbstractJGVTComponent.this.eventDispatcher.mouseReleased(e);
        }

        public void mouseEntered(MouseEvent e) {
            this.selectInteractor(e);
            if (AbstractJGVTComponent.this.interactor != null) {
                AbstractJGVTComponent.this.interactor.mouseEntered(e);
                this.deselectInteractor();
            } else if (AbstractJGVTComponent.this.eventDispatcher != null) {
                this.dispatchMouseEntered(e);
            }
        }

        protected void dispatchMouseEntered(MouseEvent e) {
            AbstractJGVTComponent.this.eventDispatcher.mouseEntered(e);
        }

        public void mouseExited(MouseEvent e) {
            this.selectInteractor(e);
            if (AbstractJGVTComponent.this.interactor != null) {
                AbstractJGVTComponent.this.interactor.mouseExited(e);
                this.deselectInteractor();
            } else if (AbstractJGVTComponent.this.eventDispatcher != null) {
                this.dispatchMouseExited(e);
            }
        }

        protected void dispatchMouseExited(MouseEvent e) {
            AbstractJGVTComponent.this.eventDispatcher.mouseExited(e);
        }

        public void mouseDragged(MouseEvent e) {
            int dy;
            this.hadDrag = true;
            int dx = this.startX - e.getX();
            if (dx * dx + (dy = this.startY - e.getY()) * dy > this.MAX_DISP) {
                this.checkClick = false;
            }
            this.selectInteractor(e);
            if (AbstractJGVTComponent.this.interactor != null) {
                AbstractJGVTComponent.this.interactor.mouseDragged(e);
                this.deselectInteractor();
            } else if (AbstractJGVTComponent.this.eventDispatcher != null) {
                this.dispatchMouseDragged(e);
            }
        }

        protected void dispatchMouseDragged(MouseEvent e) {
            AbstractJGVTComponent.this.eventDispatcher.mouseDragged(e);
        }

        public void mouseMoved(MouseEvent e) {
            this.selectInteractor(e);
            if (AbstractJGVTComponent.this.interactor != null) {
                if (Platform.isOSX && AbstractJGVTComponent.this.interactor instanceof AbstractZoomInteractor) {
                    this.mouseDragged(e);
                } else {
                    AbstractJGVTComponent.this.interactor.mouseMoved(e);
                }
                this.deselectInteractor();
            } else if (AbstractJGVTComponent.this.eventDispatcher != null) {
                this.dispatchMouseMoved(e);
            }
        }

        protected void dispatchMouseMoved(MouseEvent e) {
            AbstractJGVTComponent.this.eventDispatcher.mouseMoved(e);
        }

        protected void selectInteractor(InputEvent ie) {
            if (!AbstractJGVTComponent.this.disableInteractions && !AbstractJGVTComponent.this.suspendInteractions && AbstractJGVTComponent.this.interactor == null && AbstractJGVTComponent.this.gvtRoot != null) {
                Iterator it = AbstractJGVTComponent.this.interactors.iterator();
                while (it.hasNext()) {
                    Interactor i2 = (Interactor)it.next();
                    if (!i2.startInteraction(ie)) continue;
                    AbstractJGVTComponent.this.interactor = i2;
                    break;
                }
            }
        }

        protected void deselectInteractor() {
            if (AbstractJGVTComponent.this.interactor.endInteraction()) {
                AbstractJGVTComponent.this.interactor = null;
            }
        }

        static /* synthetic */ AbstractJGVTComponent access$100(Listener x0) {
            return x0.AbstractJGVTComponent.this;
        }
    }
}

