/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.svg;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.swing.gvt.Overlay;

public class SVGUpdateOverlay
implements Overlay {
    List rects = new LinkedList();
    int size;
    int updateCount;
    int[] counts;

    public SVGUpdateOverlay(int size, int numUpdates) {
        this.size = size;
        this.counts = new int[numUpdates];
    }

    public void addRect(Rectangle r) {
        this.rects.add(r);
        if (this.rects.size() > this.size) {
            this.rects.remove(0);
        }
        ++this.updateCount;
    }

    public void endUpdate() {
        int i2 = 0;
        while (i2 < this.counts.length - 1) {
            this.counts[i2] = this.counts[i2 + 1];
            ++i2;
        }
        this.counts[i2] = this.updateCount;
        this.updateCount = 0;
        int num = this.rects.size();
        i2 = this.counts.length - 1;
        while (i2 >= 0) {
            if (this.counts[i2] > num) {
                this.counts[i2] = num;
            }
            num -= this.counts[i2];
            --i2;
        }
        this.counts[0] = this.counts[0] + num;
    }

    public void paint(Graphics g) {
        Iterator i2 = this.rects.iterator();
        int count = 0;
        int idx = 0;
        int group = 0;
        while (group < this.counts.length - 1 && idx == this.counts[group]) {
            ++group;
        }
        int cmax = this.counts.length - 1;
        while (i2.hasNext()) {
            Rectangle r = (Rectangle)i2.next();
            Color c = new Color(1.0f, (float)(cmax - group) / (float)cmax, 0.0f, ((float)count + 1.0f) / (float)this.rects.size());
            g.setColor(c);
            g.drawRect(r.x, r.y, r.width, r.height);
            ++count;
            ++idx;
            while (group < this.counts.length - 1 && idx == this.counts[group]) {
                ++group;
                idx = 0;
            }
        }
    }
}

