/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

import java.io.IOException;
import java.io.InputStream;

public class Base64DecodeStream
extends InputStream {
    InputStream src;
    private static final byte[] pem_array = new byte[256];
    byte[] decode_buffer = new byte[4];
    byte[] out_buffer = new byte[3];
    int out_offset = 3;
    boolean EOF = false;

    public Base64DecodeStream(InputStream src) {
        this.src = src;
    }

    public boolean markSupported() {
        return false;
    }

    public void close() throws IOException {
        this.EOF = true;
    }

    public int available() throws IOException {
        return 3 - this.out_offset;
    }

    public int read() throws IOException {
        if (this.out_offset == 3 && (this.EOF || this.getNextAtom())) {
            this.EOF = true;
            return -1;
        }
        return this.out_buffer[this.out_offset++] & 0xFF;
    }

    public int read(byte[] out, int offset, int len) throws IOException {
        int idx = 0;
        while (idx < len) {
            if (this.out_offset == 3 && (this.EOF || this.getNextAtom())) {
                this.EOF = true;
                if (idx == 0) {
                    return -1;
                }
                return idx;
            }
            out[offset + idx] = this.out_buffer[this.out_offset++];
            ++idx;
        }
        return idx;
    }

    final boolean getNextAtom() throws IOException {
        int off = 0;
        while (off != 4) {
            int count = this.src.read(this.decode_buffer, off, 4 - off);
            if (count == -1) {
                return true;
            }
            int in = off;
            int out = off;
            while (in < off + count) {
                if (this.decode_buffer[in] != 10 && this.decode_buffer[in] != 13 && this.decode_buffer[in] != 32) {
                    this.decode_buffer[out++] = this.decode_buffer[in];
                }
                ++in;
            }
            off = out;
        }
        byte a = pem_array[this.decode_buffer[0] & 0xFF];
        byte b = pem_array[this.decode_buffer[1] & 0xFF];
        byte c = pem_array[this.decode_buffer[2] & 0xFF];
        byte d = pem_array[this.decode_buffer[3] & 0xFF];
        this.out_buffer[0] = (byte)(a << 2 | b >>> 4);
        this.out_buffer[1] = (byte)(b << 4 | c >>> 2);
        this.out_buffer[2] = (byte)(c << 6 | d);
        if (this.decode_buffer[3] != 61) {
            this.out_offset = 0;
        } else if (this.decode_buffer[2] == 61) {
            this.out_buffer[2] = this.out_buffer[0];
            this.out_offset = 2;
            this.EOF = true;
        } else {
            this.out_buffer[2] = this.out_buffer[1];
            this.out_buffer[1] = this.out_buffer[0];
            this.out_offset = 1;
            this.EOF = true;
        }
        return false;
    }

    static {
        int i2 = 0;
        while (i2 < pem_array.length) {
            Base64DecodeStream.pem_array[i2] = -1;
            ++i2;
        }
        int idx = 0;
        int c = 65;
        while (c <= 90) {
            Base64DecodeStream.pem_array[c] = (byte)idx++;
            c = (char)(c + 1);
        }
        int c2 = 97;
        while (c2 <= 122) {
            Base64DecodeStream.pem_array[c2] = (byte)idx++;
            c2 = (char)(c2 + 1);
        }
        int c3 = 48;
        while (c3 <= 57) {
            Base64DecodeStream.pem_array[c3] = (byte)idx++;
            c3 = (char)(c3 + 1);
        }
        Base64DecodeStream.pem_array[43] = (byte)idx++;
        Base64DecodeStream.pem_array[47] = (byte)idx++;
    }
}

