/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.interpolation;

import org.apache.commons.math.DimensionMismatchException;
import org.apache.commons.math.MathException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.interpolation.BicubicSplineInterpolatingFunction;
import org.apache.commons.math.analysis.interpolation.BivariateRealGridInterpolator;
import org.apache.commons.math.analysis.interpolation.SplineInterpolator;
import org.apache.commons.math.analysis.polynomials.PolynomialSplineFunction;
import org.apache.commons.math.exception.NoDataException;
import org.apache.commons.math.util.MathUtils;

public class BicubicSplineInterpolator
implements BivariateRealGridInterpolator {
    @Override
    public BicubicSplineInterpolatingFunction interpolate(double[] xval, double[] yval, double[][] fval) throws MathException, IllegalArgumentException {
        if (xval.length == 0 || yval.length == 0 || fval.length == 0) {
            throw new NoDataException();
        }
        if (xval.length != fval.length) {
            throw new DimensionMismatchException(xval.length, fval.length);
        }
        MathUtils.checkOrder(xval);
        MathUtils.checkOrder(yval);
        int xLen = xval.length;
        int yLen = yval.length;
        double[][] fX = new double[yLen][xLen];
        int i2 = 0;
        while (i2 < xLen) {
            if (fval[i2].length != yLen) {
                throw new DimensionMismatchException(fval[i2].length, yLen);
            }
            int j = 0;
            while (j < yLen) {
                fX[j][i2] = fval[i2][j];
                ++j;
            }
            ++i2;
        }
        SplineInterpolator spInterpolator = new SplineInterpolator();
        PolynomialSplineFunction[] ySplineX = new PolynomialSplineFunction[yLen];
        int j = 0;
        while (j < yLen) {
            ySplineX[j] = spInterpolator.interpolate(xval, fX[j]);
            ++j;
        }
        PolynomialSplineFunction[] xSplineY = new PolynomialSplineFunction[xLen];
        int i3 = 0;
        while (i3 < xLen) {
            xSplineY[i3] = spInterpolator.interpolate(yval, fval[i3]);
            ++i3;
        }
        double[][] dFdX = new double[xLen][yLen];
        int j2 = 0;
        while (j2 < yLen) {
            UnivariateRealFunction f = ySplineX[j2].derivative();
            int i4 = 0;
            while (i4 < xLen) {
                dFdX[i4][j2] = f.value(xval[i4]);
                ++i4;
            }
            ++j2;
        }
        double[][] dFdY = new double[xLen][yLen];
        int i5 = 0;
        while (i5 < xLen) {
            UnivariateRealFunction f = xSplineY[i5].derivative();
            int j3 = 0;
            while (j3 < yLen) {
                dFdY[i5][j3] = f.value(yval[j3]);
                ++j3;
            }
            ++i5;
        }
        double[][] d2FdXdY = new double[xLen][yLen];
        int i6 = 0;
        while (i6 < xLen) {
            int nI = this.nextIndex(i6, xLen);
            int pI = this.previousIndex(i6);
            int j4 = 0;
            while (j4 < yLen) {
                int nJ = this.nextIndex(j4, yLen);
                int pJ = this.previousIndex(j4);
                d2FdXdY[i6][j4] = (fval[nI][nJ] - fval[nI][pJ] - fval[pI][nJ] + fval[pI][pJ]) / ((xval[nI] - xval[pI]) * (yval[nJ] - yval[pJ]));
                ++j4;
            }
            ++i6;
        }
        return new BicubicSplineInterpolatingFunction(xval, yval, fval, dFdX, dFdY, d2FdXdY);
    }

    private int nextIndex(int i2, int max) {
        int index = i2 + 1;
        return index < max ? index : index - 1;
    }

    private int previousIndex(int i2) {
        int index = i2 - 1;
        return index >= 0 ? index : 0;
    }
}

