/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.interpolation;

import org.apache.commons.math.analysis.interpolation.UnivariateRealInterpolator;
import org.apache.commons.math.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math.analysis.polynomials.PolynomialSplineFunction;
import org.apache.commons.math.exception.DimensionMismatchException;
import org.apache.commons.math.exception.NumberIsTooSmallException;
import org.apache.commons.math.exception.util.Localizable;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.util.MathUtils;

public class LinearInterpolator
implements UnivariateRealInterpolator {
    @Override
    public PolynomialSplineFunction interpolate(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new DimensionMismatchException(x.length, y.length);
        }
        if (x.length < 2) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.NUMBER_OF_POINTS, (Number)x.length, (Number)2, true);
        }
        int n = x.length - 1;
        MathUtils.checkOrder(x);
        double[] m = new double[n];
        int i2 = 0;
        while (i2 < n) {
            m[i2] = (y[i2 + 1] - y[i2]) / (x[i2 + 1] - x[i2]);
            ++i2;
        }
        PolynomialFunction[] polynomials = new PolynomialFunction[n];
        double[] coefficients = new double[2];
        int i3 = 0;
        while (i3 < n) {
            coefficients[0] = y[i3];
            coefficients[1] = m[i3];
            polynomials[i3] = new PolynomialFunction(coefficients);
            ++i3;
        }
        return new PolynomialSplineFunction(x, polynomials);
    }
}

