/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.interpolation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math.DimensionMismatchException;
import org.apache.commons.math.analysis.MultivariateRealFunction;
import org.apache.commons.math.exception.NoDataException;
import org.apache.commons.math.linear.ArrayRealVector;
import org.apache.commons.math.linear.RealVector;
import org.apache.commons.math.random.UnitSphereRandomVectorGenerator;
import org.apache.commons.math.util.FastMath;

public class MicrosphereInterpolatingFunction
implements MultivariateRealFunction {
    private final int dimension;
    private final List<MicrosphereSurfaceElement> microsphere;
    private final double brightnessExponent;
    private final Map<RealVector, Double> samples;

    public MicrosphereInterpolatingFunction(double[][] xval, double[] yval, int brightnessExponent, int microsphereElements, UnitSphereRandomVectorGenerator rand) throws DimensionMismatchException, NoDataException {
        if (xval.length == 0 || xval[0] == null) {
            throw new NoDataException();
        }
        if (xval.length != yval.length) {
            throw new DimensionMismatchException(xval.length, yval.length);
        }
        this.dimension = xval[0].length;
        this.brightnessExponent = brightnessExponent;
        this.samples = new HashMap<RealVector, Double>(yval.length);
        int i2 = 0;
        while (i2 < xval.length) {
            double[] xvalI = xval[i2];
            if (xvalI.length != this.dimension) {
                throw new DimensionMismatchException(xvalI.length, this.dimension);
            }
            this.samples.put(new ArrayRealVector(xvalI), yval[i2]);
            ++i2;
        }
        this.microsphere = new ArrayList<MicrosphereSurfaceElement>(microsphereElements);
        i2 = 0;
        while (i2 < microsphereElements) {
            this.microsphere.add(new MicrosphereSurfaceElement(rand.nextVector()));
            ++i2;
        }
    }

    @Override
    public double value(double[] point) {
        ArrayRealVector p = new ArrayRealVector(point);
        for (MicrosphereSurfaceElement microsphereSurfaceElement : this.microsphere) {
            microsphereSurfaceElement.reset();
        }
        for (Map.Entry entry : this.samples.entrySet()) {
            RealVector diff = ((RealVector)entry.getKey()).subtract(p);
            double diffNorm = diff.getNorm();
            if (FastMath.abs(diffNorm) < FastMath.ulp(1.0)) {
                return (Double)entry.getValue();
            }
            for (MicrosphereSurfaceElement md : this.microsphere) {
                double w = FastMath.pow(diffNorm, -this.brightnessExponent);
                md.store(this.cosAngle(diff, md.normal()) * w, entry);
            }
        }
        double d = 0.0;
        double totalWeight = 0.0;
        for (MicrosphereSurfaceElement md : this.microsphere) {
            double iV = md.illumination();
            Map.Entry<RealVector, Double> sd = md.sample();
            if (sd == null) continue;
            d += iV * sd.getValue();
            totalWeight += iV;
        }
        return d / totalWeight;
    }

    private double cosAngle(RealVector v, RealVector w) {
        return v.dotProduct(w) / (v.getNorm() * w.getNorm());
    }

    private static class MicrosphereSurfaceElement {
        private final RealVector normal;
        private double brightestIllumination;
        private Map.Entry<RealVector, Double> brightestSample;

        MicrosphereSurfaceElement(double[] n) {
            this.normal = new ArrayRealVector(n);
        }

        RealVector normal() {
            return this.normal;
        }

        void reset() {
            this.brightestIllumination = 0.0;
            this.brightestSample = null;
        }

        void store(double illuminationFromSample, Map.Entry<RealVector, Double> sample) {
            if (illuminationFromSample > this.brightestIllumination) {
                this.brightestIllumination = illuminationFromSample;
                this.brightestSample = sample;
            }
        }

        double illumination() {
            return this.brightestIllumination;
        }

        Map.Entry<RealVector, Double> sample() {
            return this.brightestSample;
        }
    }
}

