/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.interpolation;

import org.apache.commons.math.DimensionMismatchException;
import org.apache.commons.math.MathException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.analysis.BivariateRealFunction;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.interpolation.BicubicSplineInterpolatingFunction;
import org.apache.commons.math.analysis.interpolation.BivariateRealGridInterpolator;
import org.apache.commons.math.analysis.interpolation.SplineInterpolator;
import org.apache.commons.math.analysis.polynomials.PolynomialSplineFunction;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.util.MathUtils;

@Deprecated
public class SmoothingBicubicSplineInterpolator
implements BivariateRealGridInterpolator {
    @Override
    public BivariateRealFunction interpolate(double[] xval, double[] yval, double[][] zval) throws MathException, IllegalArgumentException {
        int i2;
        if (xval.length == 0 || yval.length == 0 || zval.length == 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NO_DATA, new Object[0]);
        }
        if (xval.length != zval.length) {
            throw new DimensionMismatchException(xval.length, zval.length);
        }
        MathUtils.checkOrder(xval, MathUtils.OrderDirection.INCREASING, true);
        MathUtils.checkOrder(yval, MathUtils.OrderDirection.INCREASING, true);
        int xLen = xval.length;
        int yLen = yval.length;
        double[][] zX = new double[yLen][xLen];
        int i3 = 0;
        while (i3 < xLen) {
            if (zval[i3].length != yLen) {
                throw new DimensionMismatchException(zval[i3].length, yLen);
            }
            int j = 0;
            while (j < yLen) {
                zX[j][i3] = zval[i3][j];
                ++j;
            }
            ++i3;
        }
        SplineInterpolator spInterpolator = new SplineInterpolator();
        PolynomialSplineFunction[] ySplineX = new PolynomialSplineFunction[yLen];
        int j = 0;
        while (j < yLen) {
            ySplineX[j] = spInterpolator.interpolate(xval, zX[j]);
            ++j;
        }
        double[][] zY_1 = new double[xLen][yLen];
        int j2 = 0;
        while (j2 < yLen) {
            PolynomialSplineFunction f = ySplineX[j2];
            i2 = 0;
            while (i2 < xLen) {
                zY_1[i2][j2] = f.value(xval[i2]);
                ++i2;
            }
            ++j2;
        }
        PolynomialSplineFunction[] xSplineY = new PolynomialSplineFunction[xLen];
        int i4 = 0;
        while (i4 < xLen) {
            xSplineY[i4] = spInterpolator.interpolate(yval, zY_1[i4]);
            ++i4;
        }
        double[][] zY_2 = new double[xLen][yLen];
        i2 = 0;
        while (i2 < xLen) {
            PolynomialSplineFunction f = xSplineY[i2];
            int j3 = 0;
            while (j3 < yLen) {
                zY_2[i2][j3] = f.value(yval[j3]);
                ++j3;
            }
            ++i2;
        }
        double[][] dZdX = new double[xLen][yLen];
        int j4 = 0;
        while (j4 < yLen) {
            UnivariateRealFunction f = ySplineX[j4].derivative();
            int i5 = 0;
            while (i5 < xLen) {
                dZdX[i5][j4] = f.value(xval[i5]);
                ++i5;
            }
            ++j4;
        }
        double[][] dZdY = new double[xLen][yLen];
        int i6 = 0;
        while (i6 < xLen) {
            UnivariateRealFunction f = xSplineY[i6].derivative();
            int j5 = 0;
            while (j5 < yLen) {
                dZdY[i6][j5] = f.value(yval[j5]);
                ++j5;
            }
            ++i6;
        }
        double[][] dZdXdY = new double[xLen][yLen];
        int i7 = 0;
        while (i7 < xLen) {
            int nI = this.nextIndex(i7, xLen);
            int pI = this.previousIndex(i7);
            int j6 = 0;
            while (j6 < yLen) {
                int nJ = this.nextIndex(j6, yLen);
                int pJ = this.previousIndex(j6);
                dZdXdY[i7][j6] = (zY_2[nI][nJ] - zY_2[nI][pJ] - zY_2[pI][nJ] + zY_2[pI][pJ]) / ((xval[nI] - xval[pI]) * (yval[nJ] - yval[pJ]));
                ++j6;
            }
            ++i7;
        }
        return new BicubicSplineInterpolatingFunction(xval, yval, zY_2, dZdX, dZdY, dZdXdY);
    }

    private int nextIndex(int i2, int max) {
        int index = i2 + 1;
        return index < max ? index : index - 1;
    }

    private int previousIndex(int i2) {
        int index = i2 - 1;
        return index >= 0 ? index : 0;
    }
}

