/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.interpolation;

import org.apache.commons.math.analysis.interpolation.UnivariateRealInterpolator;
import org.apache.commons.math.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math.analysis.polynomials.PolynomialSplineFunction;
import org.apache.commons.math.exception.DimensionMismatchException;
import org.apache.commons.math.exception.NumberIsTooSmallException;
import org.apache.commons.math.exception.util.Localizable;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.util.MathUtils;

public class SplineInterpolator
implements UnivariateRealInterpolator {
    @Override
    public PolynomialSplineFunction interpolate(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new DimensionMismatchException(x.length, y.length);
        }
        if (x.length < 3) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.NUMBER_OF_POINTS, (Number)x.length, (Number)3, true);
        }
        int n = x.length - 1;
        MathUtils.checkOrder(x);
        double[] h = new double[n];
        int i2 = 0;
        while (i2 < n) {
            h[i2] = x[i2 + 1] - x[i2];
            ++i2;
        }
        double[] mu = new double[n];
        double[] z = new double[n + 1];
        mu[0] = 0.0;
        z[0] = 0.0;
        double g = 0.0;
        int i3 = 1;
        while (i3 < n) {
            g = 2.0 * (x[i3 + 1] - x[i3 - 1]) - h[i3 - 1] * mu[i3 - 1];
            mu[i3] = h[i3] / g;
            z[i3] = (3.0 * (y[i3 + 1] * h[i3 - 1] - y[i3] * (x[i3 + 1] - x[i3 - 1]) + y[i3 - 1] * h[i3]) / (h[i3 - 1] * h[i3]) - h[i3 - 1] * z[i3 - 1]) / g;
            ++i3;
        }
        double[] b = new double[n];
        double[] c = new double[n + 1];
        double[] d = new double[n];
        z[n] = 0.0;
        c[n] = 0.0;
        int j = n - 1;
        while (j >= 0) {
            c[j] = z[j] - mu[j] * c[j + 1];
            b[j] = (y[j + 1] - y[j]) / h[j] - h[j] * (c[j + 1] + 2.0 * c[j]) / 3.0;
            d[j] = (c[j + 1] - c[j]) / (3.0 * h[j]);
            --j;
        }
        PolynomialFunction[] polynomials = new PolynomialFunction[n];
        double[] coefficients = new double[4];
        int i4 = 0;
        while (i4 < n) {
            coefficients[0] = y[i4];
            coefficients[1] = b[i4];
            coefficients[2] = c[i4];
            coefficients[3] = d[i4];
            polynomials[i4] = new PolynomialFunction(coefficients);
            ++i4;
        }
        return new PolynomialSplineFunction(x, polynomials);
    }
}

