/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.interpolation;

import org.apache.commons.math.MathException;
import org.apache.commons.math.analysis.interpolation.BicubicSplineInterpolatingFunction;
import org.apache.commons.math.analysis.interpolation.BicubicSplineInterpolator;
import org.apache.commons.math.analysis.interpolation.TricubicSplineInterpolatingFunction;
import org.apache.commons.math.analysis.interpolation.TrivariateRealGridInterpolator;
import org.apache.commons.math.exception.DimensionMismatchException;
import org.apache.commons.math.exception.NoDataException;
import org.apache.commons.math.util.MathUtils;

public class TricubicSplineInterpolator
implements TrivariateRealGridInterpolator {
    @Override
    public TricubicSplineInterpolatingFunction interpolate(double[] xval, double[] yval, double[] zval, double[][][] fval) throws MathException {
        int i2;
        if (xval.length == 0 || yval.length == 0 || zval.length == 0 || fval.length == 0) {
            throw new NoDataException();
        }
        if (xval.length != fval.length) {
            throw new DimensionMismatchException(xval.length, fval.length);
        }
        MathUtils.checkOrder(xval);
        MathUtils.checkOrder(yval);
        MathUtils.checkOrder(zval);
        int xLen = xval.length;
        int yLen = yval.length;
        int zLen = zval.length;
        double[][][] fvalXY = new double[zLen][xLen][yLen];
        double[][][] fvalZX = new double[yLen][zLen][xLen];
        int i3 = 0;
        while (i3 < xLen) {
            if (fval[i3].length != yLen) {
                throw new DimensionMismatchException(fval[i3].length, yLen);
            }
            int j = 0;
            while (j < yLen) {
                if (fval[i3][j].length != zLen) {
                    throw new DimensionMismatchException(fval[i3][j].length, zLen);
                }
                int k = 0;
                while (k < zLen) {
                    double v;
                    fvalXY[k][i3][j] = v = fval[i3][j][k];
                    fvalZX[j][k][i3] = v;
                    ++k;
                }
                ++j;
            }
            ++i3;
        }
        BicubicSplineInterpolator bsi = new BicubicSplineInterpolator();
        BicubicSplineInterpolatingFunction[] xSplineYZ = new BicubicSplineInterpolatingFunction[xLen];
        int i4 = 0;
        while (i4 < xLen) {
            xSplineYZ[i4] = bsi.interpolate(yval, zval, fval[i4]);
            ++i4;
        }
        BicubicSplineInterpolatingFunction[] ySplineZX = new BicubicSplineInterpolatingFunction[yLen];
        int j = 0;
        while (j < yLen) {
            ySplineZX[j] = bsi.interpolate(zval, xval, fvalZX[j]);
            ++j;
        }
        BicubicSplineInterpolatingFunction[] zSplineXY = new BicubicSplineInterpolatingFunction[zLen];
        int k = 0;
        while (k < zLen) {
            zSplineXY[k] = bsi.interpolate(xval, yval, fvalXY[k]);
            ++k;
        }
        double[][][] dFdX = new double[xLen][yLen][zLen];
        double[][][] dFdY = new double[xLen][yLen][zLen];
        double[][][] d2FdXdY = new double[xLen][yLen][zLen];
        int k2 = 0;
        while (k2 < zLen) {
            BicubicSplineInterpolatingFunction f = zSplineXY[k2];
            i2 = 0;
            while (i2 < xLen) {
                double x = xval[i2];
                int j2 = 0;
                while (j2 < yLen) {
                    double y = yval[j2];
                    dFdX[i2][j2][k2] = f.partialDerivativeX(x, y);
                    dFdY[i2][j2][k2] = f.partialDerivativeY(x, y);
                    d2FdXdY[i2][j2][k2] = f.partialDerivativeXY(x, y);
                    ++j2;
                }
                ++i2;
            }
            ++k2;
        }
        double[][][] dFdZ = new double[xLen][yLen][zLen];
        double[][][] d2FdYdZ = new double[xLen][yLen][zLen];
        i2 = 0;
        while (i2 < xLen) {
            BicubicSplineInterpolatingFunction f = xSplineYZ[i2];
            int j3 = 0;
            while (j3 < yLen) {
                double y = yval[j3];
                int k3 = 0;
                while (k3 < zLen) {
                    double z = zval[k3];
                    dFdZ[i2][j3][k3] = f.partialDerivativeY(y, z);
                    d2FdYdZ[i2][j3][k3] = f.partialDerivativeXY(y, z);
                    ++k3;
                }
                ++j3;
            }
            ++i2;
        }
        double[][][] d2FdZdX = new double[xLen][yLen][zLen];
        int j4 = 0;
        while (j4 < yLen) {
            BicubicSplineInterpolatingFunction f = ySplineZX[j4];
            int k4 = 0;
            while (k4 < zLen) {
                double z = zval[k4];
                int i5 = 0;
                while (i5 < xLen) {
                    double x = xval[i5];
                    d2FdZdX[i5][j4][k4] = f.partialDerivativeXY(z, x);
                    ++i5;
                }
                ++k4;
            }
            ++j4;
        }
        double[][][] d3FdXdYdZ = new double[xLen][yLen][zLen];
        int i6 = 0;
        while (i6 < xLen) {
            int nI = this.nextIndex(i6, xLen);
            int pI = this.previousIndex(i6);
            int j5 = 0;
            while (j5 < yLen) {
                int nJ = this.nextIndex(j5, yLen);
                int pJ = this.previousIndex(j5);
                int k5 = 0;
                while (k5 < zLen) {
                    int nK = this.nextIndex(k5, zLen);
                    int pK = this.previousIndex(k5);
                    d3FdXdYdZ[i6][j5][k5] = (fval[nI][nJ][nK] - fval[nI][pJ][nK] - fval[pI][nJ][nK] + fval[pI][pJ][nK] - fval[nI][nJ][pK] + fval[nI][pJ][pK] + fval[pI][nJ][pK] - fval[pI][pJ][pK]) / ((xval[nI] - xval[pI]) * (yval[nJ] - yval[pJ]) * (zval[nK] - zval[pK]));
                    ++k5;
                }
                ++j5;
            }
            ++i6;
        }
        return new TricubicSplineInterpolatingFunction(xval, yval, zval, fval, dFdX, dFdY, dFdZ, d2FdXdY, d2FdZdX, d2FdYdZ, d3FdXdYdZ);
    }

    private int nextIndex(int i2, int max) {
        int index = i2 + 1;
        return index < max ? index : index - 1;
    }

    private int previousIndex(int i2) {
        int index = i2 - 1;
        return index >= 0 ? index : 0;
    }
}

