/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.polynomials;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.math.analysis.DifferentiableUnivariateRealFunction;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.exception.NoDataException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.util.FastMath;

public class PolynomialFunction
implements DifferentiableUnivariateRealFunction,
Serializable {
    private static final long serialVersionUID = -7726511984200295583L;
    private final double[] coefficients;

    /*
     * Unable to fully structure code
     */
    public PolynomialFunction(double[] c) {
        super();
        n = c.length;
        if (n != 0) ** GOTO lbl6
        throw new NoDataException(LocalizedFormats.EMPTY_POLYNOMIALS_COEFFICIENTS_ARRAY);
lbl-1000:
        // 1 sources

        {
            --n;
lbl6:
            // 2 sources

            ** while (n > 1 && c[n - 1] == 0.0)
        }
lbl7:
        // 1 sources

        this.coefficients = new double[n];
        System.arraycopy(c, 0, this.coefficients, 0, n);
    }

    @Override
    public double value(double x) {
        return PolynomialFunction.evaluate(this.coefficients, x);
    }

    public int degree() {
        return this.coefficients.length - 1;
    }

    public double[] getCoefficients() {
        return (double[])this.coefficients.clone();
    }

    protected static double evaluate(double[] coefficients, double argument) {
        int n = coefficients.length;
        if (n == 0) {
            throw new NoDataException(LocalizedFormats.EMPTY_POLYNOMIALS_COEFFICIENTS_ARRAY);
        }
        double result = coefficients[n - 1];
        int j = n - 2;
        while (j >= 0) {
            result = argument * result + coefficients[j];
            --j;
        }
        return result;
    }

    public PolynomialFunction add(PolynomialFunction p) {
        int lowLength = FastMath.min(this.coefficients.length, p.coefficients.length);
        int highLength = FastMath.max(this.coefficients.length, p.coefficients.length);
        double[] newCoefficients = new double[highLength];
        int i2 = 0;
        while (i2 < lowLength) {
            newCoefficients[i2] = this.coefficients[i2] + p.coefficients[i2];
            ++i2;
        }
        System.arraycopy(this.coefficients.length < p.coefficients.length ? p.coefficients : this.coefficients, lowLength, newCoefficients, lowLength, highLength - lowLength);
        return new PolynomialFunction(newCoefficients);
    }

    public PolynomialFunction subtract(PolynomialFunction p) {
        int lowLength = FastMath.min(this.coefficients.length, p.coefficients.length);
        int highLength = FastMath.max(this.coefficients.length, p.coefficients.length);
        double[] newCoefficients = new double[highLength];
        int i2 = 0;
        while (i2 < lowLength) {
            newCoefficients[i2] = this.coefficients[i2] - p.coefficients[i2];
            ++i2;
        }
        if (this.coefficients.length < p.coefficients.length) {
            i2 = lowLength;
            while (i2 < highLength) {
                newCoefficients[i2] = -p.coefficients[i2];
                ++i2;
            }
        } else {
            System.arraycopy(this.coefficients, lowLength, newCoefficients, lowLength, highLength - lowLength);
        }
        return new PolynomialFunction(newCoefficients);
    }

    public PolynomialFunction negate() {
        double[] newCoefficients = new double[this.coefficients.length];
        int i2 = 0;
        while (i2 < this.coefficients.length) {
            newCoefficients[i2] = -this.coefficients[i2];
            ++i2;
        }
        return new PolynomialFunction(newCoefficients);
    }

    public PolynomialFunction multiply(PolynomialFunction p) {
        double[] newCoefficients = new double[this.coefficients.length + p.coefficients.length - 1];
        int i2 = 0;
        while (i2 < newCoefficients.length) {
            newCoefficients[i2] = 0.0;
            int j = FastMath.max(0, i2 + 1 - p.coefficients.length);
            while (j < FastMath.min(this.coefficients.length, i2 + 1)) {
                int n = i2;
                newCoefficients[n] = newCoefficients[n] + this.coefficients[j] * p.coefficients[i2 - j];
                ++j;
            }
            ++i2;
        }
        return new PolynomialFunction(newCoefficients);
    }

    protected static double[] differentiate(double[] coefficients) {
        int n = coefficients.length;
        if (n == 0) {
            throw new NoDataException(LocalizedFormats.EMPTY_POLYNOMIALS_COEFFICIENTS_ARRAY);
        }
        if (n == 1) {
            return new double[]{0.0};
        }
        double[] result = new double[n - 1];
        int i2 = n - 1;
        while (i2 > 0) {
            result[i2 - 1] = (double)i2 * coefficients[i2];
            --i2;
        }
        return result;
    }

    public PolynomialFunction polynomialDerivative() {
        return new PolynomialFunction(PolynomialFunction.differentiate(this.coefficients));
    }

    @Override
    public UnivariateRealFunction derivative() {
        return this.polynomialDerivative();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.coefficients[0] == 0.0) {
            if (this.coefficients.length == 1) {
                return "0";
            }
        } else {
            s.append(Double.toString(this.coefficients[0]));
        }
        int i2 = 1;
        while (i2 < this.coefficients.length) {
            if (this.coefficients[i2] != 0.0) {
                if (s.length() > 0) {
                    if (this.coefficients[i2] < 0.0) {
                        s.append(" - ");
                    } else {
                        s.append(" + ");
                    }
                } else if (this.coefficients[i2] < 0.0) {
                    s.append("-");
                }
                double absAi = FastMath.abs(this.coefficients[i2]);
                if (absAi - 1.0 != 0.0) {
                    s.append(Double.toString(absAi));
                    s.append(' ');
                }
                s.append("x");
                if (i2 > 1) {
                    s.append('^');
                    s.append(Integer.toString(i2));
                }
            }
            ++i2;
        }
        return s.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.coefficients);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PolynomialFunction)) {
            return false;
        }
        PolynomialFunction other = (PolynomialFunction)obj;
        return Arrays.equals(this.coefficients, other.coefficients);
    }
}

