/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.polynomials;

import org.apache.commons.math.DuplicateSampleAbscissaException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.util.FastMath;

public class PolynomialFunctionLagrangeForm
implements UnivariateRealFunction {
    private double[] coefficients;
    private final double[] x;
    private final double[] y;
    private boolean coefficientsComputed;

    public PolynomialFunctionLagrangeForm(double[] x, double[] y) throws IllegalArgumentException {
        PolynomialFunctionLagrangeForm.verifyInterpolationArray(x, y);
        this.x = new double[x.length];
        this.y = new double[y.length];
        System.arraycopy(x, 0, this.x, 0, x.length);
        System.arraycopy(y, 0, this.y, 0, y.length);
        this.coefficientsComputed = false;
    }

    @Override
    public double value(double z) throws FunctionEvaluationException {
        try {
            return PolynomialFunctionLagrangeForm.evaluate(this.x, this.y, z);
        }
        catch (DuplicateSampleAbscissaException e) {
            throw new FunctionEvaluationException(z, e.getSpecificPattern(), e.getGeneralPattern(), e.getArguments());
        }
    }

    public int degree() {
        return this.x.length - 1;
    }

    public double[] getInterpolatingPoints() {
        double[] out = new double[this.x.length];
        System.arraycopy(this.x, 0, out, 0, this.x.length);
        return out;
    }

    public double[] getInterpolatingValues() {
        double[] out = new double[this.y.length];
        System.arraycopy(this.y, 0, out, 0, this.y.length);
        return out;
    }

    public double[] getCoefficients() {
        if (!this.coefficientsComputed) {
            this.computeCoefficients();
        }
        double[] out = new double[this.coefficients.length];
        System.arraycopy(this.coefficients, 0, out, 0, this.coefficients.length);
        return out;
    }

    public static double evaluate(double[] x, double[] y, double z) throws DuplicateSampleAbscissaException, IllegalArgumentException {
        PolynomialFunctionLagrangeForm.verifyInterpolationArray(x, y);
        int nearest = 0;
        int n = x.length;
        double[] c = new double[n];
        double[] d = new double[n];
        double min_dist = Double.POSITIVE_INFINITY;
        int i2 = 0;
        while (i2 < n) {
            c[i2] = y[i2];
            d[i2] = y[i2];
            double dist = FastMath.abs(z - x[i2]);
            if (dist < min_dist) {
                nearest = i2;
                min_dist = dist;
            }
            ++i2;
        }
        double value = y[nearest];
        int i3 = 1;
        while (i3 < n) {
            int j = 0;
            while (j < n - i3) {
                double tc = x[j] - z;
                double td = x[i3 + j] - z;
                double divider = x[j] - x[i3 + j];
                if (divider == 0.0) {
                    throw new DuplicateSampleAbscissaException(x[i3], i3, i3 + j);
                }
                double w = (c[j + 1] - d[j]) / divider;
                c[j] = tc * w;
                d[j] = td * w;
                ++j;
            }
            value = (double)nearest < 0.5 * (double)(n - i3 + 1) ? (value += c[nearest]) : (value += d[--nearest]);
            ++i3;
        }
        return value;
    }

    protected void computeCoefficients() throws ArithmeticException {
        int n = this.degree() + 1;
        this.coefficients = new double[n];
        int i2 = 0;
        while (i2 < n) {
            this.coefficients[i2] = 0.0;
            ++i2;
        }
        double[] c = new double[n + 1];
        c[0] = 1.0;
        int i3 = 0;
        while (i3 < n) {
            int j = i3;
            while (j > 0) {
                c[j] = c[j - 1] - c[j] * this.x[i3];
                --j;
            }
            c[0] = c[0] * -this.x[i3];
            c[i3 + 1] = 1.0;
            ++i3;
        }
        double[] tc = new double[n];
        int i4 = 0;
        while (i4 < n) {
            double d = 1.0;
            int j = 0;
            while (j < n) {
                if (i4 != j) {
                    d *= this.x[i4] - this.x[j];
                }
                ++j;
            }
            if (d == 0.0) {
                int k = 0;
                while (k < n) {
                    if (i4 != k && this.x[i4] == this.x[k]) {
                        throw MathRuntimeException.createArithmeticException(LocalizedFormats.IDENTICAL_ABSCISSAS_DIVISION_BY_ZERO, i4, k, this.x[i4]);
                    }
                    ++k;
                }
            }
            double t = this.y[i4] / d;
            tc[n - 1] = c[n];
            int n2 = n - 1;
            this.coefficients[n2] = this.coefficients[n2] + t * tc[n - 1];
            int j2 = n - 2;
            while (j2 >= 0) {
                tc[j2] = c[j2 + 1] + tc[j2 + 1] * this.x[i4];
                int n3 = j2;
                this.coefficients[n3] = this.coefficients[n3] + t * tc[j2];
                --j2;
            }
            ++i4;
        }
        this.coefficientsComputed = true;
    }

    public static void verifyInterpolationArray(double[] x, double[] y) throws IllegalArgumentException {
        if (x.length != y.length) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_SIMPLE, x.length, y.length);
        }
        if (x.length < 2) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.WRONG_NUMBER_OF_POINTS, 2, x.length);
        }
    }
}

