/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.solvers;

import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math.analysis.solvers.UnivariateRealSolverImpl;
import org.apache.commons.math.complex.Complex;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.util.FastMath;

public class LaguerreSolver
extends UnivariateRealSolverImpl {
    @Deprecated
    private final PolynomialFunction p;

    @Deprecated
    public LaguerreSolver(UnivariateRealFunction f) throws IllegalArgumentException {
        super(f, 100, 1.0E-6);
        if (!(f instanceof PolynomialFunction)) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.FUNCTION_NOT_POLYNOMIAL, new Object[0]);
        }
        this.p = (PolynomialFunction)f;
    }

    @Deprecated
    public LaguerreSolver() {
        super(100, 1.0E-6);
        this.p = null;
    }

    @Deprecated
    public PolynomialFunction getPolynomialFunction() {
        return new PolynomialFunction(this.p.getCoefficients());
    }

    @Override
    @Deprecated
    public double solve(double min, double max) throws ConvergenceException, FunctionEvaluationException {
        return this.solve(this.p, min, max);
    }

    @Override
    @Deprecated
    public double solve(double min, double max, double initial) throws ConvergenceException, FunctionEvaluationException {
        return this.solve(this.p, min, max, initial);
    }

    @Override
    public double solve(int maxEval, UnivariateRealFunction f, double min, double max, double initial) throws ConvergenceException, FunctionEvaluationException {
        this.setMaximalIterationCount(maxEval);
        return this.solve(f, min, max, initial);
    }

    @Override
    @Deprecated
    public double solve(UnivariateRealFunction f, double min, double max, double initial) throws ConvergenceException, FunctionEvaluationException {
        if (f.value(min) == 0.0) {
            return min;
        }
        if (f.value(max) == 0.0) {
            return max;
        }
        if (f.value(initial) == 0.0) {
            return initial;
        }
        this.verifyBracketing(min, max, f);
        this.verifySequence(min, initial, max);
        if (this.isBracketing(min, initial, f)) {
            return this.solve(f, min, initial);
        }
        return this.solve(f, initial, max);
    }

    @Override
    public double solve(int maxEval, UnivariateRealFunction f, double min, double max) throws ConvergenceException, FunctionEvaluationException {
        this.setMaximalIterationCount(maxEval);
        return this.solve(f, min, max);
    }

    @Override
    @Deprecated
    public double solve(UnivariateRealFunction f, double min, double max) throws ConvergenceException, FunctionEvaluationException {
        if (!(f instanceof PolynomialFunction)) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.FUNCTION_NOT_POLYNOMIAL, new Object[0]);
        }
        if (f.value(min) == 0.0) {
            return min;
        }
        if (f.value(max) == 0.0) {
            return max;
        }
        this.verifyBracketing(min, max, f);
        double[] coefficients = ((PolynomialFunction)f).getCoefficients();
        Complex[] c = new Complex[coefficients.length];
        int i2 = 0;
        while (i2 < coefficients.length) {
            c[i2] = new Complex(coefficients[i2], 0.0);
            ++i2;
        }
        Complex initial = new Complex(0.5 * (min + max), 0.0);
        Complex z = this.solve(c, initial);
        if (this.isRootOK(min, max, z)) {
            this.setResult(z.getReal(), this.iterationCount);
            return this.result;
        }
        Complex[] root = this.solveAll(c, initial);
        int i3 = 0;
        while (i3 < root.length) {
            if (this.isRootOK(min, max, root[i3])) {
                this.setResult(root[i3].getReal(), this.iterationCount);
                return this.result;
            }
            ++i3;
        }
        throw new ConvergenceException();
    }

    protected boolean isRootOK(double min, double max, Complex z) {
        double tolerance = FastMath.max(this.relativeAccuracy * z.abs(), this.absoluteAccuracy);
        return this.isSequence(min, z.getReal(), max) && (FastMath.abs(z.getImaginary()) <= tolerance || z.abs() <= this.functionValueAccuracy);
    }

    @Deprecated
    public Complex[] solveAll(double[] coefficients, double initial) throws ConvergenceException, FunctionEvaluationException {
        Complex[] c = new Complex[coefficients.length];
        Complex z = new Complex(initial, 0.0);
        int i2 = 0;
        while (i2 < c.length) {
            c[i2] = new Complex(coefficients[i2], 0.0);
            ++i2;
        }
        return this.solveAll(c, z);
    }

    @Deprecated
    public Complex[] solveAll(Complex[] coefficients, Complex initial) throws MaxIterationsExceededException, FunctionEvaluationException {
        int n = coefficients.length - 1;
        int iterationCount = 0;
        if (n < 1) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NON_POSITIVE_POLYNOMIAL_DEGREE, n);
        }
        Complex[] c = new Complex[n + 1];
        int i2 = 0;
        while (i2 <= n) {
            c[i2] = coefficients[i2];
            ++i2;
        }
        Complex[] root = new Complex[n];
        int i3 = 0;
        while (i3 < n) {
            Complex[] subarray = new Complex[n - i3 + 1];
            System.arraycopy(c, 0, subarray, 0, subarray.length);
            root[i3] = this.solve(subarray, initial);
            Complex newc = c[n - i3];
            Complex oldc = null;
            int j = n - i3 - 1;
            while (j >= 0) {
                oldc = c[j];
                c[j] = newc;
                newc = oldc.add(newc.multiply(root[i3]));
                --j;
            }
            iterationCount += this.iterationCount;
            ++i3;
        }
        this.resultComputed = true;
        this.iterationCount = iterationCount;
        return root;
    }

    @Deprecated
    public Complex solve(Complex[] coefficients, Complex initial) throws MaxIterationsExceededException, FunctionEvaluationException {
        int n = coefficients.length - 1;
        if (n < 1) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NON_POSITIVE_POLYNOMIAL_DEGREE, n);
        }
        Complex N = new Complex(n, 0.0);
        Complex N1 = new Complex(n - 1, 0.0);
        int i2 = 1;
        Complex pv = null;
        Complex dv = null;
        Complex d2v = null;
        Complex G = null;
        Complex G2 = null;
        Complex H = null;
        Complex delta = null;
        Complex denominator = null;
        Complex z = initial;
        Complex oldz = new Complex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        while (i2 <= this.maximalIterationCount) {
            pv = coefficients[n];
            dv = Complex.ZERO;
            d2v = Complex.ZERO;
            int j = n - 1;
            while (j >= 0) {
                d2v = dv.add(z.multiply(d2v));
                dv = pv.add(z.multiply(dv));
                pv = coefficients[j].add(z.multiply(pv));
                --j;
            }
            d2v = d2v.multiply(new Complex(2.0, 0.0));
            double tolerance = FastMath.max(this.relativeAccuracy * z.abs(), this.absoluteAccuracy);
            if (z.subtract(oldz).abs() <= tolerance) {
                this.resultComputed = true;
                this.iterationCount = i2;
                return z;
            }
            if (pv.abs() <= this.functionValueAccuracy) {
                this.resultComputed = true;
                this.iterationCount = i2;
                return z;
            }
            G = dv.divide(pv);
            G2 = G.multiply(G);
            H = G2.subtract(d2v.divide(pv));
            delta = N1.multiply(N.multiply(H).subtract(G2));
            Complex deltaSqrt = delta.sqrt();
            Complex dplus = G.add(deltaSqrt);
            Complex dminus = G.subtract(deltaSqrt);
            Complex complex = denominator = dplus.abs() > dminus.abs() ? dplus : dminus;
            if (denominator.equals(new Complex(0.0, 0.0))) {
                z = z.add(new Complex(this.absoluteAccuracy, this.absoluteAccuracy));
                oldz = new Complex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
            } else {
                oldz = z;
                z = z.subtract(N.divide(denominator));
            }
            ++i2;
        }
        throw new MaxIterationsExceededException(this.maximalIterationCount);
    }
}

