/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.genetics;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math.genetics.AbstractListChromosome;
import org.apache.commons.math.genetics.Chromosome;
import org.apache.commons.math.genetics.GeneticAlgorithm;
import org.apache.commons.math.genetics.InvalidRepresentationException;

public abstract class BinaryChromosome
extends AbstractListChromosome<Integer> {
    public BinaryChromosome(List<Integer> representation) {
        super(representation);
    }

    public BinaryChromosome(Integer[] representation) {
        super(representation);
    }

    @Override
    protected void checkValidity(List<Integer> chromosomeRepresentation) throws InvalidRepresentationException {
        for (int i2 : chromosomeRepresentation) {
            if (i2 >= 0 && i2 <= 1) continue;
            throw new InvalidRepresentationException("Elements can be only 0 or 1.");
        }
    }

    public static List<Integer> randomBinaryRepresentation(int length) {
        ArrayList<Integer> rList = new ArrayList<Integer>(length);
        int j = 0;
        while (j < length) {
            rList.add(GeneticAlgorithm.getRandomGenerator().nextInt(2));
            ++j;
        }
        return rList;
    }

    @Override
    protected boolean isSame(Chromosome another) {
        if (!(another instanceof BinaryChromosome)) {
            return false;
        }
        BinaryChromosome anotherBc = (BinaryChromosome)another;
        if (this.getLength() != anotherBc.getLength()) {
            return false;
        }
        int i2 = 0;
        while (i2 < this.getRepresentation().size()) {
            if (!((Integer)this.getRepresentation().get(i2)).equals(anotherBc.getRepresentation().get(i2))) {
                return false;
            }
            ++i2;
        }
        return true;
    }
}

