/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.genetics;

import java.util.Collections;
import java.util.List;
import org.apache.commons.math.genetics.Chromosome;
import org.apache.commons.math.genetics.ListPopulation;
import org.apache.commons.math.genetics.Population;
import org.apache.commons.math.util.FastMath;

public class ElitisticListPopulation
extends ListPopulation {
    private double elitismRate = 0.9;

    public ElitisticListPopulation(List<Chromosome> chromosomes, int populationLimit, double elitismRate) {
        super(chromosomes, populationLimit);
        this.elitismRate = elitismRate;
    }

    public ElitisticListPopulation(int populationLimit, double elitismRate) {
        super(populationLimit);
        this.elitismRate = elitismRate;
    }

    @Override
    public Population nextGeneration() {
        int boundIndex;
        ElitisticListPopulation nextGeneration = new ElitisticListPopulation(this.getPopulationLimit(), this.getElitismRate());
        List<Chromosome> oldChromosomes = this.getChromosomes();
        Collections.sort(oldChromosomes);
        int i2 = boundIndex = (int)FastMath.ceil((1.0 - this.getElitismRate()) * (double)oldChromosomes.size());
        while (i2 < oldChromosomes.size()) {
            nextGeneration.addChromosome(oldChromosomes.get(i2));
            ++i2;
        }
        return nextGeneration;
    }

    public void setElitismRate(double elitismRate) {
        if (elitismRate < 0.0 || elitismRate > 1.0) {
            throw new IllegalArgumentException("Elitism rate has to be in [0,1]");
        }
        this.elitismRate = elitismRate;
    }

    public double getElitismRate() {
        return this.elitismRate;
    }
}

