/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.genetics;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.math.exception.NotPositiveException;
import org.apache.commons.math.exception.NumberIsTooLargeException;
import org.apache.commons.math.exception.util.Localizable;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.genetics.Chromosome;
import org.apache.commons.math.genetics.Population;

public abstract class ListPopulation
implements Population {
    private List<Chromosome> chromosomes;
    private int populationLimit;

    public ListPopulation(List<Chromosome> chromosomes, int populationLimit) {
        if (chromosomes.size() > populationLimit) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LIST_OF_CHROMOSOMES_BIGGER_THAN_POPULATION_SIZE, (Number)chromosomes.size(), (Number)populationLimit, false);
        }
        if (populationLimit < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.POPULATION_LIMIT_NOT_POSITIVE, populationLimit);
        }
        this.chromosomes = chromosomes;
        this.populationLimit = populationLimit;
    }

    public ListPopulation(int populationLimit) {
        if (populationLimit < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.POPULATION_LIMIT_NOT_POSITIVE, populationLimit);
        }
        this.populationLimit = populationLimit;
        this.chromosomes = new ArrayList<Chromosome>(populationLimit);
    }

    public void setChromosomes(List<Chromosome> chromosomes) {
        this.chromosomes = chromosomes;
    }

    public List<Chromosome> getChromosomes() {
        return this.chromosomes;
    }

    @Override
    public void addChromosome(Chromosome chromosome) {
        this.chromosomes.add(chromosome);
    }

    @Override
    public Chromosome getFittestChromosome() {
        Chromosome bestChromosome = this.chromosomes.get(0);
        for (Chromosome chromosome : this.chromosomes) {
            if (chromosome.compareTo(bestChromosome) <= 0) continue;
            bestChromosome = chromosome;
        }
        return bestChromosome;
    }

    @Override
    public int getPopulationLimit() {
        return this.populationLimit;
    }

    public void setPopulationLimit(int populationLimit) {
        this.populationLimit = populationLimit;
    }

    @Override
    public int getPopulationSize() {
        return this.chromosomes.size();
    }

    public String toString() {
        return this.chromosomes.toString();
    }

    @Override
    public Iterator<Chromosome> iterator() {
        return this.chromosomes.iterator();
    }
}

