/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.apache.commons.math.Field;
import org.apache.commons.math.FieldElement;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.linear.ArrayFieldVector;
import org.apache.commons.math.linear.DefaultFieldMatrixChangingVisitor;
import org.apache.commons.math.linear.DefaultFieldMatrixPreservingVisitor;
import org.apache.commons.math.linear.FieldMatrix;
import org.apache.commons.math.linear.FieldMatrixChangingVisitor;
import org.apache.commons.math.linear.FieldMatrixPreservingVisitor;
import org.apache.commons.math.linear.FieldVector;
import org.apache.commons.math.linear.InvalidMatrixException;
import org.apache.commons.math.linear.MatrixIndexException;
import org.apache.commons.math.linear.MatrixVisitorException;
import org.apache.commons.math.linear.NonSquareMatrixException;

public abstract class AbstractFieldMatrix<T extends FieldElement<T>>
implements FieldMatrix<T> {
    private final Field<T> field;

    protected AbstractFieldMatrix() {
        this.field = null;
    }

    protected AbstractFieldMatrix(Field<T> field) {
        this.field = field;
    }

    protected AbstractFieldMatrix(Field<T> field, int rowDimension, int columnDimension) throws IllegalArgumentException {
        if (rowDimension < 1) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.INSUFFICIENT_DIMENSION, rowDimension, 1);
        }
        if (columnDimension < 1) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.INSUFFICIENT_DIMENSION, columnDimension, 1);
        }
        this.field = field;
    }

    protected static <T extends FieldElement<T>> Field<T> extractField(T[][] d) throws IllegalArgumentException {
        if (d.length == 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_ROW, new Object[0]);
        }
        if (d[0].length == 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_COLUMN, new Object[0]);
        }
        return d[0][0].getField();
    }

    protected static <T extends FieldElement<T>> Field<T> extractField(T[] d) throws IllegalArgumentException {
        if (d.length == 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_ROW, new Object[0]);
        }
        return d[0].getField();
    }

    protected static <T extends FieldElement<T>> T[][] buildArray(Field<T> field, int rows, int columns) {
        if (columns < 0) {
            FieldElement[] dummyRow = (FieldElement[])Array.newInstance(((FieldElement)field.getZero()).getClass(), 0);
            return (FieldElement[][])Array.newInstance(dummyRow.getClass(), rows);
        }
        FieldElement[][] array = (FieldElement[][])Array.newInstance(((FieldElement)field.getZero()).getClass(), rows, columns);
        int i2 = 0;
        while (i2 < array.length) {
            Arrays.fill(array[i2], field.getZero());
            ++i2;
        }
        return array;
    }

    protected static <T extends FieldElement<T>> T[] buildArray(Field<T> field, int length) {
        Object[] array = (FieldElement[])Array.newInstance(((FieldElement)field.getZero()).getClass(), length);
        Arrays.fill(array, field.getZero());
        return array;
    }

    @Override
    public Field<T> getField() {
        return this.field;
    }

    @Override
    public abstract FieldMatrix<T> createMatrix(int var1, int var2) throws IllegalArgumentException;

    @Override
    public abstract FieldMatrix<T> copy();

    @Override
    public FieldMatrix<T> add(FieldMatrix<T> m) throws IllegalArgumentException {
        this.checkAdditionCompatible(m);
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        FieldMatrix<FieldElement> out = this.createMatrix(rowCount, columnCount);
        int row = 0;
        while (row < rowCount) {
            int col = 0;
            while (col < columnCount) {
                out.setEntry(row, col, (FieldElement)this.getEntry(row, col).add(m.getEntry(row, col)));
                ++col;
            }
            ++row;
        }
        return out;
    }

    @Override
    public FieldMatrix<T> subtract(FieldMatrix<T> m) throws IllegalArgumentException {
        this.checkSubtractionCompatible(m);
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        FieldMatrix<FieldElement> out = this.createMatrix(rowCount, columnCount);
        int row = 0;
        while (row < rowCount) {
            int col = 0;
            while (col < columnCount) {
                out.setEntry(row, col, (FieldElement)this.getEntry(row, col).subtract(m.getEntry(row, col)));
                ++col;
            }
            ++row;
        }
        return out;
    }

    @Override
    public FieldMatrix<T> scalarAdd(T d) {
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        FieldMatrix<FieldElement> out = this.createMatrix(rowCount, columnCount);
        int row = 0;
        while (row < rowCount) {
            int col = 0;
            while (col < columnCount) {
                out.setEntry(row, col, (FieldElement)this.getEntry(row, col).add(d));
                ++col;
            }
            ++row;
        }
        return out;
    }

    @Override
    public FieldMatrix<T> scalarMultiply(T d) {
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        FieldMatrix<FieldElement> out = this.createMatrix(rowCount, columnCount);
        int row = 0;
        while (row < rowCount) {
            int col = 0;
            while (col < columnCount) {
                out.setEntry(row, col, (FieldElement)this.getEntry(row, col).multiply(d));
                ++col;
            }
            ++row;
        }
        return out;
    }

    @Override
    public FieldMatrix<T> multiply(FieldMatrix<T> m) throws IllegalArgumentException {
        this.checkMultiplicationCompatible(m);
        int nRows = this.getRowDimension();
        int nCols = m.getColumnDimension();
        int nSum = this.getColumnDimension();
        FieldMatrix<FieldElement> out = this.createMatrix(nRows, nCols);
        int row = 0;
        while (row < nRows) {
            int col = 0;
            while (col < nCols) {
                FieldElement sum = (FieldElement)this.field.getZero();
                int i2 = 0;
                while (i2 < nSum) {
                    sum = sum.add((FieldElement)this.getEntry(row, i2).multiply(m.getEntry(i2, col)));
                    ++i2;
                }
                out.setEntry(row, col, sum);
                ++col;
            }
            ++row;
        }
        return out;
    }

    @Override
    public FieldMatrix<T> preMultiply(FieldMatrix<T> m) throws IllegalArgumentException {
        return m.multiply(this);
    }

    @Override
    public T[][] getData() {
        FieldElement[][] data = AbstractFieldMatrix.buildArray(this.field, (int)this.getRowDimension(), (int)this.getColumnDimension());
        int i2 = 0;
        while (i2 < data.length) {
            FieldElement[] dataI = data[i2];
            int j = 0;
            while (j < dataI.length) {
                dataI[j] = this.getEntry(i2, j);
                ++j;
            }
            ++i2;
        }
        return data;
    }

    @Override
    public FieldMatrix<T> getSubMatrix(int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        FieldMatrix<T> subMatrix = this.createMatrix(endRow - startRow + 1, endColumn - startColumn + 1);
        int i2 = startRow;
        while (i2 <= endRow) {
            int j = startColumn;
            while (j <= endColumn) {
                subMatrix.setEntry(i2 - startRow, j - startColumn, this.getEntry(i2, j));
                ++j;
            }
            ++i2;
        }
        return subMatrix;
    }

    @Override
    public FieldMatrix<T> getSubMatrix(final int[] selectedRows, final int[] selectedColumns) throws MatrixIndexException {
        this.checkSubMatrixIndex(selectedRows, selectedColumns);
        FieldMatrix<T> subMatrix = this.createMatrix(selectedRows.length, selectedColumns.length);
        subMatrix.walkInOptimizedOrder(new DefaultFieldMatrixChangingVisitor<T>((FieldElement)this.field.getZero()){

            @Override
            public T visit(int row, int column, T value) {
                return AbstractFieldMatrix.this.getEntry(selectedRows[row], selectedColumns[column]);
            }
        });
        return subMatrix;
    }

    @Override
    public void copySubMatrix(int startRow, int endRow, int startColumn, int endColumn, T[][] destination) throws MatrixIndexException, IllegalArgumentException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        int rowsCount = endRow + 1 - startRow;
        int columnsCount = endColumn + 1 - startColumn;
        if (destination.length < rowsCount || destination[0].length < columnsCount) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_2x2, destination.length, destination[0].length, rowsCount, columnsCount);
        }
        this.walkInOptimizedOrder(new DefaultFieldMatrixPreservingVisitor<T>((FieldElement)this.field.getZero(), (FieldElement[][])destination){
            private int startRow;
            private int startColumn;
            private final /* synthetic */ FieldElement[][] val$destination;
            {
                this.val$destination = fieldElementArray;
                super($anonymous0);
            }

            @Override
            public void start(int rows, int columns, int startRow, int endRow, int startColumn, int endColumn) {
                this.startRow = startRow;
                this.startColumn = startColumn;
            }

            @Override
            public void visit(int row, int column, T value) {
                this.val$destination[row - this.startRow][column - this.startColumn] = value;
            }
        }, startRow, endRow, startColumn, endColumn);
    }

    @Override
    public void copySubMatrix(int[] selectedRows, int[] selectedColumns, T[][] destination) throws MatrixIndexException, IllegalArgumentException {
        this.checkSubMatrixIndex(selectedRows, selectedColumns);
        if (destination.length < selectedRows.length || destination[0].length < selectedColumns.length) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_2x2, destination.length, destination[0].length, selectedRows.length, selectedColumns.length);
        }
        int i2 = 0;
        while (i2 < selectedRows.length) {
            T[] destinationI = destination[i2];
            int j = 0;
            while (j < selectedColumns.length) {
                destinationI[j] = this.getEntry(selectedRows[i2], selectedColumns[j]);
                ++j;
            }
            ++i2;
        }
    }

    @Override
    public void setSubMatrix(T[][] subMatrix, int row, int column) throws MatrixIndexException {
        int nRows = subMatrix.length;
        if (nRows == 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_ROW, new Object[0]);
        }
        int nCols = subMatrix[0].length;
        if (nCols == 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_COLUMN, new Object[0]);
        }
        int r = 1;
        while (r < nRows) {
            if (subMatrix[r].length != nCols) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIFFERENT_ROWS_LENGTHS, nCols, subMatrix[r].length);
            }
            ++r;
        }
        this.checkRowIndex(row);
        this.checkColumnIndex(column);
        this.checkRowIndex(nRows + row - 1);
        this.checkColumnIndex(nCols + column - 1);
        int i2 = 0;
        while (i2 < nRows) {
            int j = 0;
            while (j < nCols) {
                this.setEntry(row + i2, column + j, subMatrix[i2][j]);
                ++j;
            }
            ++i2;
        }
    }

    @Override
    public FieldMatrix<T> getRowMatrix(int row) throws MatrixIndexException {
        this.checkRowIndex(row);
        int nCols = this.getColumnDimension();
        FieldMatrix<T> out = this.createMatrix(1, nCols);
        int i2 = 0;
        while (i2 < nCols) {
            out.setEntry(0, i2, this.getEntry(row, i2));
            ++i2;
        }
        return out;
    }

    @Override
    public void setRowMatrix(int row, FieldMatrix<T> matrix) throws MatrixIndexException, InvalidMatrixException {
        this.checkRowIndex(row);
        int nCols = this.getColumnDimension();
        if (matrix.getRowDimension() != 1 || matrix.getColumnDimension() != nCols) {
            throw new InvalidMatrixException(LocalizedFormats.DIMENSIONS_MISMATCH_2x2, matrix.getRowDimension(), matrix.getColumnDimension(), 1, nCols);
        }
        int i2 = 0;
        while (i2 < nCols) {
            this.setEntry(row, i2, matrix.getEntry(0, i2));
            ++i2;
        }
    }

    @Override
    public FieldMatrix<T> getColumnMatrix(int column) throws MatrixIndexException {
        this.checkColumnIndex(column);
        int nRows = this.getRowDimension();
        FieldMatrix<T> out = this.createMatrix(nRows, 1);
        int i2 = 0;
        while (i2 < nRows) {
            out.setEntry(i2, 0, this.getEntry(i2, column));
            ++i2;
        }
        return out;
    }

    @Override
    public void setColumnMatrix(int column, FieldMatrix<T> matrix) throws MatrixIndexException, InvalidMatrixException {
        this.checkColumnIndex(column);
        int nRows = this.getRowDimension();
        if (matrix.getRowDimension() != nRows || matrix.getColumnDimension() != 1) {
            throw new InvalidMatrixException(LocalizedFormats.DIMENSIONS_MISMATCH_2x2, matrix.getRowDimension(), matrix.getColumnDimension(), nRows, 1);
        }
        int i2 = 0;
        while (i2 < nRows) {
            this.setEntry(i2, column, matrix.getEntry(i2, 0));
            ++i2;
        }
    }

    @Override
    public FieldVector<T> getRowVector(int row) throws MatrixIndexException {
        return new ArrayFieldVector(this.getRow(row), false);
    }

    @Override
    public void setRowVector(int row, FieldVector<T> vector) throws MatrixIndexException, InvalidMatrixException {
        this.checkRowIndex(row);
        int nCols = this.getColumnDimension();
        if (vector.getDimension() != nCols) {
            throw new InvalidMatrixException(LocalizedFormats.DIMENSIONS_MISMATCH_2x2, 1, vector.getDimension(), 1, nCols);
        }
        int i2 = 0;
        while (i2 < nCols) {
            this.setEntry(row, i2, vector.getEntry(i2));
            ++i2;
        }
    }

    @Override
    public FieldVector<T> getColumnVector(int column) throws MatrixIndexException {
        return new ArrayFieldVector(this.getColumn(column), false);
    }

    @Override
    public void setColumnVector(int column, FieldVector<T> vector) throws MatrixIndexException, InvalidMatrixException {
        this.checkColumnIndex(column);
        int nRows = this.getRowDimension();
        if (vector.getDimension() != nRows) {
            throw new InvalidMatrixException(LocalizedFormats.DIMENSIONS_MISMATCH_2x2, vector.getDimension(), 1, nRows, 1);
        }
        int i2 = 0;
        while (i2 < nRows) {
            this.setEntry(i2, column, vector.getEntry(i2));
            ++i2;
        }
    }

    @Override
    public T[] getRow(int row) throws MatrixIndexException {
        this.checkRowIndex(row);
        int nCols = this.getColumnDimension();
        FieldElement[] out = AbstractFieldMatrix.buildArray(this.field, (int)nCols);
        int i2 = 0;
        while (i2 < nCols) {
            out[i2] = this.getEntry(row, i2);
            ++i2;
        }
        return out;
    }

    @Override
    public void setRow(int row, T[] array) throws MatrixIndexException, InvalidMatrixException {
        this.checkRowIndex(row);
        int nCols = this.getColumnDimension();
        if (array.length != nCols) {
            throw new InvalidMatrixException(LocalizedFormats.DIMENSIONS_MISMATCH_2x2, 1, array.length, 1, nCols);
        }
        int i2 = 0;
        while (i2 < nCols) {
            this.setEntry(row, i2, array[i2]);
            ++i2;
        }
    }

    @Override
    public T[] getColumn(int column) throws MatrixIndexException {
        this.checkColumnIndex(column);
        int nRows = this.getRowDimension();
        FieldElement[] out = AbstractFieldMatrix.buildArray(this.field, (int)nRows);
        int i2 = 0;
        while (i2 < nRows) {
            out[i2] = this.getEntry(i2, column);
            ++i2;
        }
        return out;
    }

    @Override
    public void setColumn(int column, T[] array) throws MatrixIndexException, InvalidMatrixException {
        this.checkColumnIndex(column);
        int nRows = this.getRowDimension();
        if (array.length != nRows) {
            throw new InvalidMatrixException(LocalizedFormats.DIMENSIONS_MISMATCH_2x2, array.length, 1, nRows, 1);
        }
        int i2 = 0;
        while (i2 < nRows) {
            this.setEntry(i2, column, array[i2]);
            ++i2;
        }
    }

    @Override
    public abstract T getEntry(int var1, int var2) throws MatrixIndexException;

    @Override
    public abstract void setEntry(int var1, int var2, T var3) throws MatrixIndexException;

    @Override
    public abstract void addToEntry(int var1, int var2, T var3) throws MatrixIndexException;

    @Override
    public abstract void multiplyEntry(int var1, int var2, T var3) throws MatrixIndexException;

    @Override
    public FieldMatrix<T> transpose() {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        final FieldMatrix<T> out = this.createMatrix(nCols, nRows);
        this.walkInOptimizedOrder(new DefaultFieldMatrixPreservingVisitor<T>((FieldElement)this.field.getZero()){

            @Override
            public void visit(int row, int column, T value) {
                out.setEntry(column, row, value);
            }
        });
        return out;
    }

    @Override
    public boolean isSquare() {
        return this.getColumnDimension() == this.getRowDimension();
    }

    @Override
    public abstract int getRowDimension();

    @Override
    public abstract int getColumnDimension();

    @Override
    public T getTrace() throws NonSquareMatrixException {
        int nCols;
        int nRows = this.getRowDimension();
        if (nRows != (nCols = this.getColumnDimension())) {
            throw new NonSquareMatrixException(nRows, nCols);
        }
        FieldElement trace = (FieldElement)this.field.getZero();
        int i2 = 0;
        while (i2 < nRows) {
            trace = (FieldElement)trace.add(this.getEntry(i2, i2));
            ++i2;
        }
        return (T)trace;
    }

    @Override
    public T[] operate(T[] v) throws IllegalArgumentException {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (v.length != nCols) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, v.length, nCols);
        }
        FieldElement[] out = AbstractFieldMatrix.buildArray(this.field, (int)nRows);
        int row = 0;
        while (row < nRows) {
            FieldElement sum = (FieldElement)this.field.getZero();
            int i2 = 0;
            while (i2 < nCols) {
                sum = sum.add((FieldElement)this.getEntry(row, i2).multiply(v[i2]));
                ++i2;
            }
            out[row] = sum;
            ++row;
        }
        return out;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public FieldVector<T> operate(FieldVector<T> v) throws IllegalArgumentException {
        try {
            return new ArrayFieldVector(this.operate(((ArrayFieldVector)v).getDataRef()), false);
        }
        catch (ClassCastException cce) {
            nRows = this.getRowDimension();
            nCols = this.getColumnDimension();
            if (v.getDimension() != nCols) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, new Object[]{v.getDimension(), nCols});
            }
            out = AbstractFieldMatrix.buildArray(this.field, (int)nRows);
            row = 0;
            ** while (row < nRows)
        }
lbl-1000:
        // 1 sources

        {
            sum = (FieldElement)this.field.getZero();
            i = 0;
            while (i < nCols) {
                sum = sum.add((FieldElement)this.getEntry(row, i).multiply(v.getEntry(i)));
                ++i;
            }
            out[row] = sum;
            ++row;
            continue;
        }
lbl20:
        // 1 sources

        return new ArrayFieldVector(out, false);
    }

    @Override
    public T[] preMultiply(T[] v) throws IllegalArgumentException {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (v.length != nRows) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, v.length, nRows);
        }
        FieldElement[] out = AbstractFieldMatrix.buildArray(this.field, (int)nCols);
        int col = 0;
        while (col < nCols) {
            FieldElement sum = (FieldElement)this.field.getZero();
            int i2 = 0;
            while (i2 < nRows) {
                sum = sum.add((FieldElement)this.getEntry(i2, col).multiply(v[i2]));
                ++i2;
            }
            out[col] = sum;
            ++col;
        }
        return out;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public FieldVector<T> preMultiply(FieldVector<T> v) throws IllegalArgumentException {
        try {
            return new ArrayFieldVector(this.preMultiply(((ArrayFieldVector)v).getDataRef()), false);
        }
        catch (ClassCastException cce) {
            nRows = this.getRowDimension();
            nCols = this.getColumnDimension();
            if (v.getDimension() != nRows) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, new Object[]{v.getDimension(), nRows});
            }
            out = AbstractFieldMatrix.buildArray(this.field, (int)nCols);
            col = 0;
            ** while (col < nCols)
        }
lbl-1000:
        // 1 sources

        {
            sum = (FieldElement)this.field.getZero();
            i = 0;
            while (i < nRows) {
                sum = sum.add((FieldElement)this.getEntry(i, col).multiply(v.getEntry(i)));
                ++i;
            }
            out[col] = sum;
            ++col;
            continue;
        }
lbl20:
        // 1 sources

        return new ArrayFieldVector(out);
    }

    @Override
    public T walkInRowOrder(FieldMatrixChangingVisitor<T> visitor) throws MatrixVisitorException {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        int row = 0;
        while (row < rows) {
            int column = 0;
            while (column < columns) {
                T oldValue = this.getEntry(row, column);
                T newValue = visitor.visit(row, column, oldValue);
                this.setEntry(row, column, newValue);
                ++column;
            }
            ++row;
        }
        return visitor.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixPreservingVisitor<T> visitor) throws MatrixVisitorException {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        int row = 0;
        while (row < rows) {
            int column = 0;
            while (column < columns) {
                visitor.visit(row, column, this.getEntry(row, column));
                ++column;
            }
            ++row;
        }
        return visitor.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixChangingVisitor<T> visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        int row = startRow;
        while (row <= endRow) {
            int column = startColumn;
            while (column <= endColumn) {
                T oldValue = this.getEntry(row, column);
                T newValue = visitor.visit(row, column, oldValue);
                this.setEntry(row, column, newValue);
                ++column;
            }
            ++row;
        }
        return visitor.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixPreservingVisitor<T> visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        int row = startRow;
        while (row <= endRow) {
            int column = startColumn;
            while (column <= endColumn) {
                visitor.visit(row, column, this.getEntry(row, column));
                ++column;
            }
            ++row;
        }
        return visitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixChangingVisitor<T> visitor) throws MatrixVisitorException {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        int column = 0;
        while (column < columns) {
            int row = 0;
            while (row < rows) {
                T oldValue = this.getEntry(row, column);
                T newValue = visitor.visit(row, column, oldValue);
                this.setEntry(row, column, newValue);
                ++row;
            }
            ++column;
        }
        return visitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixPreservingVisitor<T> visitor) throws MatrixVisitorException {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        int column = 0;
        while (column < columns) {
            int row = 0;
            while (row < rows) {
                visitor.visit(row, column, this.getEntry(row, column));
                ++row;
            }
            ++column;
        }
        return visitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixChangingVisitor<T> visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        int column = startColumn;
        while (column <= endColumn) {
            int row = startRow;
            while (row <= endRow) {
                T oldValue = this.getEntry(row, column);
                T newValue = visitor.visit(row, column, oldValue);
                this.setEntry(row, column, newValue);
                ++row;
            }
            ++column;
        }
        return visitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixPreservingVisitor<T> visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        int column = startColumn;
        while (column <= endColumn) {
            int row = startRow;
            while (row <= endRow) {
                visitor.visit(row, column, this.getEntry(row, column));
                ++row;
            }
            ++column;
        }
        return visitor.end();
    }

    @Override
    public T walkInOptimizedOrder(FieldMatrixChangingVisitor<T> visitor) throws MatrixVisitorException {
        return this.walkInRowOrder(visitor);
    }

    @Override
    public T walkInOptimizedOrder(FieldMatrixPreservingVisitor<T> visitor) throws MatrixVisitorException {
        return this.walkInRowOrder(visitor);
    }

    @Override
    public T walkInOptimizedOrder(FieldMatrixChangingVisitor<T> visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        return this.walkInRowOrder(visitor, startRow, endRow, startColumn, endColumn);
    }

    @Override
    public T walkInOptimizedOrder(FieldMatrixPreservingVisitor<T> visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        return this.walkInRowOrder(visitor, startRow, endRow, startColumn, endColumn);
    }

    public String toString() {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        StringBuilder res = new StringBuilder();
        String fullClassName = this.getClass().getName();
        String shortClassName = fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
        res.append(shortClassName).append("{");
        int i2 = 0;
        while (i2 < nRows) {
            if (i2 > 0) {
                res.append(",");
            }
            res.append("{");
            int j = 0;
            while (j < nCols) {
                if (j > 0) {
                    res.append(",");
                }
                res.append(this.getEntry(i2, j));
                ++j;
            }
            res.append("}");
            ++i2;
        }
        res.append("}");
        return res.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FieldMatrix)) {
            return false;
        }
        FieldMatrix m = (FieldMatrix)object;
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (m.getColumnDimension() != nCols || m.getRowDimension() != nRows) {
            return false;
        }
        int row = 0;
        while (row < nRows) {
            int col = 0;
            while (col < nCols) {
                if (!this.getEntry(row, col).equals(m.getEntry(row, col))) {
                    return false;
                }
                ++col;
            }
            ++row;
        }
        return true;
    }

    public int hashCode() {
        int ret = 322562;
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        ret = ret * 31 + nRows;
        ret = ret * 31 + nCols;
        int row = 0;
        while (row < nRows) {
            int col = 0;
            while (col < nCols) {
                ret = ret * 31 + (11 * (row + 1) + 17 * (col + 1)) * this.getEntry(row, col).hashCode();
                ++col;
            }
            ++row;
        }
        return ret;
    }

    protected void checkRowIndex(int row) {
        if (row < 0 || row >= this.getRowDimension()) {
            throw new MatrixIndexException(LocalizedFormats.ROW_INDEX_OUT_OF_RANGE, row, 0, this.getRowDimension() - 1);
        }
    }

    protected void checkColumnIndex(int column) throws MatrixIndexException {
        if (column < 0 || column >= this.getColumnDimension()) {
            throw new MatrixIndexException(LocalizedFormats.COLUMN_INDEX_OUT_OF_RANGE, column, 0, this.getColumnDimension() - 1);
        }
    }

    protected void checkSubMatrixIndex(int startRow, int endRow, int startColumn, int endColumn) {
        this.checkRowIndex(startRow);
        this.checkRowIndex(endRow);
        if (startRow > endRow) {
            throw new MatrixIndexException(LocalizedFormats.INITIAL_ROW_AFTER_FINAL_ROW, startRow, endRow);
        }
        this.checkColumnIndex(startColumn);
        this.checkColumnIndex(endColumn);
        if (startColumn > endColumn) {
            throw new MatrixIndexException(LocalizedFormats.INITIAL_COLUMN_AFTER_FINAL_COLUMN, startColumn, endColumn);
        }
    }

    protected void checkSubMatrixIndex(int[] selectedRows, int[] selectedColumns) {
        if (selectedRows.length * selectedColumns.length == 0) {
            if (selectedRows.length == 0) {
                throw new MatrixIndexException(LocalizedFormats.EMPTY_SELECTED_ROW_INDEX_ARRAY, new Object[0]);
            }
            throw new MatrixIndexException(LocalizedFormats.EMPTY_SELECTED_COLUMN_INDEX_ARRAY, new Object[0]);
        }
        int[] nArray = selectedRows;
        int n = selectedRows.length;
        int n2 = 0;
        while (n2 < n) {
            int row = nArray[n2];
            this.checkRowIndex(row);
            ++n2;
        }
        nArray = selectedColumns;
        n = selectedColumns.length;
        n2 = 0;
        while (n2 < n) {
            int column = nArray[n2];
            this.checkColumnIndex(column);
            ++n2;
        }
    }

    protected void checkAdditionCompatible(FieldMatrix<T> m) {
        if (this.getRowDimension() != m.getRowDimension() || this.getColumnDimension() != m.getColumnDimension()) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NOT_ADDITION_COMPATIBLE_MATRICES, this.getRowDimension(), this.getColumnDimension(), m.getRowDimension(), m.getColumnDimension());
        }
    }

    protected void checkSubtractionCompatible(FieldMatrix<T> m) {
        if (this.getRowDimension() != m.getRowDimension() || this.getColumnDimension() != m.getColumnDimension()) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NOT_SUBTRACTION_COMPATIBLE_MATRICES, this.getRowDimension(), this.getColumnDimension(), m.getRowDimension(), m.getColumnDimension());
        }
    }

    protected void checkMultiplicationCompatible(FieldMatrix<T> m) {
        if (this.getColumnDimension() != m.getRowDimension()) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NOT_MULTIPLICATION_COMPATIBLE_MATRICES, this.getRowDimension(), this.getColumnDimension(), m.getRowDimension(), m.getColumnDimension());
        }
    }
}

