/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.linear.ArrayRealVector;
import org.apache.commons.math.linear.DecompositionSolver;
import org.apache.commons.math.linear.DefaultRealMatrixChangingVisitor;
import org.apache.commons.math.linear.DefaultRealMatrixPreservingVisitor;
import org.apache.commons.math.linear.InvalidMatrixException;
import org.apache.commons.math.linear.LUDecompositionImpl;
import org.apache.commons.math.linear.MatrixIndexException;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.MatrixVisitorException;
import org.apache.commons.math.linear.NonSquareMatrixException;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealMatrixChangingVisitor;
import org.apache.commons.math.linear.RealMatrixPreservingVisitor;
import org.apache.commons.math.linear.RealVector;
import org.apache.commons.math.util.FastMath;
import org.apache.commons.math.util.MathUtils;

public abstract class AbstractRealMatrix
implements RealMatrix {
    @Deprecated
    private DecompositionSolver lu;

    protected AbstractRealMatrix() {
        this.lu = null;
    }

    protected AbstractRealMatrix(int rowDimension, int columnDimension) throws IllegalArgumentException {
        if (rowDimension < 1) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.INSUFFICIENT_DIMENSION, rowDimension, 1);
        }
        if (columnDimension <= 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.INSUFFICIENT_DIMENSION, columnDimension, 1);
        }
        this.lu = null;
    }

    @Override
    public abstract RealMatrix createMatrix(int var1, int var2) throws IllegalArgumentException;

    @Override
    public abstract RealMatrix copy();

    @Override
    public RealMatrix add(RealMatrix m) throws IllegalArgumentException {
        MatrixUtils.checkAdditionCompatible(this, m);
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        RealMatrix out = this.createMatrix(rowCount, columnCount);
        int row = 0;
        while (row < rowCount) {
            int col = 0;
            while (col < columnCount) {
                out.setEntry(row, col, this.getEntry(row, col) + m.getEntry(row, col));
                ++col;
            }
            ++row;
        }
        return out;
    }

    @Override
    public RealMatrix subtract(RealMatrix m) throws IllegalArgumentException {
        MatrixUtils.checkSubtractionCompatible(this, m);
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        RealMatrix out = this.createMatrix(rowCount, columnCount);
        int row = 0;
        while (row < rowCount) {
            int col = 0;
            while (col < columnCount) {
                out.setEntry(row, col, this.getEntry(row, col) - m.getEntry(row, col));
                ++col;
            }
            ++row;
        }
        return out;
    }

    @Override
    public RealMatrix scalarAdd(double d) {
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        RealMatrix out = this.createMatrix(rowCount, columnCount);
        int row = 0;
        while (row < rowCount) {
            int col = 0;
            while (col < columnCount) {
                out.setEntry(row, col, this.getEntry(row, col) + d);
                ++col;
            }
            ++row;
        }
        return out;
    }

    @Override
    public RealMatrix scalarMultiply(double d) {
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        RealMatrix out = this.createMatrix(rowCount, columnCount);
        int row = 0;
        while (row < rowCount) {
            int col = 0;
            while (col < columnCount) {
                out.setEntry(row, col, this.getEntry(row, col) * d);
                ++col;
            }
            ++row;
        }
        return out;
    }

    @Override
    public RealMatrix multiply(RealMatrix m) throws IllegalArgumentException {
        MatrixUtils.checkMultiplicationCompatible(this, m);
        int nRows = this.getRowDimension();
        int nCols = m.getColumnDimension();
        int nSum = this.getColumnDimension();
        RealMatrix out = this.createMatrix(nRows, nCols);
        int row = 0;
        while (row < nRows) {
            int col = 0;
            while (col < nCols) {
                double sum = 0.0;
                int i2 = 0;
                while (i2 < nSum) {
                    sum += this.getEntry(row, i2) * m.getEntry(i2, col);
                    ++i2;
                }
                out.setEntry(row, col, sum);
                ++col;
            }
            ++row;
        }
        return out;
    }

    @Override
    public RealMatrix preMultiply(RealMatrix m) throws IllegalArgumentException {
        return m.multiply(this);
    }

    @Override
    public double[][] getData() {
        double[][] data = new double[this.getRowDimension()][this.getColumnDimension()];
        int i2 = 0;
        while (i2 < data.length) {
            double[] dataI = data[i2];
            int j = 0;
            while (j < dataI.length) {
                dataI[j] = this.getEntry(i2, j);
                ++j;
            }
            ++i2;
        }
        return data;
    }

    @Override
    public double getNorm() {
        return this.walkInColumnOrder(new RealMatrixPreservingVisitor(){
            private double endRow;
            private double columnSum;
            private double maxColSum;

            @Override
            public void start(int rows, int columns, int startRow, int endRow, int startColumn, int endColumn) {
                this.endRow = endRow;
                this.columnSum = 0.0;
                this.maxColSum = 0.0;
            }

            @Override
            public void visit(int row, int column, double value) {
                this.columnSum += FastMath.abs(value);
                if ((double)row == this.endRow) {
                    this.maxColSum = FastMath.max(this.maxColSum, this.columnSum);
                    this.columnSum = 0.0;
                }
            }

            @Override
            public double end() {
                return this.maxColSum;
            }
        });
    }

    @Override
    public double getFrobeniusNorm() {
        return this.walkInOptimizedOrder(new RealMatrixPreservingVisitor(){
            private double sum;

            @Override
            public void start(int rows, int columns, int startRow, int endRow, int startColumn, int endColumn) {
                this.sum = 0.0;
            }

            @Override
            public void visit(int row, int column, double value) {
                this.sum += value * value;
            }

            @Override
            public double end() {
                return FastMath.sqrt(this.sum);
            }
        });
    }

    @Override
    public RealMatrix getSubMatrix(int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException {
        MatrixUtils.checkSubMatrixIndex(this, startRow, endRow, startColumn, endColumn);
        RealMatrix subMatrix = this.createMatrix(endRow - startRow + 1, endColumn - startColumn + 1);
        int i2 = startRow;
        while (i2 <= endRow) {
            int j = startColumn;
            while (j <= endColumn) {
                subMatrix.setEntry(i2 - startRow, j - startColumn, this.getEntry(i2, j));
                ++j;
            }
            ++i2;
        }
        return subMatrix;
    }

    @Override
    public RealMatrix getSubMatrix(final int[] selectedRows, final int[] selectedColumns) throws MatrixIndexException {
        MatrixUtils.checkSubMatrixIndex(this, selectedRows, selectedColumns);
        RealMatrix subMatrix = this.createMatrix(selectedRows.length, selectedColumns.length);
        subMatrix.walkInOptimizedOrder(new DefaultRealMatrixChangingVisitor(){

            @Override
            public double visit(int row, int column, double value) {
                return AbstractRealMatrix.this.getEntry(selectedRows[row], selectedColumns[column]);
            }
        });
        return subMatrix;
    }

    @Override
    public void copySubMatrix(int startRow, int endRow, int startColumn, int endColumn, final double[][] destination) throws MatrixIndexException, IllegalArgumentException {
        MatrixUtils.checkSubMatrixIndex(this, startRow, endRow, startColumn, endColumn);
        int rowsCount = endRow + 1 - startRow;
        int columnsCount = endColumn + 1 - startColumn;
        if (destination.length < rowsCount || destination[0].length < columnsCount) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_2x2, destination.length, destination[0].length, rowsCount, columnsCount);
        }
        this.walkInOptimizedOrder(new DefaultRealMatrixPreservingVisitor(){
            private int startRow;
            private int startColumn;

            @Override
            public void start(int rows, int columns, int startRow, int endRow, int startColumn, int endColumn) {
                this.startRow = startRow;
                this.startColumn = startColumn;
            }

            @Override
            public void visit(int row, int column, double value) {
                destination[row - this.startRow][column - this.startColumn] = value;
            }
        }, startRow, endRow, startColumn, endColumn);
    }

    @Override
    public void copySubMatrix(int[] selectedRows, int[] selectedColumns, double[][] destination) throws MatrixIndexException, IllegalArgumentException {
        MatrixUtils.checkSubMatrixIndex(this, selectedRows, selectedColumns);
        if (destination.length < selectedRows.length || destination[0].length < selectedColumns.length) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_2x2, destination.length, destination[0].length, selectedRows.length, selectedColumns.length);
        }
        int i2 = 0;
        while (i2 < selectedRows.length) {
            double[] destinationI = destination[i2];
            int j = 0;
            while (j < selectedColumns.length) {
                destinationI[j] = this.getEntry(selectedRows[i2], selectedColumns[j]);
                ++j;
            }
            ++i2;
        }
    }

    @Override
    public void setSubMatrix(double[][] subMatrix, int row, int column) throws MatrixIndexException {
        int nRows = subMatrix.length;
        if (nRows == 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_ROW, new Object[0]);
        }
        int nCols = subMatrix[0].length;
        if (nCols == 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_COLUMN, new Object[0]);
        }
        int r = 1;
        while (r < nRows) {
            if (subMatrix[r].length != nCols) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIFFERENT_ROWS_LENGTHS, nCols, subMatrix[r].length);
            }
            ++r;
        }
        MatrixUtils.checkRowIndex(this, row);
        MatrixUtils.checkColumnIndex(this, column);
        MatrixUtils.checkRowIndex(this, nRows + row - 1);
        MatrixUtils.checkColumnIndex(this, nCols + column - 1);
        int i2 = 0;
        while (i2 < nRows) {
            int j = 0;
            while (j < nCols) {
                this.setEntry(row + i2, column + j, subMatrix[i2][j]);
                ++j;
            }
            ++i2;
        }
        this.lu = null;
    }

    @Override
    public RealMatrix getRowMatrix(int row) throws MatrixIndexException {
        MatrixUtils.checkRowIndex(this, row);
        int nCols = this.getColumnDimension();
        RealMatrix out = this.createMatrix(1, nCols);
        int i2 = 0;
        while (i2 < nCols) {
            out.setEntry(0, i2, this.getEntry(row, i2));
            ++i2;
        }
        return out;
    }

    @Override
    public void setRowMatrix(int row, RealMatrix matrix) throws MatrixIndexException, InvalidMatrixException {
        MatrixUtils.checkRowIndex(this, row);
        int nCols = this.getColumnDimension();
        if (matrix.getRowDimension() != 1 || matrix.getColumnDimension() != nCols) {
            throw new InvalidMatrixException(LocalizedFormats.DIMENSIONS_MISMATCH_2x2, matrix.getRowDimension(), matrix.getColumnDimension(), 1, nCols);
        }
        int i2 = 0;
        while (i2 < nCols) {
            this.setEntry(row, i2, matrix.getEntry(0, i2));
            ++i2;
        }
    }

    @Override
    public RealMatrix getColumnMatrix(int column) throws MatrixIndexException {
        MatrixUtils.checkColumnIndex(this, column);
        int nRows = this.getRowDimension();
        RealMatrix out = this.createMatrix(nRows, 1);
        int i2 = 0;
        while (i2 < nRows) {
            out.setEntry(i2, 0, this.getEntry(i2, column));
            ++i2;
        }
        return out;
    }

    @Override
    public void setColumnMatrix(int column, RealMatrix matrix) throws MatrixIndexException, InvalidMatrixException {
        MatrixUtils.checkColumnIndex(this, column);
        int nRows = this.getRowDimension();
        if (matrix.getRowDimension() != nRows || matrix.getColumnDimension() != 1) {
            throw new InvalidMatrixException(LocalizedFormats.DIMENSIONS_MISMATCH_2x2, matrix.getRowDimension(), matrix.getColumnDimension(), nRows, 1);
        }
        int i2 = 0;
        while (i2 < nRows) {
            this.setEntry(i2, column, matrix.getEntry(i2, 0));
            ++i2;
        }
    }

    @Override
    public RealVector getRowVector(int row) throws MatrixIndexException {
        return new ArrayRealVector(this.getRow(row), false);
    }

    @Override
    public void setRowVector(int row, RealVector vector) throws MatrixIndexException, InvalidMatrixException {
        MatrixUtils.checkRowIndex(this, row);
        int nCols = this.getColumnDimension();
        if (vector.getDimension() != nCols) {
            throw new InvalidMatrixException(LocalizedFormats.DIMENSIONS_MISMATCH_2x2, 1, vector.getDimension(), 1, nCols);
        }
        int i2 = 0;
        while (i2 < nCols) {
            this.setEntry(row, i2, vector.getEntry(i2));
            ++i2;
        }
    }

    @Override
    public RealVector getColumnVector(int column) throws MatrixIndexException {
        return new ArrayRealVector(this.getColumn(column), false);
    }

    @Override
    public void setColumnVector(int column, RealVector vector) throws MatrixIndexException, InvalidMatrixException {
        MatrixUtils.checkColumnIndex(this, column);
        int nRows = this.getRowDimension();
        if (vector.getDimension() != nRows) {
            throw new InvalidMatrixException(LocalizedFormats.DIMENSIONS_MISMATCH_2x2, vector.getDimension(), 1, nRows, 1);
        }
        int i2 = 0;
        while (i2 < nRows) {
            this.setEntry(i2, column, vector.getEntry(i2));
            ++i2;
        }
    }

    @Override
    public double[] getRow(int row) throws MatrixIndexException {
        MatrixUtils.checkRowIndex(this, row);
        int nCols = this.getColumnDimension();
        double[] out = new double[nCols];
        int i2 = 0;
        while (i2 < nCols) {
            out[i2] = this.getEntry(row, i2);
            ++i2;
        }
        return out;
    }

    @Override
    public void setRow(int row, double[] array) throws MatrixIndexException, InvalidMatrixException {
        MatrixUtils.checkRowIndex(this, row);
        int nCols = this.getColumnDimension();
        if (array.length != nCols) {
            throw new InvalidMatrixException(LocalizedFormats.DIMENSIONS_MISMATCH_2x2, 1, array.length, 1, nCols);
        }
        int i2 = 0;
        while (i2 < nCols) {
            this.setEntry(row, i2, array[i2]);
            ++i2;
        }
    }

    @Override
    public double[] getColumn(int column) throws MatrixIndexException {
        MatrixUtils.checkColumnIndex(this, column);
        int nRows = this.getRowDimension();
        double[] out = new double[nRows];
        int i2 = 0;
        while (i2 < nRows) {
            out[i2] = this.getEntry(i2, column);
            ++i2;
        }
        return out;
    }

    @Override
    public void setColumn(int column, double[] array) throws MatrixIndexException, InvalidMatrixException {
        MatrixUtils.checkColumnIndex(this, column);
        int nRows = this.getRowDimension();
        if (array.length != nRows) {
            throw new InvalidMatrixException(LocalizedFormats.DIMENSIONS_MISMATCH_2x2, array.length, 1, nRows, 1);
        }
        int i2 = 0;
        while (i2 < nRows) {
            this.setEntry(i2, column, array[i2]);
            ++i2;
        }
    }

    @Override
    public abstract double getEntry(int var1, int var2) throws MatrixIndexException;

    @Override
    public abstract void setEntry(int var1, int var2, double var3) throws MatrixIndexException;

    @Override
    public abstract void addToEntry(int var1, int var2, double var3) throws MatrixIndexException;

    @Override
    public abstract void multiplyEntry(int var1, int var2, double var3) throws MatrixIndexException;

    @Override
    public RealMatrix transpose() {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        final RealMatrix out = this.createMatrix(nCols, nRows);
        this.walkInOptimizedOrder(new DefaultRealMatrixPreservingVisitor(){

            @Override
            public void visit(int row, int column, double value) {
                out.setEntry(column, row, value);
            }
        });
        return out;
    }

    @Override
    @Deprecated
    public RealMatrix inverse() throws InvalidMatrixException {
        if (this.lu == null) {
            this.lu = new LUDecompositionImpl(this, Double.MIN_NORMAL).getSolver();
        }
        return this.lu.getInverse();
    }

    @Override
    @Deprecated
    public double getDeterminant() throws InvalidMatrixException {
        return new LUDecompositionImpl(this, Double.MIN_NORMAL).getDeterminant();
    }

    @Override
    public boolean isSquare() {
        return this.getColumnDimension() == this.getRowDimension();
    }

    @Override
    @Deprecated
    public boolean isSingular() {
        if (this.lu == null) {
            this.lu = new LUDecompositionImpl(this, Double.MIN_NORMAL).getSolver();
        }
        return !this.lu.isNonSingular();
    }

    @Override
    public abstract int getRowDimension();

    @Override
    public abstract int getColumnDimension();

    @Override
    public double getTrace() throws NonSquareMatrixException {
        int nCols;
        int nRows = this.getRowDimension();
        if (nRows != (nCols = this.getColumnDimension())) {
            throw new NonSquareMatrixException(nRows, nCols);
        }
        double trace = 0.0;
        int i2 = 0;
        while (i2 < nRows) {
            trace += this.getEntry(i2, i2);
            ++i2;
        }
        return trace;
    }

    @Override
    public double[] operate(double[] v) throws IllegalArgumentException {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (v.length != nCols) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, v.length, nCols);
        }
        double[] out = new double[nRows];
        int row = 0;
        while (row < nRows) {
            double sum = 0.0;
            int i2 = 0;
            while (i2 < nCols) {
                sum += this.getEntry(row, i2) * v[i2];
                ++i2;
            }
            out[row] = sum;
            ++row;
        }
        return out;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public RealVector operate(RealVector v) throws IllegalArgumentException {
        try {
            return new ArrayRealVector(this.operate(((ArrayRealVector)v).getDataRef()), false);
        }
        catch (ClassCastException cce) {
            nRows = this.getRowDimension();
            nCols = this.getColumnDimension();
            if (v.getDimension() != nCols) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, new Object[]{v.getDimension(), nCols});
            }
            out = new double[nRows];
            row = 0;
            ** while (row < nRows)
        }
lbl-1000:
        // 1 sources

        {
            sum = 0.0;
            i = 0;
            while (i < nCols) {
                sum += this.getEntry(row, i) * v.getEntry(i);
                ++i;
            }
            out[row] = sum;
            ++row;
            continue;
        }
lbl20:
        // 1 sources

        return new ArrayRealVector(out, false);
    }

    @Override
    public double[] preMultiply(double[] v) throws IllegalArgumentException {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (v.length != nRows) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, v.length, nRows);
        }
        double[] out = new double[nCols];
        int col = 0;
        while (col < nCols) {
            double sum = 0.0;
            int i2 = 0;
            while (i2 < nRows) {
                sum += this.getEntry(i2, col) * v[i2];
                ++i2;
            }
            out[col] = sum;
            ++col;
        }
        return out;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public RealVector preMultiply(RealVector v) throws IllegalArgumentException {
        try {
            return new ArrayRealVector(this.preMultiply(((ArrayRealVector)v).getDataRef()), false);
        }
        catch (ClassCastException cce) {
            nRows = this.getRowDimension();
            nCols = this.getColumnDimension();
            if (v.getDimension() != nRows) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, new Object[]{v.getDimension(), nRows});
            }
            out = new double[nCols];
            col = 0;
            ** while (col < nCols)
        }
lbl-1000:
        // 1 sources

        {
            sum = 0.0;
            i = 0;
            while (i < nRows) {
                sum += this.getEntry(i, col) * v.getEntry(i);
                ++i;
            }
            out[col] = sum;
            ++col;
            continue;
        }
lbl20:
        // 1 sources

        return new ArrayRealVector(out);
    }

    @Override
    public double walkInRowOrder(RealMatrixChangingVisitor visitor) throws MatrixVisitorException {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        int row = 0;
        while (row < rows) {
            int column = 0;
            while (column < columns) {
                double oldValue = this.getEntry(row, column);
                double newValue = visitor.visit(row, column, oldValue);
                this.setEntry(row, column, newValue);
                ++column;
            }
            ++row;
        }
        this.lu = null;
        return visitor.end();
    }

    @Override
    public double walkInRowOrder(RealMatrixPreservingVisitor visitor) throws MatrixVisitorException {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        int row = 0;
        while (row < rows) {
            int column = 0;
            while (column < columns) {
                visitor.visit(row, column, this.getEntry(row, column));
                ++column;
            }
            ++row;
        }
        return visitor.end();
    }

    @Override
    public double walkInRowOrder(RealMatrixChangingVisitor visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        MatrixUtils.checkSubMatrixIndex(this, startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        int row = startRow;
        while (row <= endRow) {
            int column = startColumn;
            while (column <= endColumn) {
                double oldValue = this.getEntry(row, column);
                double newValue = visitor.visit(row, column, oldValue);
                this.setEntry(row, column, newValue);
                ++column;
            }
            ++row;
        }
        this.lu = null;
        return visitor.end();
    }

    @Override
    public double walkInRowOrder(RealMatrixPreservingVisitor visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        MatrixUtils.checkSubMatrixIndex(this, startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        int row = startRow;
        while (row <= endRow) {
            int column = startColumn;
            while (column <= endColumn) {
                visitor.visit(row, column, this.getEntry(row, column));
                ++column;
            }
            ++row;
        }
        return visitor.end();
    }

    @Override
    public double walkInColumnOrder(RealMatrixChangingVisitor visitor) throws MatrixVisitorException {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        int column = 0;
        while (column < columns) {
            int row = 0;
            while (row < rows) {
                double oldValue = this.getEntry(row, column);
                double newValue = visitor.visit(row, column, oldValue);
                this.setEntry(row, column, newValue);
                ++row;
            }
            ++column;
        }
        this.lu = null;
        return visitor.end();
    }

    @Override
    public double walkInColumnOrder(RealMatrixPreservingVisitor visitor) throws MatrixVisitorException {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        int column = 0;
        while (column < columns) {
            int row = 0;
            while (row < rows) {
                visitor.visit(row, column, this.getEntry(row, column));
                ++row;
            }
            ++column;
        }
        return visitor.end();
    }

    @Override
    public double walkInColumnOrder(RealMatrixChangingVisitor visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        MatrixUtils.checkSubMatrixIndex(this, startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        int column = startColumn;
        while (column <= endColumn) {
            int row = startRow;
            while (row <= endRow) {
                double oldValue = this.getEntry(row, column);
                double newValue = visitor.visit(row, column, oldValue);
                this.setEntry(row, column, newValue);
                ++row;
            }
            ++column;
        }
        this.lu = null;
        return visitor.end();
    }

    @Override
    public double walkInColumnOrder(RealMatrixPreservingVisitor visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        MatrixUtils.checkSubMatrixIndex(this, startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        int column = startColumn;
        while (column <= endColumn) {
            int row = startRow;
            while (row <= endRow) {
                visitor.visit(row, column, this.getEntry(row, column));
                ++row;
            }
            ++column;
        }
        return visitor.end();
    }

    @Override
    public double walkInOptimizedOrder(RealMatrixChangingVisitor visitor) throws MatrixVisitorException {
        return this.walkInRowOrder(visitor);
    }

    @Override
    public double walkInOptimizedOrder(RealMatrixPreservingVisitor visitor) throws MatrixVisitorException {
        return this.walkInRowOrder(visitor);
    }

    @Override
    public double walkInOptimizedOrder(RealMatrixChangingVisitor visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        return this.walkInRowOrder(visitor, startRow, endRow, startColumn, endColumn);
    }

    @Override
    public double walkInOptimizedOrder(RealMatrixPreservingVisitor visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        return this.walkInRowOrder(visitor, startRow, endRow, startColumn, endColumn);
    }

    @Override
    @Deprecated
    public double[] solve(double[] b) throws IllegalArgumentException, InvalidMatrixException {
        if (this.lu == null) {
            this.lu = new LUDecompositionImpl(this, Double.MIN_NORMAL).getSolver();
        }
        return this.lu.solve(b);
    }

    @Override
    @Deprecated
    public RealMatrix solve(RealMatrix b) throws IllegalArgumentException, InvalidMatrixException {
        if (this.lu == null) {
            this.lu = new LUDecompositionImpl(this, Double.MIN_NORMAL).getSolver();
        }
        return this.lu.solve(b);
    }

    @Deprecated
    public void luDecompose() throws InvalidMatrixException {
        if (this.lu == null) {
            this.lu = new LUDecompositionImpl(this, Double.MIN_NORMAL).getSolver();
        }
    }

    public String toString() {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        StringBuilder res = new StringBuilder();
        String fullClassName = this.getClass().getName();
        String shortClassName = fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
        res.append(shortClassName).append("{");
        int i2 = 0;
        while (i2 < nRows) {
            if (i2 > 0) {
                res.append(",");
            }
            res.append("{");
            int j = 0;
            while (j < nCols) {
                if (j > 0) {
                    res.append(",");
                }
                res.append(this.getEntry(i2, j));
                ++j;
            }
            res.append("}");
            ++i2;
        }
        res.append("}");
        return res.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RealMatrix)) {
            return false;
        }
        RealMatrix m = (RealMatrix)object;
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (m.getColumnDimension() != nCols || m.getRowDimension() != nRows) {
            return false;
        }
        int row = 0;
        while (row < nRows) {
            int col = 0;
            while (col < nCols) {
                if (this.getEntry(row, col) != m.getEntry(row, col)) {
                    return false;
                }
                ++col;
            }
            ++row;
        }
        return true;
    }

    public int hashCode() {
        int ret = 7;
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        ret = ret * 31 + nRows;
        ret = ret * 31 + nCols;
        int row = 0;
        while (row < nRows) {
            int col = 0;
            while (col < nCols) {
                ret = ret * 31 + (11 * (row + 1) + 17 * (col + 1)) * MathUtils.hash(this.getEntry(row, col));
                ++col;
            }
            ++row;
        }
        return ret;
    }
}

