/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.apache.commons.math.Field;
import org.apache.commons.math.FieldElement;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.linear.Array2DRowFieldMatrix;
import org.apache.commons.math.linear.FieldMatrix;
import org.apache.commons.math.linear.FieldVector;
import org.apache.commons.math.linear.MatrixIndexException;

public class ArrayFieldVector<T extends FieldElement<T>>
implements FieldVector<T>,
Serializable {
    private static final long serialVersionUID = 7648186910365927050L;
    protected T[] data;
    private final Field<T> field;

    public ArrayFieldVector(Field<T> field) {
        this(field, 0);
    }

    public ArrayFieldVector(Field<T> field, int size) {
        this.field = field;
        this.data = this.buildArray(size);
        Arrays.fill(this.data, field.getZero());
    }

    public ArrayFieldVector(int size, T preset) {
        this(preset.getField(), size);
        Arrays.fill(this.data, preset);
    }

    public ArrayFieldVector(T[] d) throws IllegalArgumentException {
        try {
            this.field = d[0].getField();
            this.data = (FieldElement[])d.clone();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_MUST_HAVE_AT_LEAST_ONE_ELEMENT, new Object[0]);
        }
    }

    public ArrayFieldVector(Field<T> field, T[] d) {
        this.field = field;
        this.data = (FieldElement[])d.clone();
    }

    public ArrayFieldVector(T[] d, boolean copyArray) throws NullPointerException, IllegalArgumentException {
        if (d.length == 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_MUST_HAVE_AT_LEAST_ONE_ELEMENT, new Object[0]);
        }
        this.field = d[0].getField();
        this.data = copyArray ? (FieldElement[])d.clone() : d;
    }

    public ArrayFieldVector(Field<T> field, T[] d, boolean copyArray) {
        this.field = field;
        this.data = copyArray ? (FieldElement[])d.clone() : d;
    }

    public ArrayFieldVector(T[] d, int pos, int size) {
        if (d.length < pos + size) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.POSITION_SIZE_MISMATCH_INPUT_ARRAY, pos, size, d.length);
        }
        this.field = d[0].getField();
        this.data = this.buildArray(size);
        System.arraycopy(d, pos, this.data, 0, size);
    }

    public ArrayFieldVector(FieldVector<T> v) {
        this.field = v.getField();
        this.data = this.buildArray(v.getDimension());
        int i2 = 0;
        while (i2 < this.data.length) {
            this.data[i2] = v.getEntry(i2);
            ++i2;
        }
    }

    public ArrayFieldVector(ArrayFieldVector<T> v) {
        this.field = v.getField();
        this.data = (FieldElement[])v.data.clone();
    }

    public ArrayFieldVector(ArrayFieldVector<T> v, boolean deep) {
        this.field = v.getField();
        this.data = deep ? (FieldElement[])v.data.clone() : v.data;
    }

    public ArrayFieldVector(ArrayFieldVector<T> v1, ArrayFieldVector<T> v2) {
        this.field = v1.getField();
        this.data = this.buildArray(v1.data.length + v2.data.length);
        System.arraycopy(v1.data, 0, this.data, 0, v1.data.length);
        System.arraycopy(v2.data, 0, this.data, v1.data.length, v2.data.length);
    }

    public ArrayFieldVector(ArrayFieldVector<T> v1, T[] v2) {
        this.field = v1.getField();
        this.data = this.buildArray(v1.data.length + v2.length);
        System.arraycopy(v1.data, 0, this.data, 0, v1.data.length);
        System.arraycopy(v2, 0, this.data, v1.data.length, v2.length);
    }

    public ArrayFieldVector(T[] v1, ArrayFieldVector<T> v2) {
        this.field = v2.getField();
        this.data = this.buildArray(v1.length + v2.data.length);
        System.arraycopy(v1, 0, this.data, 0, v1.length);
        System.arraycopy(v2.data, 0, this.data, v1.length, v2.data.length);
    }

    public ArrayFieldVector(T[] v1, T[] v2) {
        try {
            this.data = this.buildArray(v1.length + v2.length);
            System.arraycopy(v1, 0, this.data, 0, v1.length);
            System.arraycopy(v2, 0, this.data, v1.length, v2.length);
            this.field = this.data[0].getField();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_MUST_HAVE_AT_LEAST_ONE_ELEMENT, new Object[0]);
        }
    }

    public ArrayFieldVector(Field<T> field, T[] v1, T[] v2) {
        if (v1.length + v2.length == 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_MUST_HAVE_AT_LEAST_ONE_ELEMENT, new Object[0]);
        }
        this.data = this.buildArray(v1.length + v2.length);
        System.arraycopy(v1, 0, this.data, 0, v1.length);
        System.arraycopy(v2, 0, this.data, v1.length, v2.length);
        this.field = this.data[0].getField();
    }

    private T[] buildArray(int length) {
        return (FieldElement[])Array.newInstance(((FieldElement)this.field.getZero()).getClass(), length);
    }

    @Override
    public Field<T> getField() {
        return this.field;
    }

    @Override
    public FieldVector<T> copy() {
        return new ArrayFieldVector<T>(this, true);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public FieldVector<T> add(FieldVector<T> v) throws IllegalArgumentException {
        try {
            return this.add((ArrayFieldVector)v);
        }
        catch (ClassCastException cce) {
            this.checkVectorDimensions(v);
            out = this.buildArray(this.data.length);
            i = 0;
            ** while (i < this.data.length)
        }
lbl-1000:
        // 1 sources

        {
            out[i] = (FieldElement)this.data[i].add(v.getEntry(i));
            ++i;
            continue;
        }
lbl11:
        // 1 sources

        return new ArrayFieldVector(out);
    }

    @Override
    public FieldVector<T> add(T[] v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.length);
        FieldElement[] out = this.buildArray(this.data.length);
        int i2 = 0;
        while (i2 < this.data.length) {
            out[i2] = (FieldElement)this.data[i2].add(v[i2]);
            ++i2;
        }
        return new ArrayFieldVector(out);
    }

    @Override
    public ArrayFieldVector<T> add(ArrayFieldVector<T> v) throws IllegalArgumentException {
        return (ArrayFieldVector)this.add((FieldElement[])v.data);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public FieldVector<T> subtract(FieldVector<T> v) throws IllegalArgumentException {
        try {
            return this.subtract((ArrayFieldVector)v);
        }
        catch (ClassCastException cce) {
            this.checkVectorDimensions(v);
            out = this.buildArray(this.data.length);
            i = 0;
            ** while (i < this.data.length)
        }
lbl-1000:
        // 1 sources

        {
            out[i] = (FieldElement)this.data[i].subtract(v.getEntry(i));
            ++i;
            continue;
        }
lbl11:
        // 1 sources

        return new ArrayFieldVector(out);
    }

    @Override
    public FieldVector<T> subtract(T[] v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.length);
        FieldElement[] out = this.buildArray(this.data.length);
        int i2 = 0;
        while (i2 < this.data.length) {
            out[i2] = (FieldElement)this.data[i2].subtract(v[i2]);
            ++i2;
        }
        return new ArrayFieldVector(out);
    }

    @Override
    public ArrayFieldVector<T> subtract(ArrayFieldVector<T> v) throws IllegalArgumentException {
        return (ArrayFieldVector)this.subtract((FieldElement[])v.data);
    }

    @Override
    public FieldVector<T> mapAdd(T d) {
        FieldElement[] out = this.buildArray(this.data.length);
        int i2 = 0;
        while (i2 < this.data.length) {
            out[i2] = (FieldElement)this.data[i2].add(d);
            ++i2;
        }
        return new ArrayFieldVector(out);
    }

    @Override
    public FieldVector<T> mapAddToSelf(T d) {
        int i2 = 0;
        while (i2 < this.data.length) {
            this.data[i2] = (FieldElement)this.data[i2].add(d);
            ++i2;
        }
        return this;
    }

    @Override
    public FieldVector<T> mapSubtract(T d) {
        FieldElement[] out = this.buildArray(this.data.length);
        int i2 = 0;
        while (i2 < this.data.length) {
            out[i2] = (FieldElement)this.data[i2].subtract(d);
            ++i2;
        }
        return new ArrayFieldVector(out);
    }

    @Override
    public FieldVector<T> mapSubtractToSelf(T d) {
        int i2 = 0;
        while (i2 < this.data.length) {
            this.data[i2] = (FieldElement)this.data[i2].subtract(d);
            ++i2;
        }
        return this;
    }

    @Override
    public FieldVector<T> mapMultiply(T d) {
        FieldElement[] out = this.buildArray(this.data.length);
        int i2 = 0;
        while (i2 < this.data.length) {
            out[i2] = (FieldElement)this.data[i2].multiply(d);
            ++i2;
        }
        return new ArrayFieldVector(out);
    }

    @Override
    public FieldVector<T> mapMultiplyToSelf(T d) {
        int i2 = 0;
        while (i2 < this.data.length) {
            this.data[i2] = (FieldElement)this.data[i2].multiply(d);
            ++i2;
        }
        return this;
    }

    @Override
    public FieldVector<T> mapDivide(T d) {
        FieldElement[] out = this.buildArray(this.data.length);
        int i2 = 0;
        while (i2 < this.data.length) {
            out[i2] = (FieldElement)this.data[i2].divide(d);
            ++i2;
        }
        return new ArrayFieldVector(out);
    }

    @Override
    public FieldVector<T> mapDivideToSelf(T d) {
        int i2 = 0;
        while (i2 < this.data.length) {
            this.data[i2] = (FieldElement)this.data[i2].divide(d);
            ++i2;
        }
        return this;
    }

    @Override
    public FieldVector<T> mapInv() {
        FieldElement[] out = this.buildArray(this.data.length);
        FieldElement one = (FieldElement)this.field.getOne();
        int i2 = 0;
        while (i2 < this.data.length) {
            out[i2] = (FieldElement)one.divide(this.data[i2]);
            ++i2;
        }
        return new ArrayFieldVector(out);
    }

    @Override
    public FieldVector<T> mapInvToSelf() {
        FieldElement one = (FieldElement)this.field.getOne();
        int i2 = 0;
        while (i2 < this.data.length) {
            this.data[i2] = (FieldElement)one.divide(this.data[i2]);
            ++i2;
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public FieldVector<T> ebeMultiply(FieldVector<T> v) throws IllegalArgumentException {
        try {
            return this.ebeMultiply((ArrayFieldVector)v);
        }
        catch (ClassCastException cce) {
            this.checkVectorDimensions(v);
            out = this.buildArray(this.data.length);
            i = 0;
            ** while (i < this.data.length)
        }
lbl-1000:
        // 1 sources

        {
            out[i] = (FieldElement)this.data[i].multiply(v.getEntry(i));
            ++i;
            continue;
        }
lbl11:
        // 1 sources

        return new ArrayFieldVector(out);
    }

    @Override
    public FieldVector<T> ebeMultiply(T[] v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.length);
        FieldElement[] out = this.buildArray(this.data.length);
        int i2 = 0;
        while (i2 < this.data.length) {
            out[i2] = (FieldElement)this.data[i2].multiply(v[i2]);
            ++i2;
        }
        return new ArrayFieldVector(out);
    }

    @Override
    public ArrayFieldVector<T> ebeMultiply(ArrayFieldVector<T> v) throws IllegalArgumentException {
        return (ArrayFieldVector)this.ebeMultiply((FieldElement[])v.data);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public FieldVector<T> ebeDivide(FieldVector<T> v) throws IllegalArgumentException {
        try {
            return this.ebeDivide((ArrayFieldVector)v);
        }
        catch (ClassCastException cce) {
            this.checkVectorDimensions(v);
            out = this.buildArray(this.data.length);
            i = 0;
            ** while (i < this.data.length)
        }
lbl-1000:
        // 1 sources

        {
            out[i] = (FieldElement)this.data[i].divide(v.getEntry(i));
            ++i;
            continue;
        }
lbl11:
        // 1 sources

        return new ArrayFieldVector(out);
    }

    @Override
    public FieldVector<T> ebeDivide(T[] v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.length);
        FieldElement[] out = this.buildArray(this.data.length);
        int i2 = 0;
        while (i2 < this.data.length) {
            out[i2] = (FieldElement)this.data[i2].divide(v[i2]);
            ++i2;
        }
        return new ArrayFieldVector(out);
    }

    @Override
    public ArrayFieldVector<T> ebeDivide(ArrayFieldVector<T> v) throws IllegalArgumentException {
        return (ArrayFieldVector)this.ebeDivide((FieldElement[])v.data);
    }

    @Override
    public T[] getData() {
        return (FieldElement[])this.data.clone();
    }

    public T[] getDataRef() {
        return this.data;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public T dotProduct(FieldVector<T> v) throws IllegalArgumentException {
        try {
            return this.dotProduct((ArrayFieldVector)v);
        }
        catch (ClassCastException cce) {
            this.checkVectorDimensions(v);
            dot = (FieldElement)this.field.getZero();
            i = 0;
            ** while (i < this.data.length)
        }
lbl-1000:
        // 1 sources

        {
            dot = dot.add((FieldElement)this.data[i].multiply(v.getEntry(i)));
            ++i;
            continue;
        }
lbl11:
        // 1 sources

        return (T)dot;
    }

    @Override
    public T dotProduct(T[] v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.length);
        FieldElement dot = (FieldElement)this.field.getZero();
        int i2 = 0;
        while (i2 < this.data.length) {
            dot = dot.add((FieldElement)this.data[i2].multiply(v[i2]));
            ++i2;
        }
        return (T)dot;
    }

    @Override
    public T dotProduct(ArrayFieldVector<T> v) throws IllegalArgumentException {
        return (T)this.dotProduct((FieldElement[])v.data);
    }

    @Override
    public FieldVector<T> projection(FieldVector<T> v) {
        return v.mapMultiply((FieldElement)this.dotProduct(v).divide(v.dotProduct(v)));
    }

    @Override
    public FieldVector<T> projection(T[] v) {
        return this.projection(new ArrayFieldVector(v, false));
    }

    @Override
    public ArrayFieldVector<T> projection(ArrayFieldVector<T> v) {
        return (ArrayFieldVector)v.mapMultiply((FieldElement)this.dotProduct(v).divide(v.dotProduct(v)));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public FieldMatrix<T> outerProduct(FieldVector<T> v) throws IllegalArgumentException {
        try {
            return this.outerProduct((ArrayFieldVector)v);
        }
        catch (ClassCastException cce) {
            this.checkVectorDimensions(v);
            m = this.data.length;
            out = new Array2DRowFieldMatrix<FieldElement>(this.field, m, m);
            i = 0;
            ** while (i < this.data.length)
        }
lbl-1000:
        // 1 sources

        {
            j = 0;
            while (j < this.data.length) {
                out.setEntry(i, j, (FieldElement)this.data[i].multiply(v.getEntry(j)));
                ++j;
            }
            ++i;
            continue;
        }
lbl16:
        // 1 sources

        return out;
    }

    @Override
    public FieldMatrix<T> outerProduct(ArrayFieldVector<T> v) throws IllegalArgumentException {
        return this.outerProduct((FieldElement[])v.data);
    }

    @Override
    public FieldMatrix<T> outerProduct(T[] v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.length);
        int m = this.data.length;
        Array2DRowFieldMatrix<FieldElement> out = new Array2DRowFieldMatrix<FieldElement>(this.field, m, m);
        int i2 = 0;
        while (i2 < this.data.length) {
            int j = 0;
            while (j < this.data.length) {
                out.setEntry(i2, j, (FieldElement)this.data[i2].multiply(v[j]));
                ++j;
            }
            ++i2;
        }
        return out;
    }

    @Override
    public T getEntry(int index) throws MatrixIndexException {
        return this.data[index];
    }

    @Override
    public int getDimension() {
        return this.data.length;
    }

    @Override
    public FieldVector<T> append(FieldVector<T> v) {
        try {
            return this.append((ArrayFieldVector)v);
        }
        catch (ClassCastException cce) {
            return new ArrayFieldVector<T>(this, new ArrayFieldVector<T>(v));
        }
    }

    @Override
    public ArrayFieldVector<T> append(ArrayFieldVector<T> v) {
        return new ArrayFieldVector<T>(this, v);
    }

    @Override
    public FieldVector<T> append(T in) {
        FieldElement[] out = this.buildArray(this.data.length + 1);
        System.arraycopy(this.data, 0, out, 0, this.data.length);
        out[this.data.length] = in;
        return new ArrayFieldVector(out);
    }

    @Override
    public FieldVector<T> append(T[] in) {
        return new ArrayFieldVector(this, in);
    }

    @Override
    public FieldVector<T> getSubVector(int index, int n) {
        ArrayFieldVector<T> out = new ArrayFieldVector<T>(this.field, n);
        try {
            System.arraycopy(this.data, index, out.data, 0, n);
        }
        catch (IndexOutOfBoundsException e) {
            this.checkIndex(index);
            this.checkIndex(index + n - 1);
        }
        return out;
    }

    @Override
    public void setEntry(int index, T value) {
        try {
            this.data[index] = value;
        }
        catch (IndexOutOfBoundsException e) {
            this.checkIndex(index);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void setSubVector(int index, FieldVector<T> v) {
        block5: {
            try {
                try {
                    this.set(index, (ArrayFieldVector)v);
                    break block5;
                }
                catch (ClassCastException cce) {
                    i = index;
                    ** while (i < index + v.getDimension())
                }
lbl-1000:
                // 1 sources

                {
                    this.data[i] = v.getEntry(i - index);
                    ++i;
                    continue;
lbl11:
                    // 1 sources

                }
            }
            catch (IndexOutOfBoundsException e) {
                this.checkIndex(index);
                this.checkIndex(index + v.getDimension() - 1);
            }
        }
    }

    @Override
    public void setSubVector(int index, T[] v) {
        try {
            System.arraycopy(v, 0, this.data, index, v.length);
        }
        catch (IndexOutOfBoundsException e) {
            this.checkIndex(index);
            this.checkIndex(index + v.length - 1);
        }
    }

    public void set(int index, ArrayFieldVector<T> v) throws MatrixIndexException {
        this.setSubVector(index, (FieldElement[])v.data);
    }

    @Override
    public void set(T value) {
        Arrays.fill(this.data, value);
    }

    @Override
    public T[] toArray() {
        return (FieldElement[])this.data.clone();
    }

    protected void checkVectorDimensions(FieldVector<T> v) throws IllegalArgumentException {
        this.checkVectorDimensions(v.getDimension());
    }

    protected void checkVectorDimensions(int n) throws IllegalArgumentException {
        if (this.data.length != n) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, this.data.length, n);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        try {
            FieldVector rhs = (FieldVector)other;
            if (this.data.length != rhs.getDimension()) {
                return false;
            }
            int i2 = 0;
            while (true) {
                if (i2 >= this.data.length) {
                    return true;
                }
                if (!this.data[i2].equals(rhs.getEntry(i2))) {
                    return false;
                }
                ++i2;
            }
        }
        catch (ClassCastException ex) {
            return false;
        }
    }

    public int hashCode() {
        int h = 3542;
        T[] TArray = this.data;
        int n = this.data.length;
        int n2 = 0;
        while (n2 < n) {
            T a = TArray[n2];
            h ^= a.hashCode();
            ++n2;
        }
        return h;
    }

    private void checkIndex(int index) throws MatrixIndexException {
        if (index < 0 || index >= this.getDimension()) {
            throw new MatrixIndexException(LocalizedFormats.INDEX_OUT_OF_RANGE, index, 0, this.getDimension() - 1);
        }
    }
}

