/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.util.FastMath;

class BiDiagonalTransformer {
    private final double[][] householderVectors;
    private final double[] main;
    private final double[] secondary;
    private RealMatrix cachedU;
    private RealMatrix cachedB;
    private RealMatrix cachedV;

    public BiDiagonalTransformer(RealMatrix matrix) {
        int m = matrix.getRowDimension();
        int n = matrix.getColumnDimension();
        int p = FastMath.min(m, n);
        this.householderVectors = matrix.getData();
        this.main = new double[p];
        this.secondary = new double[p - 1];
        this.cachedU = null;
        this.cachedB = null;
        this.cachedV = null;
        if (m >= n) {
            this.transformToUpperBiDiagonal();
        } else {
            this.transformToLowerBiDiagonal();
        }
    }

    public RealMatrix getU() {
        if (this.cachedU == null) {
            int m = this.householderVectors.length;
            int n = this.householderVectors[0].length;
            int p = this.main.length;
            int diagOffset = m >= n ? 0 : 1;
            double[] diagonal = m >= n ? this.main : this.secondary;
            this.cachedU = MatrixUtils.createRealMatrix(m, m);
            int k = m - 1;
            while (k >= p) {
                this.cachedU.setEntry(k, k, 1.0);
                --k;
            }
            k = p - 1;
            while (k >= diagOffset) {
                double[] hK = this.householderVectors[k];
                this.cachedU.setEntry(k, k, 1.0);
                if (hK[k - diagOffset] != 0.0) {
                    int j = k;
                    while (j < m) {
                        double alpha = 0.0;
                        int i2 = k;
                        while (i2 < m) {
                            alpha -= this.cachedU.getEntry(i2, j) * this.householderVectors[i2][k - diagOffset];
                            ++i2;
                        }
                        alpha /= diagonal[k - diagOffset] * hK[k - diagOffset];
                        i2 = k;
                        while (i2 < m) {
                            this.cachedU.addToEntry(i2, j, -alpha * this.householderVectors[i2][k - diagOffset]);
                            ++i2;
                        }
                        ++j;
                    }
                }
                --k;
            }
            if (diagOffset > 0) {
                this.cachedU.setEntry(0, 0, 1.0);
            }
        }
        return this.cachedU;
    }

    public RealMatrix getB() {
        if (this.cachedB == null) {
            int m = this.householderVectors.length;
            int n = this.householderVectors[0].length;
            this.cachedB = MatrixUtils.createRealMatrix(m, n);
            int i2 = 0;
            while (i2 < this.main.length) {
                this.cachedB.setEntry(i2, i2, this.main[i2]);
                if (m < n) {
                    if (i2 > 0) {
                        this.cachedB.setEntry(i2, i2 - 1, this.secondary[i2 - 1]);
                    }
                } else if (i2 < this.main.length - 1) {
                    this.cachedB.setEntry(i2, i2 + 1, this.secondary[i2]);
                }
                ++i2;
            }
        }
        return this.cachedB;
    }

    public RealMatrix getV() {
        if (this.cachedV == null) {
            int m = this.householderVectors.length;
            int n = this.householderVectors[0].length;
            int p = this.main.length;
            int diagOffset = m >= n ? 1 : 0;
            double[] diagonal = m >= n ? this.secondary : this.main;
            this.cachedV = MatrixUtils.createRealMatrix(n, n);
            int k = n - 1;
            while (k >= p) {
                this.cachedV.setEntry(k, k, 1.0);
                --k;
            }
            k = p - 1;
            while (k >= diagOffset) {
                double[] hK = this.householderVectors[k - diagOffset];
                this.cachedV.setEntry(k, k, 1.0);
                if (hK[k] != 0.0) {
                    int j = k;
                    while (j < n) {
                        double beta = 0.0;
                        int i2 = k;
                        while (i2 < n) {
                            beta -= this.cachedV.getEntry(i2, j) * hK[i2];
                            ++i2;
                        }
                        beta /= diagonal[k - diagOffset] * hK[k];
                        i2 = k;
                        while (i2 < n) {
                            this.cachedV.addToEntry(i2, j, -beta * hK[i2]);
                            ++i2;
                        }
                        ++j;
                    }
                }
                --k;
            }
            if (diagOffset > 0) {
                this.cachedV.setEntry(0, 0, 1.0);
            }
        }
        return this.cachedV;
    }

    double[][] getHouseholderVectorsRef() {
        return this.householderVectors;
    }

    double[] getMainDiagonalRef() {
        return this.main;
    }

    double[] getSecondaryDiagonalRef() {
        return this.secondary;
    }

    boolean isUpperBiDiagonal() {
        return this.householderVectors.length >= this.householderVectors[0].length;
    }

    private void transformToUpperBiDiagonal() {
        int m = this.householderVectors.length;
        int n = this.householderVectors[0].length;
        int k = 0;
        while (k < n) {
            int j;
            double a;
            double xNormSqr = 0.0;
            int i2 = k;
            while (i2 < m) {
                double c = this.householderVectors[i2][k];
                xNormSqr += c * c;
                ++i2;
            }
            double[] hK = this.householderVectors[k];
            this.main[k] = a = hK[k] > 0.0 ? -FastMath.sqrt(xNormSqr) : FastMath.sqrt(xNormSqr);
            if (a != 0.0) {
                int n2 = k;
                hK[n2] = hK[n2] - a;
                j = k + 1;
                while (j < n) {
                    double[] hI;
                    double alpha = 0.0;
                    int i3 = k;
                    while (i3 < m) {
                        hI = this.householderVectors[i3];
                        alpha -= hI[j] * hI[k];
                        ++i3;
                    }
                    alpha /= a * this.householderVectors[k][k];
                    i3 = k;
                    while (i3 < m) {
                        hI = this.householderVectors[i3];
                        int n3 = j;
                        hI[n3] = hI[n3] - alpha * hI[k];
                        ++i3;
                    }
                    ++j;
                }
            }
            if (k < n - 1) {
                double b;
                xNormSqr = 0.0;
                j = k + 1;
                while (j < n) {
                    double c = hK[j];
                    xNormSqr += c * c;
                    ++j;
                }
                this.secondary[k] = b = hK[k + 1] > 0.0 ? -FastMath.sqrt(xNormSqr) : FastMath.sqrt(xNormSqr);
                if (b != 0.0) {
                    int n4 = k + 1;
                    hK[n4] = hK[n4] - b;
                    int i4 = k + 1;
                    while (i4 < m) {
                        double[] hI = this.householderVectors[i4];
                        double beta = 0.0;
                        int j2 = k + 1;
                        while (j2 < n) {
                            beta -= hI[j2] * hK[j2];
                            ++j2;
                        }
                        beta /= b * hK[k + 1];
                        j2 = k + 1;
                        while (j2 < n) {
                            int n5 = j2;
                            hI[n5] = hI[n5] - beta * hK[j2];
                            ++j2;
                        }
                        ++i4;
                    }
                }
            }
            ++k;
        }
    }

    private void transformToLowerBiDiagonal() {
        int m = this.householderVectors.length;
        int n = this.householderVectors[0].length;
        int k = 0;
        while (k < m) {
            double a;
            double[] hK = this.householderVectors[k];
            double xNormSqr = 0.0;
            int j = k;
            while (j < n) {
                double c = hK[j];
                xNormSqr += c * c;
                ++j;
            }
            this.main[k] = a = hK[k] > 0.0 ? -FastMath.sqrt(xNormSqr) : FastMath.sqrt(xNormSqr);
            if (a != 0.0) {
                int n2 = k;
                hK[n2] = hK[n2] - a;
                int i2 = k + 1;
                while (i2 < m) {
                    double[] hI = this.householderVectors[i2];
                    double alpha = 0.0;
                    int j2 = k;
                    while (j2 < n) {
                        alpha -= hI[j2] * hK[j2];
                        ++j2;
                    }
                    alpha /= a * this.householderVectors[k][k];
                    j2 = k;
                    while (j2 < n) {
                        int n3 = j2;
                        hI[n3] = hI[n3] - alpha * hK[j2];
                        ++j2;
                    }
                    ++i2;
                }
            }
            if (k < m - 1) {
                double b;
                double[] hKp1 = this.householderVectors[k + 1];
                xNormSqr = 0.0;
                int i3 = k + 1;
                while (i3 < m) {
                    double c = this.householderVectors[i3][k];
                    xNormSqr += c * c;
                    ++i3;
                }
                this.secondary[k] = b = hKp1[k] > 0.0 ? -FastMath.sqrt(xNormSqr) : FastMath.sqrt(xNormSqr);
                if (b != 0.0) {
                    int n4 = k;
                    hKp1[n4] = hKp1[n4] - b;
                    int j3 = k + 1;
                    while (j3 < n) {
                        double[] hI;
                        double beta = 0.0;
                        int i4 = k + 1;
                        while (i4 < m) {
                            hI = this.householderVectors[i4];
                            beta -= hI[j3] * hI[k];
                            ++i4;
                        }
                        beta /= b * hKp1[k];
                        i4 = k + 1;
                        while (i4 < m) {
                            hI = this.householderVectors[i4];
                            int n5 = j3;
                            hI[n5] = hI[n5] - beta * hI[k];
                            ++i4;
                        }
                        ++j3;
                    }
                }
            }
            ++k;
        }
    }
}

