/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.linear.BigMatrix;
import org.apache.commons.math.linear.InvalidMatrixException;
import org.apache.commons.math.linear.MatrixIndexException;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.NonSquareMatrixException;
import org.apache.commons.math.linear.SingularMatrixException;

@Deprecated
public class BigMatrixImpl
implements BigMatrix,
Serializable {
    static final BigDecimal ZERO = new BigDecimal(0);
    static final BigDecimal ONE = new BigDecimal(1);
    private static final BigDecimal TOO_SMALL = new BigDecimal(1.0E-11);
    private static final long serialVersionUID = -1011428905656140431L;
    protected BigDecimal[][] data = null;
    protected BigDecimal[][] lu = null;
    protected int[] permutation = null;
    protected int parity = 1;
    private int roundingMode = 4;
    private int scale = 64;

    public BigMatrixImpl() {
    }

    public BigMatrixImpl(int rowDimension, int columnDimension) {
        if (rowDimension < 1) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.INSUFFICIENT_DIMENSION, rowDimension, 1);
        }
        if (columnDimension < 1) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.INSUFFICIENT_DIMENSION, columnDimension, 1);
        }
        this.data = new BigDecimal[rowDimension][columnDimension];
        this.lu = null;
    }

    public BigMatrixImpl(BigDecimal[][] d) {
        this.copyIn(d);
        this.lu = null;
    }

    public BigMatrixImpl(BigDecimal[][] d, boolean copyArray) {
        if (copyArray) {
            this.copyIn(d);
        } else {
            if (d == null) {
                throw new NullPointerException();
            }
            int nRows = d.length;
            if (nRows == 0) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_ROW, new Object[0]);
            }
            int nCols = d[0].length;
            if (nCols == 0) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_COLUMN, new Object[0]);
            }
            int r = 1;
            while (r < nRows) {
                if (d[r].length != nCols) {
                    throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIFFERENT_ROWS_LENGTHS, nCols, d[r].length);
                }
                ++r;
            }
            this.data = d;
        }
        this.lu = null;
    }

    public BigMatrixImpl(double[][] d) {
        int nRows = d.length;
        if (nRows == 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_ROW, new Object[0]);
        }
        int nCols = d[0].length;
        if (nCols == 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_COLUMN, new Object[0]);
        }
        int row = 1;
        while (row < nRows) {
            if (d[row].length != nCols) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIFFERENT_ROWS_LENGTHS, nCols, d[row].length);
            }
            ++row;
        }
        this.copyIn(d);
        this.lu = null;
    }

    public BigMatrixImpl(String[][] d) {
        int nRows = d.length;
        if (nRows == 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_ROW, new Object[0]);
        }
        int nCols = d[0].length;
        if (nCols == 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_COLUMN, new Object[0]);
        }
        int row = 1;
        while (row < nRows) {
            if (d[row].length != nCols) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIFFERENT_ROWS_LENGTHS, nCols, d[row].length);
            }
            ++row;
        }
        this.copyIn(d);
        this.lu = null;
    }

    public BigMatrixImpl(BigDecimal[] v) {
        int nRows = v.length;
        this.data = new BigDecimal[nRows][1];
        int row = 0;
        while (row < nRows) {
            this.data[row][0] = v[row];
            ++row;
        }
    }

    @Override
    public BigMatrix copy() {
        return new BigMatrixImpl(this.copyOut(), false);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public BigMatrix add(BigMatrix m) throws IllegalArgumentException {
        try {
            return this.add((BigMatrixImpl)m);
        }
        catch (ClassCastException cce) {
            MatrixUtils.checkAdditionCompatible(this, m);
            rowCount = this.getRowDimension();
            columnCount = this.getColumnDimension();
            outData = new BigDecimal[rowCount][columnCount];
            row = 0;
            ** while (row < rowCount)
        }
lbl-1000:
        // 1 sources

        {
            dataRow = this.data[row];
            outDataRow = outData[row];
            col = 0;
            while (col < columnCount) {
                outDataRow[col] = dataRow[col].add(m.getEntry(row, col));
                ++col;
            }
            ++row;
            continue;
        }
lbl19:
        // 1 sources

        return new BigMatrixImpl(outData, false);
    }

    public BigMatrixImpl add(BigMatrixImpl m) throws IllegalArgumentException {
        MatrixUtils.checkAdditionCompatible(this, m);
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        BigDecimal[][] outData = new BigDecimal[rowCount][columnCount];
        int row = 0;
        while (row < rowCount) {
            BigDecimal[] dataRow = this.data[row];
            BigDecimal[] mRow = m.data[row];
            BigDecimal[] outDataRow = outData[row];
            int col = 0;
            while (col < columnCount) {
                outDataRow[col] = dataRow[col].add(mRow[col]);
                ++col;
            }
            ++row;
        }
        return new BigMatrixImpl(outData, false);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public BigMatrix subtract(BigMatrix m) throws IllegalArgumentException {
        try {
            return this.subtract((BigMatrixImpl)m);
        }
        catch (ClassCastException cce) {
            MatrixUtils.checkSubtractionCompatible(this, m);
            rowCount = this.getRowDimension();
            columnCount = this.getColumnDimension();
            outData = new BigDecimal[rowCount][columnCount];
            row = 0;
            ** while (row < rowCount)
        }
lbl-1000:
        // 1 sources

        {
            dataRow = this.data[row];
            outDataRow = outData[row];
            col = 0;
            while (col < columnCount) {
                outDataRow[col] = dataRow[col].subtract(this.getEntry(row, col));
                ++col;
            }
            ++row;
            continue;
        }
lbl19:
        // 1 sources

        return new BigMatrixImpl(outData, false);
    }

    public BigMatrixImpl subtract(BigMatrixImpl m) throws IllegalArgumentException {
        MatrixUtils.checkSubtractionCompatible(this, m);
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        BigDecimal[][] outData = new BigDecimal[rowCount][columnCount];
        int row = 0;
        while (row < rowCount) {
            BigDecimal[] dataRow = this.data[row];
            BigDecimal[] mRow = m.data[row];
            BigDecimal[] outDataRow = outData[row];
            int col = 0;
            while (col < columnCount) {
                outDataRow[col] = dataRow[col].subtract(mRow[col]);
                ++col;
            }
            ++row;
        }
        return new BigMatrixImpl(outData, false);
    }

    @Override
    public BigMatrix scalarAdd(BigDecimal d) {
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        BigDecimal[][] outData = new BigDecimal[rowCount][columnCount];
        int row = 0;
        while (row < rowCount) {
            BigDecimal[] dataRow = this.data[row];
            BigDecimal[] outDataRow = outData[row];
            int col = 0;
            while (col < columnCount) {
                outDataRow[col] = dataRow[col].add(d);
                ++col;
            }
            ++row;
        }
        return new BigMatrixImpl(outData, false);
    }

    @Override
    public BigMatrix scalarMultiply(BigDecimal d) {
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        BigDecimal[][] outData = new BigDecimal[rowCount][columnCount];
        int row = 0;
        while (row < rowCount) {
            BigDecimal[] dataRow = this.data[row];
            BigDecimal[] outDataRow = outData[row];
            int col = 0;
            while (col < columnCount) {
                outDataRow[col] = dataRow[col].multiply(d);
                ++col;
            }
            ++row;
        }
        return new BigMatrixImpl(outData, false);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public BigMatrix multiply(BigMatrix m) throws IllegalArgumentException {
        try {
            return this.multiply((BigMatrixImpl)m);
        }
        catch (ClassCastException cce) {
            MatrixUtils.checkMultiplicationCompatible(this, m);
            nRows = this.getRowDimension();
            nCols = m.getColumnDimension();
            nSum = this.getColumnDimension();
            outData = new BigDecimal[nRows][nCols];
            row = 0;
            ** while (row < nRows)
        }
lbl-1000:
        // 1 sources

        {
            dataRow = this.data[row];
            outDataRow = outData[row];
            col = 0;
            while (col < nCols) {
                sum = BigMatrixImpl.ZERO;
                i = 0;
                while (i < nSum) {
                    sum = sum.add(dataRow[i].multiply(m.getEntry(i, col)));
                    ++i;
                }
                outDataRow[col] = sum;
                ++col;
            }
            ++row;
            continue;
        }
lbl26:
        // 1 sources

        return new BigMatrixImpl(outData, false);
    }

    public BigMatrixImpl multiply(BigMatrixImpl m) throws IllegalArgumentException {
        MatrixUtils.checkMultiplicationCompatible(this, m);
        int nRows = this.getRowDimension();
        int nCols = m.getColumnDimension();
        int nSum = this.getColumnDimension();
        BigDecimal[][] outData = new BigDecimal[nRows][nCols];
        int row = 0;
        while (row < nRows) {
            BigDecimal[] dataRow = this.data[row];
            BigDecimal[] outDataRow = outData[row];
            int col = 0;
            while (col < nCols) {
                BigDecimal sum = ZERO;
                int i2 = 0;
                while (i2 < nSum) {
                    sum = sum.add(dataRow[i2].multiply(m.data[i2][col]));
                    ++i2;
                }
                outDataRow[col] = sum;
                ++col;
            }
            ++row;
        }
        return new BigMatrixImpl(outData, false);
    }

    @Override
    public BigMatrix preMultiply(BigMatrix m) throws IllegalArgumentException {
        return m.multiply(this);
    }

    @Override
    public BigDecimal[][] getData() {
        return this.copyOut();
    }

    @Override
    public double[][] getDataAsDoubleArray() {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        double[][] d = new double[nRows][nCols];
        int i2 = 0;
        while (i2 < nRows) {
            int j = 0;
            while (j < nCols) {
                d[i2][j] = this.data[i2][j].doubleValue();
                ++j;
            }
            ++i2;
        }
        return d;
    }

    public BigDecimal[][] getDataRef() {
        return this.data;
    }

    @Override
    public int getRoundingMode() {
        return this.roundingMode;
    }

    public void setRoundingMode(int roundingMode) {
        this.roundingMode = roundingMode;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    @Override
    public BigDecimal getNorm() {
        BigDecimal maxColSum = ZERO;
        int col = 0;
        while (col < this.getColumnDimension()) {
            BigDecimal sum = ZERO;
            int row = 0;
            while (row < this.getRowDimension()) {
                sum = sum.add(this.data[row][col].abs());
                ++row;
            }
            maxColSum = maxColSum.max(sum);
            ++col;
        }
        return maxColSum;
    }

    @Override
    public BigMatrix getSubMatrix(int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException {
        MatrixUtils.checkRowIndex(this, startRow);
        MatrixUtils.checkRowIndex(this, endRow);
        if (startRow > endRow) {
            throw new MatrixIndexException(LocalizedFormats.INITIAL_ROW_AFTER_FINAL_ROW, startRow, endRow);
        }
        MatrixUtils.checkColumnIndex(this, startColumn);
        MatrixUtils.checkColumnIndex(this, endColumn);
        if (startColumn > endColumn) {
            throw new MatrixIndexException(LocalizedFormats.INITIAL_COLUMN_AFTER_FINAL_COLUMN, startColumn, endColumn);
        }
        BigDecimal[][] subMatrixData = new BigDecimal[endRow - startRow + 1][endColumn - startColumn + 1];
        int i2 = startRow;
        while (i2 <= endRow) {
            System.arraycopy(this.data[i2], startColumn, subMatrixData[i2 - startRow], 0, endColumn - startColumn + 1);
            ++i2;
        }
        return new BigMatrixImpl(subMatrixData, false);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public BigMatrix getSubMatrix(int[] selectedRows, int[] selectedColumns) throws MatrixIndexException {
        block8: {
            if (selectedRows.length * selectedColumns.length == 0) {
                if (selectedRows.length == 0) {
                    throw new MatrixIndexException(LocalizedFormats.EMPTY_SELECTED_ROW_INDEX_ARRAY, new Object[0]);
                }
                throw new MatrixIndexException(LocalizedFormats.EMPTY_SELECTED_COLUMN_INDEX_ARRAY, new Object[0]);
            }
            subMatrixData = new BigDecimal[selectedRows.length][selectedColumns.length];
            try {
                i = 0;
                while (i < selectedRows.length) {
                    subI = subMatrixData[i];
                    dataSelectedI = this.data[selectedRows[i]];
                    j = 0;
                    while (j < selectedColumns.length) {
                        subI[j] = dataSelectedI[selectedColumns[j]];
                        ++j;
                    }
                    ++i;
                }
                break block8;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                var8_12 = selectedRows;
                var7_11 = selectedRows.length;
                var6_9 = 0;
                ** while (var6_9 < var7_11)
            }
lbl-1000:
            // 1 sources

            {
                row = var8_12[var6_9];
                MatrixUtils.checkRowIndex(this, row);
                ++var6_9;
                continue;
            }
lbl28:
            // 1 sources

            var8_12 = selectedColumns;
            var7_11 = selectedColumns.length;
            var6_9 = 0;
            while (var6_9 < var7_11) {
                column = var8_12[var6_9];
                MatrixUtils.checkColumnIndex(this, column);
                ++var6_9;
            }
        }
        return new BigMatrixImpl(subMatrixData, false);
    }

    public void setSubMatrix(BigDecimal[][] subMatrix, int row, int column) throws MatrixIndexException {
        int nRows = subMatrix.length;
        if (nRows == 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_ROW, new Object[0]);
        }
        int nCols = subMatrix[0].length;
        if (nCols == 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_COLUMN, new Object[0]);
        }
        int r = 1;
        while (r < nRows) {
            if (subMatrix[r].length != nCols) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIFFERENT_ROWS_LENGTHS, nCols, subMatrix[r].length);
            }
            ++r;
        }
        if (this.data == null) {
            if (row > 0) {
                throw MathRuntimeException.createIllegalStateException(LocalizedFormats.FIRST_ROWS_NOT_INITIALIZED_YET, row);
            }
            if (column > 0) {
                throw MathRuntimeException.createIllegalStateException(LocalizedFormats.FIRST_COLUMNS_NOT_INITIALIZED_YET, column);
            }
            this.data = new BigDecimal[nRows][nCols];
            System.arraycopy(subMatrix, 0, this.data, 0, subMatrix.length);
        } else {
            MatrixUtils.checkRowIndex(this, row);
            MatrixUtils.checkColumnIndex(this, column);
            MatrixUtils.checkRowIndex(this, nRows + row - 1);
            MatrixUtils.checkColumnIndex(this, nCols + column - 1);
        }
        int i2 = 0;
        while (i2 < nRows) {
            System.arraycopy(subMatrix[i2], 0, this.data[row + i2], column, nCols);
            ++i2;
        }
        this.lu = null;
    }

    @Override
    public BigMatrix getRowMatrix(int row) throws MatrixIndexException {
        MatrixUtils.checkRowIndex(this, row);
        int ncols = this.getColumnDimension();
        BigDecimal[][] out = new BigDecimal[1][ncols];
        System.arraycopy(this.data[row], 0, out[0], 0, ncols);
        return new BigMatrixImpl(out, false);
    }

    @Override
    public BigMatrix getColumnMatrix(int column) throws MatrixIndexException {
        MatrixUtils.checkColumnIndex(this, column);
        int nRows = this.getRowDimension();
        BigDecimal[][] out = new BigDecimal[nRows][1];
        int row = 0;
        while (row < nRows) {
            out[row][0] = this.data[row][column];
            ++row;
        }
        return new BigMatrixImpl(out, false);
    }

    @Override
    public BigDecimal[] getRow(int row) throws MatrixIndexException {
        MatrixUtils.checkRowIndex(this, row);
        int ncols = this.getColumnDimension();
        BigDecimal[] out = new BigDecimal[ncols];
        System.arraycopy(this.data[row], 0, out, 0, ncols);
        return out;
    }

    @Override
    public double[] getRowAsDoubleArray(int row) throws MatrixIndexException {
        MatrixUtils.checkRowIndex(this, row);
        int ncols = this.getColumnDimension();
        double[] out = new double[ncols];
        int i2 = 0;
        while (i2 < ncols) {
            out[i2] = this.data[row][i2].doubleValue();
            ++i2;
        }
        return out;
    }

    @Override
    public BigDecimal[] getColumn(int col) throws MatrixIndexException {
        MatrixUtils.checkColumnIndex(this, col);
        int nRows = this.getRowDimension();
        BigDecimal[] out = new BigDecimal[nRows];
        int i2 = 0;
        while (i2 < nRows) {
            out[i2] = this.data[i2][col];
            ++i2;
        }
        return out;
    }

    @Override
    public double[] getColumnAsDoubleArray(int col) throws MatrixIndexException {
        MatrixUtils.checkColumnIndex(this, col);
        int nrows = this.getRowDimension();
        double[] out = new double[nrows];
        int i2 = 0;
        while (i2 < nrows) {
            out[i2] = this.data[i2][col].doubleValue();
            ++i2;
        }
        return out;
    }

    @Override
    public BigDecimal getEntry(int row, int column) throws MatrixIndexException {
        try {
            return this.data[row][column];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MatrixIndexException(LocalizedFormats.NO_SUCH_MATRIX_ENTRY, row, column, this.getRowDimension(), this.getColumnDimension());
        }
    }

    @Override
    public double getEntryAsDouble(int row, int column) throws MatrixIndexException {
        return this.getEntry(row, column).doubleValue();
    }

    @Override
    public BigMatrix transpose() {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        BigDecimal[][] outData = new BigDecimal[nCols][nRows];
        int row = 0;
        while (row < nRows) {
            BigDecimal[] dataRow = this.data[row];
            int col = 0;
            while (col < nCols) {
                outData[col][row] = dataRow[col];
                ++col;
            }
            ++row;
        }
        return new BigMatrixImpl(outData, false);
    }

    @Override
    public BigMatrix inverse() throws InvalidMatrixException {
        return this.solve(MatrixUtils.createBigIdentityMatrix(this.getRowDimension()));
    }

    @Override
    public BigDecimal getDeterminant() throws InvalidMatrixException {
        if (!this.isSquare()) {
            throw new NonSquareMatrixException(this.getRowDimension(), this.getColumnDimension());
        }
        if (this.isSingular()) {
            return ZERO;
        }
        BigDecimal det = this.parity == 1 ? ONE : ONE.negate();
        int i2 = 0;
        while (i2 < this.getRowDimension()) {
            det = det.multiply(this.lu[i2][i2]);
            ++i2;
        }
        return det;
    }

    @Override
    public boolean isSquare() {
        return this.getColumnDimension() == this.getRowDimension();
    }

    public boolean isSingular() {
        if (this.lu == null) {
            try {
                this.luDecompose();
                return false;
            }
            catch (InvalidMatrixException ex) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getRowDimension() {
        return this.data.length;
    }

    @Override
    public int getColumnDimension() {
        return this.data[0].length;
    }

    @Override
    public BigDecimal getTrace() throws IllegalArgumentException {
        if (!this.isSquare()) {
            throw new NonSquareMatrixException(this.getRowDimension(), this.getColumnDimension());
        }
        BigDecimal trace = this.data[0][0];
        int i2 = 1;
        while (i2 < this.getRowDimension()) {
            trace = trace.add(this.data[i2][i2]);
            ++i2;
        }
        return trace;
    }

    @Override
    public BigDecimal[] operate(BigDecimal[] v) throws IllegalArgumentException {
        if (v.length != this.getColumnDimension()) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, v.length, this.getColumnDimension());
        }
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        BigDecimal[] out = new BigDecimal[nRows];
        int row = 0;
        while (row < nRows) {
            BigDecimal sum = ZERO;
            int i2 = 0;
            while (i2 < nCols) {
                sum = sum.add(this.data[row][i2].multiply(v[i2]));
                ++i2;
            }
            out[row] = sum;
            ++row;
        }
        return out;
    }

    public BigDecimal[] operate(double[] v) throws IllegalArgumentException {
        BigDecimal[] bd = new BigDecimal[v.length];
        int i2 = 0;
        while (i2 < bd.length) {
            bd[i2] = new BigDecimal(v[i2]);
            ++i2;
        }
        return this.operate(bd);
    }

    @Override
    public BigDecimal[] preMultiply(BigDecimal[] v) throws IllegalArgumentException {
        int nRows = this.getRowDimension();
        if (v.length != nRows) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, v.length, nRows);
        }
        int nCols = this.getColumnDimension();
        BigDecimal[] out = new BigDecimal[nCols];
        int col = 0;
        while (col < nCols) {
            BigDecimal sum = ZERO;
            int i2 = 0;
            while (i2 < nRows) {
                sum = sum.add(this.data[i2][col].multiply(v[i2]));
                ++i2;
            }
            out[col] = sum;
            ++col;
        }
        return out;
    }

    @Override
    public BigDecimal[] solve(BigDecimal[] b) throws IllegalArgumentException, InvalidMatrixException {
        int nRows = this.getRowDimension();
        if (b.length != nRows) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, b.length, nRows);
        }
        BigMatrixImpl bMatrix = new BigMatrixImpl(b);
        BigDecimal[][] solution = ((BigMatrixImpl)this.solve(bMatrix)).getDataRef();
        BigDecimal[] out = new BigDecimal[nRows];
        int row = 0;
        while (row < nRows) {
            out[row] = solution[row][0];
            ++row;
        }
        return out;
    }

    public BigDecimal[] solve(double[] b) throws IllegalArgumentException, InvalidMatrixException {
        BigDecimal[] bd = new BigDecimal[b.length];
        int i2 = 0;
        while (i2 < bd.length) {
            bd[i2] = new BigDecimal(b[i2]);
            ++i2;
        }
        return this.solve(bd);
    }

    @Override
    public BigMatrix solve(BigMatrix b) throws IllegalArgumentException, InvalidMatrixException {
        if (b.getRowDimension() != this.getRowDimension()) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_2x2, b.getRowDimension(), b.getColumnDimension(), this.getRowDimension(), "n");
        }
        if (!this.isSquare()) {
            throw new NonSquareMatrixException(this.getRowDimension(), this.getColumnDimension());
        }
        if (this.isSingular()) {
            throw new SingularMatrixException();
        }
        int nCol = this.getColumnDimension();
        int nColB = b.getColumnDimension();
        int nRowB = b.getRowDimension();
        BigDecimal[][] bp = new BigDecimal[nRowB][nColB];
        int row = 0;
        while (row < nRowB) {
            BigDecimal[] bpRow = bp[row];
            int col = 0;
            while (col < nColB) {
                bpRow[col] = b.getEntry(this.permutation[row], col);
                ++col;
            }
            ++row;
        }
        int col = 0;
        while (col < nCol) {
            int i2 = col + 1;
            while (i2 < nCol) {
                BigDecimal[] bpI = bp[i2];
                BigDecimal[] luI = this.lu[i2];
                int j = 0;
                while (j < nColB) {
                    bpI[j] = bpI[j].subtract(bp[col][j].multiply(luI[col]));
                    ++j;
                }
                ++i2;
            }
            ++col;
        }
        col = nCol - 1;
        while (col >= 0) {
            BigDecimal[] bpCol = bp[col];
            BigDecimal luDiag = this.lu[col][col];
            int j = 0;
            while (j < nColB) {
                bpCol[j] = bpCol[j].divide(luDiag, this.scale, this.roundingMode);
                ++j;
            }
            int i3 = 0;
            while (i3 < col) {
                BigDecimal[] bpI = bp[i3];
                BigDecimal[] luI = this.lu[i3];
                int j2 = 0;
                while (j2 < nColB) {
                    bpI[j2] = bpI[j2].subtract(bp[col][j2].multiply(luI[col]));
                    ++j2;
                }
                ++i3;
            }
            --col;
        }
        return new BigMatrixImpl(bp, false);
    }

    public void luDecompose() throws InvalidMatrixException {
        int nCols;
        int nRows = this.getRowDimension();
        if (nRows != (nCols = this.getColumnDimension())) {
            throw new NonSquareMatrixException(this.getRowDimension(), this.getColumnDimension());
        }
        this.lu = this.getData();
        this.permutation = new int[nRows];
        int row = 0;
        while (row < nRows) {
            this.permutation[row] = row;
            ++row;
        }
        this.parity = 1;
        int col = 0;
        while (col < nCols) {
            BigDecimal sum = ZERO;
            int row2 = 0;
            while (row2 < col) {
                BigDecimal[] luRow = this.lu[row2];
                sum = luRow[col];
                int i2 = 0;
                while (i2 < row2) {
                    sum = sum.subtract(luRow[i2].multiply(this.lu[i2][col]));
                    ++i2;
                }
                luRow[col] = sum;
                ++row2;
            }
            int max = col;
            BigDecimal largest = ZERO;
            int row3 = col;
            while (row3 < nRows) {
                BigDecimal[] luRow = this.lu[row3];
                sum = luRow[col];
                int i3 = 0;
                while (i3 < col) {
                    sum = sum.subtract(luRow[i3].multiply(this.lu[i3][col]));
                    ++i3;
                }
                luRow[col] = sum;
                if (sum.abs().compareTo(largest) == 1) {
                    largest = sum.abs();
                    max = row3;
                }
                ++row3;
            }
            if (this.lu[max][col].abs().compareTo(TOO_SMALL) <= 0) {
                this.lu = null;
                throw new SingularMatrixException();
            }
            if (max != col) {
                BigDecimal tmp = ZERO;
                int i4 = 0;
                while (i4 < nCols) {
                    tmp = this.lu[max][i4];
                    this.lu[max][i4] = this.lu[col][i4];
                    this.lu[col][i4] = tmp;
                    ++i4;
                }
                int temp = this.permutation[max];
                this.permutation[max] = this.permutation[col];
                this.permutation[col] = temp;
                this.parity = -this.parity;
            }
            BigDecimal luDiag = this.lu[col][col];
            int row4 = col + 1;
            while (row4 < nRows) {
                BigDecimal[] luRow = this.lu[row4];
                luRow[col] = luRow[col].divide(luDiag, this.scale, this.roundingMode);
                ++row4;
            }
            ++col;
        }
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append("BigMatrixImpl{");
        if (this.data != null) {
            int i2 = 0;
            while (i2 < this.data.length) {
                if (i2 > 0) {
                    res.append(",");
                }
                res.append("{");
                int j = 0;
                while (j < this.data[0].length) {
                    if (j > 0) {
                        res.append(",");
                    }
                    res.append(this.data[i2][j]);
                    ++j;
                }
                res.append("}");
                ++i2;
            }
        }
        res.append("}");
        return res.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BigMatrixImpl)) {
            return false;
        }
        BigMatrix m = (BigMatrix)object;
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (m.getColumnDimension() != nCols || m.getRowDimension() != nRows) {
            return false;
        }
        int row = 0;
        while (row < nRows) {
            BigDecimal[] dataRow = this.data[row];
            int col = 0;
            while (col < nCols) {
                if (!dataRow[col].equals(m.getEntry(row, col))) {
                    return false;
                }
                ++col;
            }
            ++row;
        }
        return true;
    }

    public int hashCode() {
        int ret = 7;
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        ret = ret * 31 + nRows;
        ret = ret * 31 + nCols;
        int row = 0;
        while (row < nRows) {
            BigDecimal[] dataRow = this.data[row];
            int col = 0;
            while (col < nCols) {
                ret = ret * 31 + (11 * (row + 1) + 17 * (col + 1)) * dataRow[col].hashCode();
                ++col;
            }
            ++row;
        }
        return ret;
    }

    protected BigMatrix getLUMatrix() throws InvalidMatrixException {
        if (this.lu == null) {
            this.luDecompose();
        }
        return new BigMatrixImpl(this.lu);
    }

    protected int[] getPermutation() {
        int[] out = new int[this.permutation.length];
        System.arraycopy(this.permutation, 0, out, 0, this.permutation.length);
        return out;
    }

    private BigDecimal[][] copyOut() {
        int nRows = this.getRowDimension();
        BigDecimal[][] out = new BigDecimal[nRows][this.getColumnDimension()];
        int i2 = 0;
        while (i2 < nRows) {
            System.arraycopy(this.data[i2], 0, out[i2], 0, this.data[i2].length);
            ++i2;
        }
        return out;
    }

    private void copyIn(BigDecimal[][] in) {
        this.setSubMatrix(in, 0, 0);
    }

    private void copyIn(double[][] in) {
        int nRows = in.length;
        int nCols = in[0].length;
        this.data = new BigDecimal[nRows][nCols];
        int i2 = 0;
        while (i2 < nRows) {
            BigDecimal[] dataI = this.data[i2];
            double[] inI = in[i2];
            int j = 0;
            while (j < nCols) {
                dataI[j] = new BigDecimal(inI[j]);
                ++j;
            }
            ++i2;
        }
        this.lu = null;
    }

    private void copyIn(String[][] in) {
        int nRows = in.length;
        int nCols = in[0].length;
        this.data = new BigDecimal[nRows][nCols];
        int i2 = 0;
        while (i2 < nRows) {
            BigDecimal[] dataI = this.data[i2];
            String[] inI = in[i2];
            int j = 0;
            while (j < nCols) {
                dataI[j] = new BigDecimal(inI[j]);
                ++j;
            }
            ++i2;
        }
        this.lu = null;
    }
}

