/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.linear.Array2DRowRealMatrix;
import org.apache.commons.math.linear.ArrayRealVector;
import org.apache.commons.math.linear.CholeskyDecomposition;
import org.apache.commons.math.linear.DecompositionSolver;
import org.apache.commons.math.linear.InvalidMatrixException;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.NonSquareMatrixException;
import org.apache.commons.math.linear.NotPositiveDefiniteMatrixException;
import org.apache.commons.math.linear.NotSymmetricMatrixException;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealVector;
import org.apache.commons.math.util.FastMath;

public class CholeskyDecompositionImpl
implements CholeskyDecomposition {
    public static final double DEFAULT_RELATIVE_SYMMETRY_THRESHOLD = 1.0E-15;
    public static final double DEFAULT_ABSOLUTE_POSITIVITY_THRESHOLD = 1.0E-10;
    private double[][] lTData;
    private RealMatrix cachedL;
    private RealMatrix cachedLT;

    public CholeskyDecompositionImpl(RealMatrix matrix) throws NonSquareMatrixException, NotSymmetricMatrixException, NotPositiveDefiniteMatrixException {
        this(matrix, 1.0E-15, 1.0E-10);
    }

    public CholeskyDecompositionImpl(RealMatrix matrix, double relativeSymmetryThreshold, double absolutePositivityThreshold) throws NonSquareMatrixException, NotSymmetricMatrixException, NotPositiveDefiniteMatrixException {
        if (!matrix.isSquare()) {
            throw new NonSquareMatrixException(matrix.getRowDimension(), matrix.getColumnDimension());
        }
        int order = matrix.getRowDimension();
        this.lTData = matrix.getData();
        this.cachedL = null;
        this.cachedLT = null;
        int i2 = 0;
        while (i2 < order) {
            double[] lI = this.lTData[i2];
            int j = i2 + 1;
            while (j < order) {
                double[] lJ = this.lTData[j];
                double lIJ = lI[j];
                double lJI = lJ[i2];
                double maxDelta = relativeSymmetryThreshold * FastMath.max(FastMath.abs(lIJ), FastMath.abs(lJI));
                if (FastMath.abs(lIJ - lJI) > maxDelta) {
                    throw new NotSymmetricMatrixException();
                }
                lJ[i2] = 0.0;
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < order) {
            double[] ltI = this.lTData[i2];
            if (ltI[i2] < absolutePositivityThreshold) {
                throw new NotPositiveDefiniteMatrixException();
            }
            ltI[i2] = FastMath.sqrt(ltI[i2]);
            double inverse = 1.0 / ltI[i2];
            int q = order - 1;
            while (q > i2) {
                int n = q;
                ltI[n] = ltI[n] * inverse;
                double[] ltQ = this.lTData[q];
                int p = q;
                while (p < order) {
                    int n2 = p;
                    ltQ[n2] = ltQ[n2] - ltI[q] * ltI[p];
                    ++p;
                }
                --q;
            }
            ++i2;
        }
    }

    @Override
    public RealMatrix getL() {
        if (this.cachedL == null) {
            this.cachedL = this.getLT().transpose();
        }
        return this.cachedL;
    }

    @Override
    public RealMatrix getLT() {
        if (this.cachedLT == null) {
            this.cachedLT = MatrixUtils.createRealMatrix(this.lTData);
        }
        return this.cachedLT;
    }

    @Override
    public double getDeterminant() {
        double determinant = 1.0;
        int i2 = 0;
        while (i2 < this.lTData.length) {
            double lTii = this.lTData[i2][i2];
            determinant *= lTii * lTii;
            ++i2;
        }
        return determinant;
    }

    @Override
    public DecompositionSolver getSolver() {
        return new Solver(this.lTData);
    }

    private static class Solver
    implements DecompositionSolver {
        private final double[][] lTData;

        private Solver(double[][] lTData) {
            this.lTData = lTData;
        }

        @Override
        public boolean isNonSingular() {
            return true;
        }

        @Override
        public double[] solve(double[] b) throws IllegalArgumentException, InvalidMatrixException {
            int m = this.lTData.length;
            if (b.length != m) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, b.length, m);
            }
            double[] x = (double[])b.clone();
            int j = 0;
            while (j < m) {
                double[] lJ = this.lTData[j];
                int n = j;
                x[n] = x[n] / lJ[j];
                double xJ = x[j];
                int i2 = j + 1;
                while (i2 < m) {
                    int n2 = i2;
                    x[n2] = x[n2] - xJ * lJ[i2];
                    ++i2;
                }
                ++j;
            }
            j = m - 1;
            while (j >= 0) {
                int n = j;
                x[n] = x[n] / this.lTData[j][j];
                double xJ = x[j];
                int i3 = 0;
                while (i3 < j) {
                    int n3 = i3;
                    x[n3] = x[n3] - xJ * this.lTData[i3][j];
                    ++i3;
                }
                --j;
            }
            return x;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public RealVector solve(RealVector b) throws IllegalArgumentException, InvalidMatrixException {
            try {
                return this.solve((ArrayRealVector)b);
            }
            catch (ClassCastException cce) {
                m = this.lTData.length;
                if (b.getDimension() != m) {
                    throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, new Object[]{b.getDimension(), m});
                }
                x = b.getData();
                j = 0;
                ** while (j < m)
            }
lbl-1000:
            // 1 sources

            {
                lJ = this.lTData[j];
                v0 = j;
                x[v0] = x[v0] / lJ[j];
                xJ = x[j];
                i = j + 1;
                while (i < m) {
                    v1 = i;
                    x[v1] = x[v1] - xJ * lJ[i];
                    ++i;
                }
                ++j;
                continue;
            }
lbl22:
            // 1 sources

            j = m - 1;
            while (j >= 0) {
                v2 = j;
                x[v2] = x[v2] / this.lTData[j][j];
                xJ = x[j];
                i = 0;
                while (i < j) {
                    v3 = i;
                    x[v3] = x[v3] - xJ * this.lTData[i][j];
                    ++i;
                }
                --j;
            }
            return new ArrayRealVector(x, false);
        }

        public ArrayRealVector solve(ArrayRealVector b) throws IllegalArgumentException, InvalidMatrixException {
            return new ArrayRealVector(this.solve(b.getDataRef()), false);
        }

        @Override
        public RealMatrix solve(RealMatrix b) throws IllegalArgumentException, InvalidMatrixException {
            int m = this.lTData.length;
            if (b.getRowDimension() != m) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_2x2, b.getRowDimension(), b.getColumnDimension(), m, "n");
            }
            int nColB = b.getColumnDimension();
            double[][] x = b.getData();
            int j = 0;
            while (j < m) {
                double[] lJ = this.lTData[j];
                double lJJ = lJ[j];
                double[] xJ = x[j];
                int k = 0;
                while (k < nColB) {
                    int n = k++;
                    xJ[n] = xJ[n] / lJJ;
                }
                int i2 = j + 1;
                while (i2 < m) {
                    double[] xI = x[i2];
                    double lJI = lJ[i2];
                    int k2 = 0;
                    while (k2 < nColB) {
                        int n = k2;
                        xI[n] = xI[n] - xJ[k2] * lJI;
                        ++k2;
                    }
                    ++i2;
                }
                ++j;
            }
            j = m - 1;
            while (j >= 0) {
                double lJJ = this.lTData[j][j];
                double[] xJ = x[j];
                int k = 0;
                while (k < nColB) {
                    int n = k++;
                    xJ[n] = xJ[n] / lJJ;
                }
                int i3 = 0;
                while (i3 < j) {
                    double[] xI = x[i3];
                    double lIJ = this.lTData[i3][j];
                    int k3 = 0;
                    while (k3 < nColB) {
                        int n = k3;
                        xI[n] = xI[n] - xJ[k3] * lIJ;
                        ++k3;
                    }
                    ++i3;
                }
                --j;
            }
            return new Array2DRowRealMatrix(x, false);
        }

        @Override
        public RealMatrix getInverse() throws InvalidMatrixException {
            return this.solve(MatrixUtils.createRealIdentityMatrix(this.lTData.length));
        }
    }
}

