/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.linear.ArrayRealVector;
import org.apache.commons.math.linear.DecompositionSolver;
import org.apache.commons.math.linear.EigenDecomposition;
import org.apache.commons.math.linear.InvalidMatrixException;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealVector;
import org.apache.commons.math.linear.SingularMatrixException;
import org.apache.commons.math.linear.TriDiagonalTransformer;
import org.apache.commons.math.util.FastMath;

public class EigenDecompositionImpl
implements EigenDecomposition {
    private byte maxIter = (byte)30;
    private double[] main;
    private double[] secondary;
    private TriDiagonalTransformer transformer;
    private double[] realEigenvalues;
    private double[] imagEigenvalues;
    private ArrayRealVector[] eigenvectors;
    private RealMatrix cachedV;
    private RealMatrix cachedD;
    private RealMatrix cachedVt;

    public EigenDecompositionImpl(RealMatrix matrix, double splitTolerance) throws InvalidMatrixException {
        if (!this.isSymmetric(matrix)) {
            throw new InvalidMatrixException(LocalizedFormats.ASSYMETRIC_EIGEN_NOT_SUPPORTED, new Object[0]);
        }
        this.transformToTridiagonal(matrix);
        this.findEigenVectors(this.transformer.getQ().getData());
    }

    public EigenDecompositionImpl(double[] main, double[] secondary, double splitTolerance) throws InvalidMatrixException {
        this.main = (double[])main.clone();
        this.secondary = (double[])secondary.clone();
        this.transformer = null;
        int size = main.length;
        double[][] z = new double[size][size];
        int i2 = 0;
        while (i2 < size) {
            z[i2][i2] = 1.0;
            ++i2;
        }
        this.findEigenVectors(z);
    }

    private boolean isSymmetric(RealMatrix matrix) {
        int rows = matrix.getRowDimension();
        int columns = matrix.getColumnDimension();
        double eps = (double)(10 * rows * columns) * (double)1.110223E-16f;
        int i2 = 0;
        while (i2 < rows) {
            int j = i2 + 1;
            while (j < columns) {
                double mji;
                double mij = matrix.getEntry(i2, j);
                if (FastMath.abs(mij - (mji = matrix.getEntry(j, i2))) > FastMath.max(FastMath.abs(mij), FastMath.abs(mji)) * eps) {
                    return false;
                }
                ++j;
            }
            ++i2;
        }
        return true;
    }

    @Override
    public RealMatrix getV() throws InvalidMatrixException {
        if (this.cachedV == null) {
            int m = this.eigenvectors.length;
            this.cachedV = MatrixUtils.createRealMatrix(m, m);
            int k = 0;
            while (k < m) {
                this.cachedV.setColumnVector(k, this.eigenvectors[k]);
                ++k;
            }
        }
        return this.cachedV;
    }

    @Override
    public RealMatrix getD() throws InvalidMatrixException {
        if (this.cachedD == null) {
            this.cachedD = MatrixUtils.createRealDiagonalMatrix(this.realEigenvalues);
        }
        return this.cachedD;
    }

    @Override
    public RealMatrix getVT() throws InvalidMatrixException {
        if (this.cachedVt == null) {
            int m = this.eigenvectors.length;
            this.cachedVt = MatrixUtils.createRealMatrix(m, m);
            int k = 0;
            while (k < m) {
                this.cachedVt.setRowVector(k, this.eigenvectors[k]);
                ++k;
            }
        }
        return this.cachedVt;
    }

    @Override
    public double[] getRealEigenvalues() throws InvalidMatrixException {
        return (double[])this.realEigenvalues.clone();
    }

    @Override
    public double getRealEigenvalue(int i2) throws InvalidMatrixException, ArrayIndexOutOfBoundsException {
        return this.realEigenvalues[i2];
    }

    @Override
    public double[] getImagEigenvalues() throws InvalidMatrixException {
        return (double[])this.imagEigenvalues.clone();
    }

    @Override
    public double getImagEigenvalue(int i2) throws InvalidMatrixException, ArrayIndexOutOfBoundsException {
        return this.imagEigenvalues[i2];
    }

    @Override
    public RealVector getEigenvector(int i2) throws InvalidMatrixException, ArrayIndexOutOfBoundsException {
        return this.eigenvectors[i2].copy();
    }

    @Override
    public double getDeterminant() {
        double determinant = 1.0;
        double[] dArray = this.realEigenvalues;
        int n = this.realEigenvalues.length;
        int n2 = 0;
        while (n2 < n) {
            double lambda = dArray[n2];
            determinant *= lambda;
            ++n2;
        }
        return determinant;
    }

    @Override
    public DecompositionSolver getSolver() {
        return new Solver(this.realEigenvalues, this.imagEigenvalues, this.eigenvectors);
    }

    private void transformToTridiagonal(RealMatrix matrix) {
        this.transformer = new TriDiagonalTransformer(matrix);
        this.main = this.transformer.getMainDiagonalRef();
        this.secondary = this.transformer.getSecondaryDiagonalRef();
    }

    private void findEigenVectors(double[][] householderMatrix) {
        double[][] z = (double[][])householderMatrix.clone();
        int n = this.main.length;
        this.realEigenvalues = new double[n];
        this.imagEigenvalues = new double[n];
        double[] e = new double[n];
        int i2 = 0;
        while (i2 < n - 1) {
            this.realEigenvalues[i2] = this.main[i2];
            e[i2] = this.secondary[i2];
            ++i2;
        }
        this.realEigenvalues[n - 1] = this.main[n - 1];
        e[n - 1] = 0.0;
        double maxAbsoluteValue = 0.0;
        int i3 = 0;
        while (i3 < n) {
            if (FastMath.abs(this.realEigenvalues[i3]) > maxAbsoluteValue) {
                maxAbsoluteValue = FastMath.abs(this.realEigenvalues[i3]);
            }
            if (FastMath.abs(e[i3]) > maxAbsoluteValue) {
                maxAbsoluteValue = FastMath.abs(e[i3]);
            }
            ++i3;
        }
        if (maxAbsoluteValue != 0.0) {
            i3 = 0;
            while (i3 < n) {
                if (FastMath.abs(this.realEigenvalues[i3]) <= (double)1.110223E-16f * maxAbsoluteValue) {
                    this.realEigenvalues[i3] = 0.0;
                }
                if (FastMath.abs(e[i3]) <= (double)1.110223E-16f * maxAbsoluteValue) {
                    e[i3] = 0.0;
                }
                ++i3;
            }
        }
        int j = 0;
        while (j < n) {
            int m;
            int its = 0;
            do {
                m = j;
                while (m < n - 1) {
                    double delta = FastMath.abs(this.realEigenvalues[m]) + FastMath.abs(this.realEigenvalues[m + 1]);
                    if (FastMath.abs(e[m]) + delta == delta) break;
                    ++m;
                }
                if (m == j) continue;
                if (its == this.maxIter) {
                    throw new InvalidMatrixException(new MaxIterationsExceededException(this.maxIter));
                }
                ++its;
                double q = (this.realEigenvalues[j + 1] - this.realEigenvalues[j]) / (2.0 * e[j]);
                double t = FastMath.sqrt(1.0 + q * q);
                q = q < 0.0 ? this.realEigenvalues[m] - this.realEigenvalues[j] + e[j] / (q - t) : this.realEigenvalues[m] - this.realEigenvalues[j] + e[j] / (q + t);
                double u = 0.0;
                double s = 1.0;
                double c = 1.0;
                int i4 = m - 1;
                while (i4 >= j) {
                    double p = s * e[i4];
                    double h = c * e[i4];
                    if (FastMath.abs(p) >= FastMath.abs(q)) {
                        c = q / p;
                        t = FastMath.sqrt(c * c + 1.0);
                        e[i4 + 1] = p * t;
                        s = 1.0 / t;
                        c *= s;
                    } else {
                        s = p / q;
                        t = FastMath.sqrt(s * s + 1.0);
                        e[i4 + 1] = q * t;
                        c = 1.0 / t;
                        s *= c;
                    }
                    if (e[i4 + 1] == 0.0) {
                        int n2 = i4 + 1;
                        this.realEigenvalues[n2] = this.realEigenvalues[n2] - u;
                        e[m] = 0.0;
                        break;
                    }
                    q = this.realEigenvalues[i4 + 1] - u;
                    t = (this.realEigenvalues[i4] - q) * s + 2.0 * c * h;
                    u = s * t;
                    this.realEigenvalues[i4 + 1] = q + u;
                    q = c * t - h;
                    int ia = 0;
                    while (ia < n) {
                        p = z[ia][i4 + 1];
                        z[ia][i4 + 1] = s * z[ia][i4] + c * p;
                        z[ia][i4] = c * z[ia][i4] - s * p;
                        ++ia;
                    }
                    --i4;
                }
                if (t == 0.0 && i4 >= j) continue;
                int n3 = j;
                this.realEigenvalues[n3] = this.realEigenvalues[n3] - u;
                e[j] = q;
                e[m] = 0.0;
            } while (m != j);
            ++j;
        }
        i3 = 0;
        while (i3 < n) {
            int k = i3;
            double p = this.realEigenvalues[i3];
            int j2 = i3 + 1;
            while (j2 < n) {
                if (this.realEigenvalues[j2] > p) {
                    k = j2;
                    p = this.realEigenvalues[j2];
                }
                ++j2;
            }
            if (k != i3) {
                this.realEigenvalues[k] = this.realEigenvalues[i3];
                this.realEigenvalues[i3] = p;
                j2 = 0;
                while (j2 < n) {
                    p = z[j2][i3];
                    z[j2][i3] = z[j2][k];
                    z[j2][k] = p;
                    ++j2;
                }
            }
            ++i3;
        }
        maxAbsoluteValue = 0.0;
        i3 = 0;
        while (i3 < n) {
            if (FastMath.abs(this.realEigenvalues[i3]) > maxAbsoluteValue) {
                maxAbsoluteValue = FastMath.abs(this.realEigenvalues[i3]);
            }
            ++i3;
        }
        if (maxAbsoluteValue != 0.0) {
            i3 = 0;
            while (i3 < n) {
                if (FastMath.abs(this.realEigenvalues[i3]) < (double)1.110223E-16f * maxAbsoluteValue) {
                    this.realEigenvalues[i3] = 0.0;
                }
                ++i3;
            }
        }
        this.eigenvectors = new ArrayRealVector[n];
        double[] tmp = new double[n];
        int i5 = 0;
        while (i5 < n) {
            int j3 = 0;
            while (j3 < n) {
                tmp[j3] = z[j3][i5];
                ++j3;
            }
            this.eigenvectors[i5] = new ArrayRealVector(tmp);
            ++i5;
        }
    }

    private static class Solver
    implements DecompositionSolver {
        private double[] realEigenvalues;
        private double[] imagEigenvalues;
        private final ArrayRealVector[] eigenvectors;

        private Solver(double[] realEigenvalues, double[] imagEigenvalues, ArrayRealVector[] eigenvectors) {
            this.realEigenvalues = realEigenvalues;
            this.imagEigenvalues = imagEigenvalues;
            this.eigenvectors = eigenvectors;
        }

        @Override
        public double[] solve(double[] b) throws IllegalArgumentException, InvalidMatrixException {
            if (!this.isNonSingular()) {
                throw new SingularMatrixException();
            }
            int m = this.realEigenvalues.length;
            if (b.length != m) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, b.length, m);
            }
            double[] bp = new double[m];
            int i2 = 0;
            while (i2 < m) {
                ArrayRealVector v = this.eigenvectors[i2];
                double[] vData = v.getDataRef();
                double s = v.dotProduct(b) / this.realEigenvalues[i2];
                int j = 0;
                while (j < m) {
                    int n = j;
                    bp[n] = bp[n] + s * vData[j];
                    ++j;
                }
                ++i2;
            }
            return bp;
        }

        @Override
        public RealVector solve(RealVector b) throws IllegalArgumentException, InvalidMatrixException {
            if (!this.isNonSingular()) {
                throw new SingularMatrixException();
            }
            int m = this.realEigenvalues.length;
            if (b.getDimension() != m) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, b.getDimension(), m);
            }
            double[] bp = new double[m];
            int i2 = 0;
            while (i2 < m) {
                ArrayRealVector v = this.eigenvectors[i2];
                double[] vData = v.getDataRef();
                double s = v.dotProduct(b) / this.realEigenvalues[i2];
                int j = 0;
                while (j < m) {
                    int n = j;
                    bp[n] = bp[n] + s * vData[j];
                    ++j;
                }
                ++i2;
            }
            return new ArrayRealVector(bp, false);
        }

        @Override
        public RealMatrix solve(RealMatrix b) throws IllegalArgumentException, InvalidMatrixException {
            if (!this.isNonSingular()) {
                throw new SingularMatrixException();
            }
            int m = this.realEigenvalues.length;
            if (b.getRowDimension() != m) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_2x2, b.getRowDimension(), b.getColumnDimension(), m, "n");
            }
            int nColB = b.getColumnDimension();
            double[][] bp = new double[m][nColB];
            int k = 0;
            while (k < nColB) {
                int i2 = 0;
                while (i2 < m) {
                    ArrayRealVector v = this.eigenvectors[i2];
                    double[] vData = v.getDataRef();
                    double s = 0.0;
                    int j = 0;
                    while (j < m) {
                        s += v.getEntry(j) * b.getEntry(j, k);
                        ++j;
                    }
                    s /= this.realEigenvalues[i2];
                    j = 0;
                    while (j < m) {
                        double[] dArray = bp[j];
                        int n = k;
                        dArray[n] = dArray[n] + s * vData[j];
                        ++j;
                    }
                    ++i2;
                }
                ++k;
            }
            return MatrixUtils.createRealMatrix(bp);
        }

        @Override
        public boolean isNonSingular() {
            int i2 = 0;
            while (i2 < this.realEigenvalues.length) {
                if (this.realEigenvalues[i2] == 0.0 && this.imagEigenvalues[i2] == 0.0) {
                    return false;
                }
                ++i2;
            }
            return true;
        }

        @Override
        public RealMatrix getInverse() throws InvalidMatrixException {
            if (!this.isNonSingular()) {
                throw new SingularMatrixException();
            }
            int m = this.realEigenvalues.length;
            double[][] invData = new double[m][m];
            int i2 = 0;
            while (i2 < m) {
                double[] invI = invData[i2];
                int j = 0;
                while (j < m) {
                    double invIJ = 0.0;
                    int k = 0;
                    while (k < m) {
                        double[] vK = this.eigenvectors[k].getDataRef();
                        invIJ += vK[i2] * vK[j] / this.realEigenvalues[k];
                        ++k;
                    }
                    invI[j] = invIJ;
                    ++j;
                }
                ++i2;
            }
            return MatrixUtils.createRealMatrix(invData);
        }
    }
}

