/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import java.lang.reflect.Array;
import org.apache.commons.math.Field;
import org.apache.commons.math.FieldElement;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.linear.Array2DRowFieldMatrix;
import org.apache.commons.math.linear.ArrayFieldVector;
import org.apache.commons.math.linear.FieldDecompositionSolver;
import org.apache.commons.math.linear.FieldLUDecomposition;
import org.apache.commons.math.linear.FieldMatrix;
import org.apache.commons.math.linear.FieldVector;
import org.apache.commons.math.linear.InvalidMatrixException;
import org.apache.commons.math.linear.NonSquareMatrixException;
import org.apache.commons.math.linear.SingularMatrixException;

public class FieldLUDecompositionImpl<T extends FieldElement<T>>
implements FieldLUDecomposition<T> {
    private final Field<T> field;
    private T[][] lu;
    private int[] pivot;
    private boolean even;
    private boolean singular;
    private FieldMatrix<T> cachedL;
    private FieldMatrix<T> cachedU;
    private FieldMatrix<T> cachedP;

    public FieldLUDecompositionImpl(FieldMatrix<T> matrix) throws NonSquareMatrixException {
        if (!matrix.isSquare()) {
            throw new NonSquareMatrixException(matrix.getRowDimension(), matrix.getColumnDimension());
        }
        int m = matrix.getColumnDimension();
        this.field = matrix.getField();
        this.lu = matrix.getData();
        this.pivot = new int[m];
        this.cachedL = null;
        this.cachedU = null;
        this.cachedP = null;
        int row = 0;
        while (row < m) {
            this.pivot[row] = row;
            ++row;
        }
        this.even = true;
        this.singular = false;
        int col = 0;
        while (col < m) {
            FieldElement<FieldElement> sum = (FieldElement)this.field.getZero();
            int row2 = 0;
            while (row2 < col) {
                T[] luRow = this.lu[row2];
                sum = luRow[col];
                int i2 = 0;
                while (i2 < row2) {
                    sum = sum.subtract((FieldElement)luRow[i2].multiply(this.lu[i2][col]));
                    ++i2;
                }
                luRow[col] = sum;
                ++row2;
            }
            int nonZero = col;
            int row3 = col;
            while (row3 < m) {
                T[] luRow = this.lu[row3];
                sum = luRow[col];
                int i3 = 0;
                while (i3 < col) {
                    sum = sum.subtract((FieldElement)luRow[i3].multiply(this.lu[i3][col]));
                    ++i3;
                }
                luRow[col] = sum;
                if (this.lu[nonZero][col].equals(this.field.getZero())) {
                    ++nonZero;
                }
                ++row3;
            }
            if (nonZero >= m) {
                this.singular = true;
                return;
            }
            if (nonZero != col) {
                FieldElement tmp = (FieldElement)this.field.getZero();
                int i4 = 0;
                while (i4 < m) {
                    tmp = this.lu[nonZero][i4];
                    this.lu[nonZero][i4] = this.lu[col][i4];
                    this.lu[col][i4] = tmp;
                    ++i4;
                }
                int temp = this.pivot[nonZero];
                this.pivot[nonZero] = this.pivot[col];
                this.pivot[col] = temp;
                this.even = !this.even;
            }
            T luDiag = this.lu[col][col];
            int row4 = col + 1;
            while (row4 < m) {
                T[] luRow = this.lu[row4];
                luRow[col] = (FieldElement)luRow[col].divide(luDiag);
                ++row4;
            }
            ++col;
        }
    }

    @Override
    public FieldMatrix<T> getL() {
        if (this.cachedL == null && !this.singular) {
            int m = this.pivot.length;
            this.cachedL = new Array2DRowFieldMatrix<T>(this.field, m, m);
            int i2 = 0;
            while (i2 < m) {
                T[] luI = this.lu[i2];
                int j = 0;
                while (j < i2) {
                    this.cachedL.setEntry(i2, j, luI[j]);
                    ++j;
                }
                this.cachedL.setEntry(i2, i2, (FieldElement)this.field.getOne());
                ++i2;
            }
        }
        return this.cachedL;
    }

    @Override
    public FieldMatrix<T> getU() {
        if (this.cachedU == null && !this.singular) {
            int m = this.pivot.length;
            this.cachedU = new Array2DRowFieldMatrix<T>(this.field, m, m);
            int i2 = 0;
            while (i2 < m) {
                T[] luI = this.lu[i2];
                int j = i2;
                while (j < m) {
                    this.cachedU.setEntry(i2, j, luI[j]);
                    ++j;
                }
                ++i2;
            }
        }
        return this.cachedU;
    }

    @Override
    public FieldMatrix<T> getP() {
        if (this.cachedP == null && !this.singular) {
            int m = this.pivot.length;
            this.cachedP = new Array2DRowFieldMatrix<T>(this.field, m, m);
            int i2 = 0;
            while (i2 < m) {
                this.cachedP.setEntry(i2, this.pivot[i2], (FieldElement)this.field.getOne());
                ++i2;
            }
        }
        return this.cachedP;
    }

    @Override
    public int[] getPivot() {
        return (int[])this.pivot.clone();
    }

    @Override
    public T getDeterminant() {
        if (this.singular) {
            return (T)((FieldElement)this.field.getZero());
        }
        int m = this.pivot.length;
        FieldElement determinant = this.even ? (FieldElement)this.field.getOne() : ((FieldElement)this.field.getZero()).subtract((FieldElement)this.field.getOne());
        int i2 = 0;
        while (i2 < m) {
            determinant = (FieldElement)determinant.multiply(this.lu[i2][i2]);
            ++i2;
        }
        return (T)determinant;
    }

    @Override
    public FieldDecompositionSolver<T> getSolver() {
        return new Solver(this.field, (FieldElement[][])this.lu, this.pivot, this.singular);
    }

    private static class Solver<T extends FieldElement<T>>
    implements FieldDecompositionSolver<T> {
        private static final long serialVersionUID = -6353105415121373022L;
        private final Field<T> field;
        private final T[][] lu;
        private final int[] pivot;
        private final boolean singular;

        private Solver(Field<T> field, T[][] lu, int[] pivot, boolean singular) {
            this.field = field;
            this.lu = lu;
            this.pivot = pivot;
            this.singular = singular;
        }

        @Override
        public boolean isNonSingular() {
            return !this.singular;
        }

        @Override
        public T[] solve(T[] b) throws IllegalArgumentException, InvalidMatrixException {
            int i2;
            FieldElement bpCol;
            int m = this.pivot.length;
            if (b.length != m) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, b.length, m);
            }
            if (this.singular) {
                throw new SingularMatrixException();
            }
            FieldElement[] bp = (FieldElement[])Array.newInstance(((FieldElement)this.field.getZero()).getClass(), m);
            int row = 0;
            while (row < m) {
                bp[row] = b[this.pivot[row]];
                ++row;
            }
            int col = 0;
            while (col < m) {
                bpCol = bp[col];
                i2 = col + 1;
                while (i2 < m) {
                    bp[i2] = bp[i2].subtract((FieldElement)bpCol.multiply(this.lu[i2][col]));
                    ++i2;
                }
                ++col;
            }
            col = m - 1;
            while (col >= 0) {
                bp[col] = (FieldElement)bp[col].divide(this.lu[col][col]);
                bpCol = bp[col];
                i2 = 0;
                while (i2 < col) {
                    bp[i2] = bp[i2].subtract((FieldElement)bpCol.multiply(this.lu[i2][col]));
                    ++i2;
                }
                --col;
            }
            return bp;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public FieldVector<T> solve(FieldVector<T> b) throws IllegalArgumentException, InvalidMatrixException {
            try {
                return this.solve((ArrayFieldVector)b);
            }
            catch (ClassCastException cce) {
                m = this.pivot.length;
                if (b.getDimension() != m) {
                    throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, new Object[]{b.getDimension(), m});
                }
                if (this.singular) {
                    throw new SingularMatrixException();
                }
                bp = (FieldElement[])Array.newInstance(((FieldElement)this.field.getZero()).getClass(), m);
                row = 0;
                ** while (row < m)
            }
lbl-1000:
            // 1 sources

            {
                bp[row] = b.getEntry(this.pivot[row]);
                ++row;
                continue;
            }
lbl15:
            // 1 sources

            col = 0;
            while (col < m) {
                bpCol = bp[col];
                i = col + 1;
                while (i < m) {
                    bp[i] = bp[i].subtract((FieldElement)bpCol.multiply(this.lu[i][col]));
                    ++i;
                }
                ++col;
            }
            col = m - 1;
            while (col >= 0) {
                bp[col] = (FieldElement)bp[col].divide(this.lu[col][col]);
                bpCol = bp[col];
                i = 0;
                while (i < col) {
                    bp[i] = bp[i].subtract((FieldElement)bpCol.multiply(this.lu[i][col]));
                    ++i;
                }
                --col;
            }
            return new ArrayFieldVector(bp, false);
        }

        @Override
        public ArrayFieldVector<T> solve(ArrayFieldVector<T> b) throws IllegalArgumentException, InvalidMatrixException {
            return new ArrayFieldVector(this.solve(b.getDataRef()), false);
        }

        @Override
        public FieldMatrix<T> solve(FieldMatrix<T> b) throws IllegalArgumentException, InvalidMatrixException {
            FieldElement[] bpCol;
            int m = this.pivot.length;
            if (b.getRowDimension() != m) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_2x2, b.getRowDimension(), b.getColumnDimension(), m, "n");
            }
            if (this.singular) {
                throw new SingularMatrixException();
            }
            int nColB = b.getColumnDimension();
            FieldElement[][] bp = (FieldElement[][])Array.newInstance(((FieldElement)this.field.getZero()).getClass(), m, nColB);
            int row = 0;
            while (row < m) {
                FieldElement[] bpRow = bp[row];
                int pRow = this.pivot[row];
                int col = 0;
                while (col < nColB) {
                    bpRow[col] = b.getEntry(pRow, col);
                    ++col;
                }
                ++row;
            }
            int col = 0;
            while (col < m) {
                bpCol = bp[col];
                int i2 = col + 1;
                while (i2 < m) {
                    FieldElement[] bpI = bp[i2];
                    T luICol = this.lu[i2][col];
                    int j = 0;
                    while (j < nColB) {
                        bpI[j] = bpI[j].subtract((FieldElement)bpCol[j].multiply(luICol));
                        ++j;
                    }
                    ++i2;
                }
                ++col;
            }
            col = m - 1;
            while (col >= 0) {
                bpCol = bp[col];
                T luDiag = this.lu[col][col];
                int j = 0;
                while (j < nColB) {
                    bpCol[j] = (FieldElement)bpCol[j].divide(luDiag);
                    ++j;
                }
                int i3 = 0;
                while (i3 < col) {
                    FieldElement[] bpI = bp[i3];
                    T luICol = this.lu[i3][col];
                    int j2 = 0;
                    while (j2 < nColB) {
                        bpI[j2] = bpI[j2].subtract((FieldElement)bpCol[j2].multiply(luICol));
                        ++j2;
                    }
                    ++i3;
                }
                --col;
            }
            return new Array2DRowFieldMatrix(bp, false);
        }

        @Override
        public FieldMatrix<T> getInverse() throws InvalidMatrixException {
            int m = this.pivot.length;
            FieldElement one = (FieldElement)this.field.getOne();
            Array2DRowFieldMatrix<FieldElement> identity = new Array2DRowFieldMatrix<FieldElement>(this.field, m, m);
            int i2 = 0;
            while (i2 < m) {
                identity.setEntry(i2, i2, one);
                ++i2;
            }
            return this.solve(identity);
        }
    }
}

