/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.linear.Array2DRowRealMatrix;
import org.apache.commons.math.linear.ArrayRealVector;
import org.apache.commons.math.linear.DecompositionSolver;
import org.apache.commons.math.linear.InvalidMatrixException;
import org.apache.commons.math.linear.LUDecomposition;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.NonSquareMatrixException;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealVector;
import org.apache.commons.math.linear.SingularMatrixException;
import org.apache.commons.math.util.FastMath;

public class LUDecompositionImpl
implements LUDecomposition {
    private static final double DEFAULT_TOO_SMALL = 1.0E-11;
    private double[][] lu;
    private int[] pivot;
    private boolean even;
    private boolean singular;
    private RealMatrix cachedL;
    private RealMatrix cachedU;
    private RealMatrix cachedP;

    public LUDecompositionImpl(RealMatrix matrix) throws InvalidMatrixException {
        this(matrix, 1.0E-11);
    }

    public LUDecompositionImpl(RealMatrix matrix, double singularityThreshold) throws NonSquareMatrixException {
        if (!matrix.isSquare()) {
            throw new NonSquareMatrixException(matrix.getRowDimension(), matrix.getColumnDimension());
        }
        int m = matrix.getColumnDimension();
        this.lu = matrix.getData();
        this.pivot = new int[m];
        this.cachedL = null;
        this.cachedU = null;
        this.cachedP = null;
        int row = 0;
        while (row < m) {
            this.pivot[row] = row;
            ++row;
        }
        this.even = true;
        this.singular = false;
        int col = 0;
        while (col < m) {
            double sum = 0.0;
            int row2 = 0;
            while (row2 < col) {
                double[] luRow = this.lu[row2];
                sum = luRow[col];
                int i2 = 0;
                while (i2 < row2) {
                    sum -= luRow[i2] * this.lu[i2][col];
                    ++i2;
                }
                luRow[col] = sum;
                ++row2;
            }
            int max = col;
            double largest = Double.NEGATIVE_INFINITY;
            int row3 = col;
            while (row3 < m) {
                double[] luRow = this.lu[row3];
                sum = luRow[col];
                int i3 = 0;
                while (i3 < col) {
                    sum -= luRow[i3] * this.lu[i3][col];
                    ++i3;
                }
                luRow[col] = sum;
                if (FastMath.abs(sum) > largest) {
                    largest = FastMath.abs(sum);
                    max = row3;
                }
                ++row3;
            }
            if (FastMath.abs(this.lu[max][col]) < singularityThreshold) {
                this.singular = true;
                return;
            }
            if (max != col) {
                double tmp = 0.0;
                double[] luMax = this.lu[max];
                double[] luCol = this.lu[col];
                int i4 = 0;
                while (i4 < m) {
                    tmp = luMax[i4];
                    luMax[i4] = luCol[i4];
                    luCol[i4] = tmp;
                    ++i4;
                }
                int temp = this.pivot[max];
                this.pivot[max] = this.pivot[col];
                this.pivot[col] = temp;
                this.even = !this.even;
            }
            double luDiag = this.lu[col][col];
            int row4 = col + 1;
            while (row4 < m) {
                double[] dArray = this.lu[row4];
                int n = col;
                dArray[n] = dArray[n] / luDiag;
                ++row4;
            }
            ++col;
        }
    }

    @Override
    public RealMatrix getL() {
        if (this.cachedL == null && !this.singular) {
            int m = this.pivot.length;
            this.cachedL = MatrixUtils.createRealMatrix(m, m);
            int i2 = 0;
            while (i2 < m) {
                double[] luI = this.lu[i2];
                int j = 0;
                while (j < i2) {
                    this.cachedL.setEntry(i2, j, luI[j]);
                    ++j;
                }
                this.cachedL.setEntry(i2, i2, 1.0);
                ++i2;
            }
        }
        return this.cachedL;
    }

    @Override
    public RealMatrix getU() {
        if (this.cachedU == null && !this.singular) {
            int m = this.pivot.length;
            this.cachedU = MatrixUtils.createRealMatrix(m, m);
            int i2 = 0;
            while (i2 < m) {
                double[] luI = this.lu[i2];
                int j = i2;
                while (j < m) {
                    this.cachedU.setEntry(i2, j, luI[j]);
                    ++j;
                }
                ++i2;
            }
        }
        return this.cachedU;
    }

    @Override
    public RealMatrix getP() {
        if (this.cachedP == null && !this.singular) {
            int m = this.pivot.length;
            this.cachedP = MatrixUtils.createRealMatrix(m, m);
            int i2 = 0;
            while (i2 < m) {
                this.cachedP.setEntry(i2, this.pivot[i2], 1.0);
                ++i2;
            }
        }
        return this.cachedP;
    }

    @Override
    public int[] getPivot() {
        return (int[])this.pivot.clone();
    }

    @Override
    public double getDeterminant() {
        if (this.singular) {
            return 0.0;
        }
        int m = this.pivot.length;
        double determinant = this.even ? 1 : -1;
        int i2 = 0;
        while (i2 < m) {
            determinant *= this.lu[i2][i2];
            ++i2;
        }
        return determinant;
    }

    @Override
    public DecompositionSolver getSolver() {
        return new Solver(this.lu, this.pivot, this.singular);
    }

    private static class Solver
    implements DecompositionSolver {
        private final double[][] lu;
        private final int[] pivot;
        private final boolean singular;

        private Solver(double[][] lu, int[] pivot, boolean singular) {
            this.lu = lu;
            this.pivot = pivot;
            this.singular = singular;
        }

        @Override
        public boolean isNonSingular() {
            return !this.singular;
        }

        @Override
        public double[] solve(double[] b) throws IllegalArgumentException, InvalidMatrixException {
            int i2;
            double bpCol;
            int m = this.pivot.length;
            if (b.length != m) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, b.length, m);
            }
            if (this.singular) {
                throw new SingularMatrixException();
            }
            double[] bp = new double[m];
            int row = 0;
            while (row < m) {
                bp[row] = b[this.pivot[row]];
                ++row;
            }
            int col = 0;
            while (col < m) {
                bpCol = bp[col];
                i2 = col + 1;
                while (i2 < m) {
                    int n = i2;
                    bp[n] = bp[n] - bpCol * this.lu[i2][col];
                    ++i2;
                }
                ++col;
            }
            col = m - 1;
            while (col >= 0) {
                int n = col;
                bp[n] = bp[n] / this.lu[col][col];
                bpCol = bp[col];
                i2 = 0;
                while (i2 < col) {
                    int n2 = i2;
                    bp[n2] = bp[n2] - bpCol * this.lu[i2][col];
                    ++i2;
                }
                --col;
            }
            return bp;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public RealVector solve(RealVector b) throws IllegalArgumentException, InvalidMatrixException {
            try {
                return this.solve((ArrayRealVector)b);
            }
            catch (ClassCastException cce) {
                m = this.pivot.length;
                if (b.getDimension() != m) {
                    throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, new Object[]{b.getDimension(), m});
                }
                if (this.singular) {
                    throw new SingularMatrixException();
                }
                bp = new double[m];
                row = 0;
                ** while (row < m)
            }
lbl-1000:
            // 1 sources

            {
                bp[row] = b.getEntry(this.pivot[row]);
                ++row;
                continue;
            }
lbl15:
            // 1 sources

            col = 0;
            while (col < m) {
                bpCol = bp[col];
                i = col + 1;
                while (i < m) {
                    v0 = i;
                    bp[v0] = bp[v0] - bpCol * this.lu[i][col];
                    ++i;
                }
                ++col;
            }
            col = m - 1;
            while (col >= 0) {
                v1 = col;
                bp[v1] = bp[v1] / this.lu[col][col];
                bpCol = bp[col];
                i = 0;
                while (i < col) {
                    v2 = i;
                    bp[v2] = bp[v2] - bpCol * this.lu[i][col];
                    ++i;
                }
                --col;
            }
            return new ArrayRealVector(bp, false);
        }

        public ArrayRealVector solve(ArrayRealVector b) throws IllegalArgumentException, InvalidMatrixException {
            return new ArrayRealVector(this.solve(b.getDataRef()), false);
        }

        @Override
        public RealMatrix solve(RealMatrix b) throws IllegalArgumentException, InvalidMatrixException {
            double[] bpCol;
            int m = this.pivot.length;
            if (b.getRowDimension() != m) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_2x2, b.getRowDimension(), b.getColumnDimension(), m, "n");
            }
            if (this.singular) {
                throw new SingularMatrixException();
            }
            int nColB = b.getColumnDimension();
            double[][] bp = new double[m][nColB];
            int row = 0;
            while (row < m) {
                double[] bpRow = bp[row];
                int pRow = this.pivot[row];
                int col = 0;
                while (col < nColB) {
                    bpRow[col] = b.getEntry(pRow, col);
                    ++col;
                }
                ++row;
            }
            int col = 0;
            while (col < m) {
                bpCol = bp[col];
                int i2 = col + 1;
                while (i2 < m) {
                    double[] bpI = bp[i2];
                    double luICol = this.lu[i2][col];
                    int j = 0;
                    while (j < nColB) {
                        int n = j;
                        bpI[n] = bpI[n] - bpCol[j] * luICol;
                        ++j;
                    }
                    ++i2;
                }
                ++col;
            }
            col = m - 1;
            while (col >= 0) {
                bpCol = bp[col];
                double luDiag = this.lu[col][col];
                int j = 0;
                while (j < nColB) {
                    int n = j++;
                    bpCol[n] = bpCol[n] / luDiag;
                }
                int i3 = 0;
                while (i3 < col) {
                    double[] bpI = bp[i3];
                    double luICol = this.lu[i3][col];
                    int j2 = 0;
                    while (j2 < nColB) {
                        int n = j2;
                        bpI[n] = bpI[n] - bpCol[j2] * luICol;
                        ++j2;
                    }
                    ++i3;
                }
                --col;
            }
            return new Array2DRowRealMatrix(bp, false);
        }

        @Override
        public RealMatrix getInverse() throws InvalidMatrixException {
            return this.solve(MatrixUtils.createRealIdentityMatrix(this.pivot.length));
        }
    }
}

