/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import java.io.Serializable;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.linear.AbstractRealMatrix;
import org.apache.commons.math.linear.MatrixIndexException;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.MatrixVisitorException;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealMatrixChangingVisitor;
import org.apache.commons.math.linear.RealMatrixPreservingVisitor;

@Deprecated
public class RealMatrixImpl
extends AbstractRealMatrix
implements Serializable {
    private static final long serialVersionUID = -1067294169172445528L;
    protected double[][] data;

    public RealMatrixImpl() {
    }

    public RealMatrixImpl(int rowDimension, int columnDimension) throws IllegalArgumentException {
        super(rowDimension, columnDimension);
        this.data = new double[rowDimension][columnDimension];
    }

    public RealMatrixImpl(double[][] d) throws IllegalArgumentException, NullPointerException {
        this.copyIn(d);
    }

    public RealMatrixImpl(double[][] d, boolean copyArray) throws IllegalArgumentException, NullPointerException {
        if (copyArray) {
            this.copyIn(d);
        } else {
            if (d == null) {
                throw new NullPointerException();
            }
            int nRows = d.length;
            if (nRows == 0) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_ROW, new Object[0]);
            }
            int nCols = d[0].length;
            if (nCols == 0) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_COLUMN, new Object[0]);
            }
            int r = 1;
            while (r < nRows) {
                if (d[r].length != nCols) {
                    throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIFFERENT_ROWS_LENGTHS, nCols, d[r].length);
                }
                ++r;
            }
            this.data = d;
        }
    }

    public RealMatrixImpl(double[] v) {
        int nRows = v.length;
        this.data = new double[nRows][1];
        int row = 0;
        while (row < nRows) {
            this.data[row][0] = v[row];
            ++row;
        }
    }

    @Override
    public RealMatrix createMatrix(int rowDimension, int columnDimension) throws IllegalArgumentException {
        return new RealMatrixImpl(rowDimension, columnDimension);
    }

    @Override
    public RealMatrix copy() {
        return new RealMatrixImpl(this.copyOut(), false);
    }

    @Override
    public RealMatrix add(RealMatrix m) throws IllegalArgumentException {
        try {
            return this.add((RealMatrixImpl)m);
        }
        catch (ClassCastException cce) {
            return super.add(m);
        }
    }

    public RealMatrixImpl add(RealMatrixImpl m) throws IllegalArgumentException {
        MatrixUtils.checkAdditionCompatible(this, m);
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        double[][] outData = new double[rowCount][columnCount];
        int row = 0;
        while (row < rowCount) {
            double[] dataRow = this.data[row];
            double[] mRow = m.data[row];
            double[] outDataRow = outData[row];
            int col = 0;
            while (col < columnCount) {
                outDataRow[col] = dataRow[col] + mRow[col];
                ++col;
            }
            ++row;
        }
        return new RealMatrixImpl(outData, false);
    }

    @Override
    public RealMatrix subtract(RealMatrix m) throws IllegalArgumentException {
        try {
            return this.subtract((RealMatrixImpl)m);
        }
        catch (ClassCastException cce) {
            return super.subtract(m);
        }
    }

    public RealMatrixImpl subtract(RealMatrixImpl m) throws IllegalArgumentException {
        MatrixUtils.checkSubtractionCompatible(this, m);
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        double[][] outData = new double[rowCount][columnCount];
        int row = 0;
        while (row < rowCount) {
            double[] dataRow = this.data[row];
            double[] mRow = m.data[row];
            double[] outDataRow = outData[row];
            int col = 0;
            while (col < columnCount) {
                outDataRow[col] = dataRow[col] - mRow[col];
                ++col;
            }
            ++row;
        }
        return new RealMatrixImpl(outData, false);
    }

    @Override
    public RealMatrix multiply(RealMatrix m) throws IllegalArgumentException {
        try {
            return this.multiply((RealMatrixImpl)m);
        }
        catch (ClassCastException cce) {
            return super.multiply(m);
        }
    }

    public RealMatrixImpl multiply(RealMatrixImpl m) throws IllegalArgumentException {
        MatrixUtils.checkMultiplicationCompatible(this, m);
        int nRows = this.getRowDimension();
        int nCols = m.getColumnDimension();
        int nSum = this.getColumnDimension();
        double[][] outData = new double[nRows][nCols];
        int row = 0;
        while (row < nRows) {
            double[] dataRow = this.data[row];
            double[] outDataRow = outData[row];
            int col = 0;
            while (col < nCols) {
                double sum = 0.0;
                int i2 = 0;
                while (i2 < nSum) {
                    sum += dataRow[i2] * m.data[i2][col];
                    ++i2;
                }
                outDataRow[col] = sum;
                ++col;
            }
            ++row;
        }
        return new RealMatrixImpl(outData, false);
    }

    @Override
    public double[][] getData() {
        return this.copyOut();
    }

    public double[][] getDataRef() {
        return this.data;
    }

    @Override
    public void setSubMatrix(double[][] subMatrix, int row, int column) throws MatrixIndexException {
        if (this.data == null) {
            if (row > 0) {
                throw MathRuntimeException.createIllegalStateException(LocalizedFormats.FIRST_ROWS_NOT_INITIALIZED_YET, row);
            }
            if (column > 0) {
                throw MathRuntimeException.createIllegalStateException(LocalizedFormats.FIRST_COLUMNS_NOT_INITIALIZED_YET, column);
            }
            int nRows = subMatrix.length;
            if (nRows == 0) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_ROW, new Object[0]);
            }
            int nCols = subMatrix[0].length;
            if (nCols == 0) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_COLUMN, new Object[0]);
            }
            this.data = new double[subMatrix.length][nCols];
            int i2 = 0;
            while (i2 < this.data.length) {
                if (subMatrix[i2].length != nCols) {
                    throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIFFERENT_ROWS_LENGTHS, nCols, subMatrix[i2].length);
                }
                System.arraycopy(subMatrix[i2], 0, this.data[i2 + row], column, nCols);
                ++i2;
            }
        } else {
            super.setSubMatrix(subMatrix, row, column);
        }
    }

    @Override
    public double getEntry(int row, int column) throws MatrixIndexException {
        try {
            return this.data[row][column];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MatrixIndexException(LocalizedFormats.NO_SUCH_MATRIX_ENTRY, row, column, this.getRowDimension(), this.getColumnDimension());
        }
    }

    @Override
    public void setEntry(int row, int column, double value) throws MatrixIndexException {
        try {
            this.data[row][column] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MatrixIndexException(LocalizedFormats.NO_SUCH_MATRIX_ENTRY, row, column, this.getRowDimension(), this.getColumnDimension());
        }
    }

    @Override
    public void addToEntry(int row, int column, double increment) throws MatrixIndexException {
        try {
            double[] dArray = this.data[row];
            int n = column;
            dArray[n] = dArray[n] + increment;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MatrixIndexException(LocalizedFormats.NO_SUCH_MATRIX_ENTRY, row, column, this.getRowDimension(), this.getColumnDimension());
        }
    }

    @Override
    public void multiplyEntry(int row, int column, double factor) throws MatrixIndexException {
        try {
            double[] dArray = this.data[row];
            int n = column;
            dArray[n] = dArray[n] * factor;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MatrixIndexException(LocalizedFormats.NO_SUCH_MATRIX_ENTRY, row, column, this.getRowDimension(), this.getColumnDimension());
        }
    }

    @Override
    public int getRowDimension() {
        return this.data == null ? 0 : this.data.length;
    }

    @Override
    public int getColumnDimension() {
        return this.data == null || this.data[0] == null ? 0 : this.data[0].length;
    }

    @Override
    public double[] operate(double[] v) throws IllegalArgumentException {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (v.length != nCols) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, v.length, nCols);
        }
        double[] out = new double[nRows];
        int row = 0;
        while (row < nRows) {
            double[] dataRow = this.data[row];
            double sum = 0.0;
            int i2 = 0;
            while (i2 < nCols) {
                sum += dataRow[i2] * v[i2];
                ++i2;
            }
            out[row] = sum;
            ++row;
        }
        return out;
    }

    @Override
    public double[] preMultiply(double[] v) throws IllegalArgumentException {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (v.length != nRows) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, v.length, nRows);
        }
        double[] out = new double[nCols];
        int col = 0;
        while (col < nCols) {
            double sum = 0.0;
            int i2 = 0;
            while (i2 < nRows) {
                sum += this.data[i2][col] * v[i2];
                ++i2;
            }
            out[col] = sum;
            ++col;
        }
        return out;
    }

    @Override
    public double walkInRowOrder(RealMatrixChangingVisitor visitor) throws MatrixVisitorException {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        int i2 = 0;
        while (i2 < rows) {
            double[] rowI = this.data[i2];
            int j = 0;
            while (j < columns) {
                rowI[j] = visitor.visit(i2, j, rowI[j]);
                ++j;
            }
            ++i2;
        }
        return visitor.end();
    }

    @Override
    public double walkInRowOrder(RealMatrixPreservingVisitor visitor) throws MatrixVisitorException {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        int i2 = 0;
        while (i2 < rows) {
            double[] rowI = this.data[i2];
            int j = 0;
            while (j < columns) {
                visitor.visit(i2, j, rowI[j]);
                ++j;
            }
            ++i2;
        }
        return visitor.end();
    }

    @Override
    public double walkInRowOrder(RealMatrixChangingVisitor visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        MatrixUtils.checkSubMatrixIndex(this, startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        int i2 = startRow;
        while (i2 <= endRow) {
            double[] rowI = this.data[i2];
            int j = startColumn;
            while (j <= endColumn) {
                rowI[j] = visitor.visit(i2, j, rowI[j]);
                ++j;
            }
            ++i2;
        }
        return visitor.end();
    }

    @Override
    public double walkInRowOrder(RealMatrixPreservingVisitor visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        MatrixUtils.checkSubMatrixIndex(this, startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        int i2 = startRow;
        while (i2 <= endRow) {
            double[] rowI = this.data[i2];
            int j = startColumn;
            while (j <= endColumn) {
                visitor.visit(i2, j, rowI[j]);
                ++j;
            }
            ++i2;
        }
        return visitor.end();
    }

    @Override
    public double walkInColumnOrder(RealMatrixChangingVisitor visitor) throws MatrixVisitorException {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        int j = 0;
        while (j < columns) {
            int i2 = 0;
            while (i2 < rows) {
                double[] rowI = this.data[i2];
                rowI[j] = visitor.visit(i2, j, rowI[j]);
                ++i2;
            }
            ++j;
        }
        return visitor.end();
    }

    @Override
    public double walkInColumnOrder(RealMatrixPreservingVisitor visitor) throws MatrixVisitorException {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        int j = 0;
        while (j < columns) {
            int i2 = 0;
            while (i2 < rows) {
                visitor.visit(i2, j, this.data[i2][j]);
                ++i2;
            }
            ++j;
        }
        return visitor.end();
    }

    @Override
    public double walkInColumnOrder(RealMatrixChangingVisitor visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        MatrixUtils.checkSubMatrixIndex(this, startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        int j = startColumn;
        while (j <= endColumn) {
            int i2 = startRow;
            while (i2 <= endRow) {
                double[] rowI = this.data[i2];
                rowI[j] = visitor.visit(i2, j, rowI[j]);
                ++i2;
            }
            ++j;
        }
        return visitor.end();
    }

    @Override
    public double walkInColumnOrder(RealMatrixPreservingVisitor visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        MatrixUtils.checkSubMatrixIndex(this, startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        int j = startColumn;
        while (j <= endColumn) {
            int i2 = startRow;
            while (i2 <= endRow) {
                visitor.visit(i2, j, this.data[i2][j]);
                ++i2;
            }
            ++j;
        }
        return visitor.end();
    }

    private double[][] copyOut() {
        int nRows = this.getRowDimension();
        double[][] out = new double[nRows][this.getColumnDimension()];
        int i2 = 0;
        while (i2 < nRows) {
            System.arraycopy(this.data[i2], 0, out[i2], 0, this.data[i2].length);
            ++i2;
        }
        return out;
    }

    private void copyIn(double[][] in) {
        this.setSubMatrix(in, 0, 0);
    }
}

