/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.linear.Array2DRowRealMatrix;
import org.apache.commons.math.linear.DecompositionSolver;
import org.apache.commons.math.linear.DefaultRealMatrixPreservingVisitor;
import org.apache.commons.math.linear.EigenDecomposition;
import org.apache.commons.math.linear.EigenDecompositionImpl;
import org.apache.commons.math.linear.InvalidMatrixException;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealVector;
import org.apache.commons.math.linear.SingularValueDecomposition;
import org.apache.commons.math.util.FastMath;

public class SingularValueDecompositionImpl
implements SingularValueDecomposition {
    private int m;
    private int n;
    private EigenDecomposition eigenDecomposition;
    private double[] singularValues;
    private RealMatrix cachedU;
    private RealMatrix cachedUt;
    private RealMatrix cachedS;
    private RealMatrix cachedV;
    private RealMatrix cachedVt;

    public SingularValueDecompositionImpl(RealMatrix matrix) throws InvalidMatrixException {
        int p;
        this.m = matrix.getRowDimension();
        this.n = matrix.getColumnDimension();
        this.cachedU = null;
        this.cachedS = null;
        this.cachedV = null;
        this.cachedVt = null;
        double[][] localcopy = matrix.getData();
        double[][] matATA = new double[this.n][this.n];
        int i2 = 0;
        while (i2 < this.n) {
            int j = i2;
            while (j < this.n) {
                matATA[i2][j] = 0.0;
                int k = 0;
                while (k < this.m) {
                    double[] dArray = matATA[i2];
                    int n = j;
                    dArray[n] = dArray[n] + localcopy[k][i2] * localcopy[k][j];
                    ++k;
                }
                matATA[j][i2] = matATA[i2][j];
                ++j;
            }
            ++i2;
        }
        double[][] matAAT = new double[this.m][this.m];
        int i3 = 0;
        while (i3 < this.m) {
            int j = i3;
            while (j < this.m) {
                matAAT[i3][j] = 0.0;
                int k = 0;
                while (k < this.n) {
                    double[] dArray = matAAT[i3];
                    int n = j;
                    dArray[n] = dArray[n] + localcopy[i3][k] * localcopy[j][k];
                    ++k;
                }
                matAAT[j][i3] = matAAT[i3][j];
                ++j;
            }
            ++i3;
        }
        if (this.m >= this.n) {
            p = this.n;
            this.eigenDecomposition = new EigenDecompositionImpl(new Array2DRowRealMatrix(matATA), 1.0);
            this.singularValues = this.eigenDecomposition.getRealEigenvalues();
            this.cachedV = this.eigenDecomposition.getV();
            this.eigenDecomposition = new EigenDecompositionImpl(new Array2DRowRealMatrix(matAAT), 1.0);
            this.cachedU = this.eigenDecomposition.getV().getSubMatrix(0, this.m - 1, 0, p - 1);
        } else {
            p = this.m;
            this.eigenDecomposition = new EigenDecompositionImpl(new Array2DRowRealMatrix(matAAT), 1.0);
            this.singularValues = this.eigenDecomposition.getRealEigenvalues();
            this.cachedU = this.eigenDecomposition.getV();
            this.eigenDecomposition = new EigenDecompositionImpl(new Array2DRowRealMatrix(matATA), 1.0);
            this.cachedV = this.eigenDecomposition.getV().getSubMatrix(0, this.n - 1, 0, p - 1);
        }
        int i4 = 0;
        while (i4 < p) {
            this.singularValues[i4] = FastMath.sqrt(FastMath.abs(this.singularValues[i4]));
            ++i4;
        }
        i4 = 0;
        while (i4 < p) {
            RealVector tmp = this.cachedU.getColumnVector(i4);
            double product = matrix.operate(this.cachedV.getColumnVector(i4)).dotProduct(tmp);
            if (product < 0.0) {
                this.cachedU.setColumnVector(i4, tmp.mapMultiply(-1.0));
            }
            ++i4;
        }
    }

    @Override
    public RealMatrix getU() throws InvalidMatrixException {
        return this.cachedU;
    }

    @Override
    public RealMatrix getUT() throws InvalidMatrixException {
        if (this.cachedUt == null) {
            this.cachedUt = this.getU().transpose();
        }
        return this.cachedUt;
    }

    @Override
    public RealMatrix getS() throws InvalidMatrixException {
        if (this.cachedS == null) {
            this.cachedS = MatrixUtils.createRealDiagonalMatrix(this.singularValues);
        }
        return this.cachedS;
    }

    @Override
    public double[] getSingularValues() throws InvalidMatrixException {
        return (double[])this.singularValues.clone();
    }

    @Override
    public RealMatrix getV() throws InvalidMatrixException {
        return this.cachedV;
    }

    @Override
    public RealMatrix getVT() throws InvalidMatrixException {
        if (this.cachedVt == null) {
            this.cachedVt = this.getV().transpose();
        }
        return this.cachedVt;
    }

    @Override
    public RealMatrix getCovariance(double minSingularValue) {
        int p = this.singularValues.length;
        int dimension = 0;
        while (dimension < p && this.singularValues[dimension] >= minSingularValue) {
            ++dimension;
        }
        if (dimension == 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.TOO_LARGE_CUTOFF_SINGULAR_VALUE, minSingularValue, this.singularValues[0]);
        }
        final double[][] data = new double[dimension][p];
        this.getVT().walkInOptimizedOrder(new DefaultRealMatrixPreservingVisitor(){

            @Override
            public void visit(int row, int column, double value) {
                data[row][column] = value / SingularValueDecompositionImpl.this.singularValues[row];
            }
        }, 0, dimension - 1, 0, p - 1);
        Array2DRowRealMatrix jv = new Array2DRowRealMatrix(data, false);
        return jv.transpose().multiply(jv);
    }

    @Override
    public double getNorm() throws InvalidMatrixException {
        return this.singularValues[0];
    }

    @Override
    public double getConditionNumber() throws InvalidMatrixException {
        return this.singularValues[0] / this.singularValues[this.singularValues.length - 1];
    }

    @Override
    public int getRank() throws IllegalStateException {
        double threshold = (double)FastMath.max(this.m, this.n) * FastMath.ulp(this.singularValues[0]);
        int i2 = this.singularValues.length - 1;
        while (i2 >= 0) {
            if (this.singularValues[i2] > threshold) {
                return i2 + 1;
            }
            --i2;
        }
        return 0;
    }

    @Override
    public DecompositionSolver getSolver() {
        return new Solver(this.singularValues, this.getUT(), this.getV(), this.getRank() == Math.max(this.m, this.n));
    }

    private static class Solver
    implements DecompositionSolver {
        private final RealMatrix pseudoInverse;
        private boolean nonSingular;

        private Solver(double[] singularValues, RealMatrix uT, RealMatrix v, boolean nonSingular) {
            double[][] suT = uT.getData();
            int i2 = 0;
            while (i2 < singularValues.length) {
                double a = singularValues[i2] > 0.0 ? 1.0 / singularValues[i2] : 0.0;
                double[] suTi = suT[i2];
                int j = 0;
                while (j < suTi.length) {
                    int n = j++;
                    suTi[n] = suTi[n] * a;
                }
                ++i2;
            }
            this.pseudoInverse = v.multiply(new Array2DRowRealMatrix(suT, false));
            this.nonSingular = nonSingular;
        }

        @Override
        public double[] solve(double[] b) throws IllegalArgumentException {
            return this.pseudoInverse.operate(b);
        }

        @Override
        public RealVector solve(RealVector b) throws IllegalArgumentException {
            return this.pseudoInverse.operate(b);
        }

        @Override
        public RealMatrix solve(RealMatrix b) throws IllegalArgumentException {
            return this.pseudoInverse.multiply(b);
        }

        @Override
        public boolean isNonSingular() {
            return this.nonSingular;
        }

        @Override
        public RealMatrix getInverse() {
            return this.pseudoInverse;
        }
    }
}

