/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import java.util.Arrays;
import org.apache.commons.math.linear.InvalidMatrixException;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.NonSquareMatrixException;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.util.FastMath;

class TriDiagonalTransformer {
    private final double[][] householderVectors;
    private final double[] main;
    private final double[] secondary;
    private RealMatrix cachedQ;
    private RealMatrix cachedQt;
    private RealMatrix cachedT;

    public TriDiagonalTransformer(RealMatrix matrix) throws InvalidMatrixException {
        if (!matrix.isSquare()) {
            throw new NonSquareMatrixException(matrix.getRowDimension(), matrix.getColumnDimension());
        }
        int m = matrix.getRowDimension();
        this.householderVectors = matrix.getData();
        this.main = new double[m];
        this.secondary = new double[m - 1];
        this.cachedQ = null;
        this.cachedQt = null;
        this.cachedT = null;
        this.transform();
    }

    public RealMatrix getQ() {
        if (this.cachedQ == null) {
            this.cachedQ = this.getQT().transpose();
        }
        return this.cachedQ;
    }

    public RealMatrix getQT() {
        if (this.cachedQt == null) {
            int m = this.householderVectors.length;
            this.cachedQt = MatrixUtils.createRealMatrix(m, m);
            int k = m - 1;
            while (k >= 1) {
                double[] hK = this.householderVectors[k - 1];
                double inv = 1.0 / (this.secondary[k - 1] * hK[k]);
                this.cachedQt.setEntry(k, k, 1.0);
                if (hK[k] != 0.0) {
                    double beta = 1.0 / this.secondary[k - 1];
                    this.cachedQt.setEntry(k, k, 1.0 + beta * hK[k]);
                    int i2 = k + 1;
                    while (i2 < m) {
                        this.cachedQt.setEntry(k, i2, beta * hK[i2]);
                        ++i2;
                    }
                    int j = k + 1;
                    while (j < m) {
                        beta = 0.0;
                        int i3 = k + 1;
                        while (i3 < m) {
                            beta += this.cachedQt.getEntry(j, i3) * hK[i3];
                            ++i3;
                        }
                        this.cachedQt.setEntry(j, k, (beta *= inv) * hK[k]);
                        i3 = k + 1;
                        while (i3 < m) {
                            this.cachedQt.addToEntry(j, i3, beta * hK[i3]);
                            ++i3;
                        }
                        ++j;
                    }
                }
                --k;
            }
            this.cachedQt.setEntry(0, 0, 1.0);
        }
        return this.cachedQt;
    }

    public RealMatrix getT() {
        if (this.cachedT == null) {
            int m = this.main.length;
            this.cachedT = MatrixUtils.createRealMatrix(m, m);
            int i2 = 0;
            while (i2 < m) {
                this.cachedT.setEntry(i2, i2, this.main[i2]);
                if (i2 > 0) {
                    this.cachedT.setEntry(i2, i2 - 1, this.secondary[i2 - 1]);
                }
                if (i2 < this.main.length - 1) {
                    this.cachedT.setEntry(i2, i2 + 1, this.secondary[i2]);
                }
                ++i2;
            }
        }
        return this.cachedT;
    }

    double[][] getHouseholderVectorsRef() {
        return this.householderVectors;
    }

    double[] getMainDiagonalRef() {
        return this.main;
    }

    double[] getSecondaryDiagonalRef() {
        return this.secondary;
    }

    private void transform() {
        int m = this.householderVectors.length;
        double[] z = new double[m];
        int k = 0;
        while (k < m - 1) {
            double a;
            double[] hK = this.householderVectors[k];
            this.main[k] = hK[k];
            double xNormSqr = 0.0;
            int j = k + 1;
            while (j < m) {
                double c = hK[j];
                xNormSqr += c * c;
                ++j;
            }
            this.secondary[k] = a = hK[k + 1] > 0.0 ? -FastMath.sqrt(xNormSqr) : FastMath.sqrt(xNormSqr);
            if (a != 0.0) {
                int n = k + 1;
                hK[n] = hK[n] - a;
                double beta = -1.0 / (a * hK[k + 1]);
                Arrays.fill(z, k + 1, m, 0.0);
                int i2 = k + 1;
                while (i2 < m) {
                    double[] hI = this.householderVectors[i2];
                    double hKI = hK[i2];
                    double zI = hI[i2] * hKI;
                    int j2 = i2 + 1;
                    while (j2 < m) {
                        double hIJ = hI[j2];
                        zI += hIJ * hK[j2];
                        int n2 = j2++;
                        z[n2] = z[n2] + hIJ * hKI;
                    }
                    z[i2] = beta * (z[i2] + zI);
                    ++i2;
                }
                double gamma = 0.0;
                int i3 = k + 1;
                while (i3 < m) {
                    gamma += z[i3] * hK[i3];
                    ++i3;
                }
                gamma *= beta / 2.0;
                i3 = k + 1;
                while (i3 < m) {
                    int n3 = i3;
                    z[n3] = z[n3] - gamma * hK[i3];
                    ++i3;
                }
                i3 = k + 1;
                while (i3 < m) {
                    double[] hI = this.householderVectors[i3];
                    int j3 = i3;
                    while (j3 < m) {
                        int n4 = j3;
                        hI[n4] = hI[n4] - (hK[i3] * z[j3] + z[i3] * hK[j3]);
                        ++j3;
                    }
                    ++i3;
                }
            }
            ++k;
        }
        this.main[m - 1] = this.householderVectors[m - 1][m - 1];
    }
}

