/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.ode;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.ode.DerivativeException;
import org.apache.commons.math.ode.sampling.StepHandler;
import org.apache.commons.math.ode.sampling.StepInterpolator;
import org.apache.commons.math.util.FastMath;

public class ContinuousOutputModel
implements StepHandler,
Serializable {
    private static final long serialVersionUID = -1417964919405031606L;
    private double initialTime;
    private double finalTime;
    private boolean forward;
    private int index;
    private List<StepInterpolator> steps = new ArrayList<StepInterpolator>();

    public ContinuousOutputModel() {
        this.reset();
    }

    public void append(ContinuousOutputModel model) throws DerivativeException {
        if (model.steps.size() == 0) {
            return;
        }
        if (this.steps.size() == 0) {
            this.initialTime = model.initialTime;
            this.forward = model.forward;
        } else {
            if (this.getInterpolatedState().length != model.getInterpolatedState().length) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_SIMPLE, this.getInterpolatedState().length, model.getInterpolatedState().length);
            }
            if (this.forward ^ model.forward) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.PROPAGATION_DIRECTION_MISMATCH, new Object[0]);
            }
            StepInterpolator lastInterpolator = this.steps.get(this.index);
            double current = lastInterpolator.getCurrentTime();
            double previous = lastInterpolator.getPreviousTime();
            double step = current - previous;
            double gap = model.getInitialTime() - current;
            if (FastMath.abs(gap) > 0.001 * FastMath.abs(step)) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.HOLE_BETWEEN_MODELS_TIME_RANGES, FastMath.abs(gap));
            }
        }
        for (StepInterpolator interpolator : model.steps) {
            this.steps.add(interpolator.copy());
        }
        this.index = this.steps.size() - 1;
        this.finalTime = this.steps.get(this.index).getCurrentTime();
    }

    @Override
    public boolean requiresDenseOutput() {
        return true;
    }

    @Override
    public void reset() {
        this.initialTime = Double.NaN;
        this.finalTime = Double.NaN;
        this.forward = true;
        this.index = 0;
        this.steps.clear();
    }

    @Override
    public void handleStep(StepInterpolator interpolator, boolean isLast) throws DerivativeException {
        if (this.steps.size() == 0) {
            this.initialTime = interpolator.getPreviousTime();
            this.forward = interpolator.isForward();
        }
        this.steps.add(interpolator.copy());
        if (isLast) {
            this.finalTime = interpolator.getCurrentTime();
            this.index = this.steps.size() - 1;
        }
    }

    public double getInitialTime() {
        return this.initialTime;
    }

    public double getFinalTime() {
        return this.finalTime;
    }

    public double getInterpolatedTime() {
        return this.steps.get(this.index).getInterpolatedTime();
    }

    /*
     * Unable to fully structure code
     */
    public void setInterpolatedTime(double time) {
        iMin = 0;
        sMin = this.steps.get(iMin);
        tMin = 0.5 * (sMin.getPreviousTime() + sMin.getCurrentTime());
        iMax = this.steps.size() - 1;
        sMax = this.steps.get(iMax);
        tMax = 0.5 * (sMax.getPreviousTime() + sMax.getCurrentTime());
        if (this.locatePoint(time, sMin) <= 0) {
            this.index = iMin;
            sMin.setInterpolatedTime(time);
            return;
        }
        if (this.locatePoint(time, sMax) < 0) ** GOTO lbl48
        this.index = iMax;
        sMax.setInterpolatedTime(time);
        return;
lbl-1000:
        // 1 sources

        {
            si = this.steps.get(this.index);
            location = this.locatePoint(time, si);
            if (location < 0) {
                iMax = this.index;
                tMax = 0.5 * (si.getPreviousTime() + si.getCurrentTime());
            } else if (location > 0) {
                iMin = this.index;
                tMin = 0.5 * (si.getPreviousTime() + si.getCurrentTime());
            } else {
                si.setInterpolatedTime(time);
                return;
            }
            iMed = (iMin + iMax) / 2;
            sMed = this.steps.get(iMed);
            tMed = 0.5 * (sMed.getPreviousTime() + sMed.getCurrentTime());
            if (FastMath.abs(tMed - tMin) < 1.0E-6 || FastMath.abs(tMax - tMed) < 1.0E-6) {
                this.index = iMed;
            } else {
                d12 = tMax - tMed;
                d23 = tMed - tMin;
                d13 = tMax - tMin;
                dt1 = time - tMax;
                dt2 = time - tMed;
                dt3 = time - tMin;
                iLagrange = (dt2 * dt3 * d23 * (double)iMax - dt1 * dt3 * d13 * (double)iMed + dt1 * dt2 * d12 * (double)iMin) / (d12 * d23 * d13);
                this.index = (int)FastMath.rint(iLagrange);
            }
            low = FastMath.max(iMin + 1, (9 * iMin + iMax) / 10);
            high = FastMath.min(iMax - 1, (iMin + 9 * iMax) / 10);
            if (this.index < low) {
                this.index = low;
                continue;
            }
            if (this.index <= high) continue;
            this.index = high;
lbl48:
            // 4 sources

            ** while (iMax - iMin > 5)
        }
lbl49:
        // 1 sources

        this.index = iMin;
        while (this.index <= iMax && this.locatePoint(time, this.steps.get(this.index)) > 0) {
            ++this.index;
        }
        this.steps.get(this.index).setInterpolatedTime(time);
    }

    public double[] getInterpolatedState() throws DerivativeException {
        return this.steps.get(this.index).getInterpolatedState();
    }

    private int locatePoint(double time, StepInterpolator interval) {
        if (this.forward) {
            if (time < interval.getPreviousTime()) {
                return -1;
            }
            if (time > interval.getCurrentTime()) {
                return 1;
            }
            return 0;
        }
        if (time > interval.getPreviousTime()) {
            return -1;
        }
        if (time < interval.getCurrentTime()) {
            return 1;
        }
        return 0;
    }
}

