/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.ode.nonstiff;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.commons.math.ode.sampling.AbstractStepInterpolator;
import org.apache.commons.math.ode.sampling.StepInterpolator;
import org.apache.commons.math.util.FastMath;

class GraggBulirschStoerStepInterpolator
extends AbstractStepInterpolator {
    private static final long serialVersionUID = 7320613236731409847L;
    private double[] y0Dot;
    private double[] y1;
    private double[] y1Dot;
    private double[][] yMidDots;
    private double[][] polynoms;
    private double[] errfac;
    private int currentDegree;

    public GraggBulirschStoerStepInterpolator() {
        this.y0Dot = null;
        this.y1 = null;
        this.y1Dot = null;
        this.yMidDots = null;
        this.resetTables(-1);
    }

    public GraggBulirschStoerStepInterpolator(double[] y, double[] y0Dot, double[] y1, double[] y1Dot, double[][] yMidDots, boolean forward) {
        super(y, forward);
        this.y0Dot = y0Dot;
        this.y1 = y1;
        this.y1Dot = y1Dot;
        this.yMidDots = yMidDots;
        this.resetTables(yMidDots.length + 4);
    }

    public GraggBulirschStoerStepInterpolator(GraggBulirschStoerStepInterpolator interpolator) {
        super(interpolator);
        int dimension = this.currentState.length;
        this.y0Dot = null;
        this.y1 = null;
        this.y1Dot = null;
        this.yMidDots = null;
        if (interpolator.polynoms == null) {
            this.polynoms = null;
            this.currentDegree = -1;
        } else {
            this.resetTables(interpolator.currentDegree);
            int i2 = 0;
            while (i2 < this.polynoms.length) {
                this.polynoms[i2] = new double[dimension];
                System.arraycopy(interpolator.polynoms[i2], 0, this.polynoms[i2], 0, dimension);
                ++i2;
            }
            this.currentDegree = interpolator.currentDegree;
        }
    }

    private void resetTables(int maxDegree) {
        if (maxDegree < 0) {
            this.polynoms = null;
            this.errfac = null;
            this.currentDegree = -1;
        } else {
            int i2;
            double[][] newPols = new double[maxDegree + 1][];
            if (this.polynoms != null) {
                System.arraycopy(this.polynoms, 0, newPols, 0, this.polynoms.length);
                i2 = this.polynoms.length;
                while (i2 < newPols.length) {
                    newPols[i2] = new double[this.currentState.length];
                    ++i2;
                }
            } else {
                i2 = 0;
                while (i2 < newPols.length) {
                    newPols[i2] = new double[this.currentState.length];
                    ++i2;
                }
            }
            this.polynoms = newPols;
            if (maxDegree <= 4) {
                this.errfac = null;
            } else {
                this.errfac = new double[maxDegree - 4];
                i2 = 0;
                while (i2 < this.errfac.length) {
                    int ip5 = i2 + 5;
                    this.errfac[i2] = 1.0 / (double)(ip5 * ip5);
                    double e = 0.5 * FastMath.sqrt((double)(i2 + 1) / (double)ip5);
                    int j = 0;
                    while (j <= i2) {
                        int n = i2;
                        this.errfac[n] = this.errfac[n] * (e / (double)(j + 1));
                        ++j;
                    }
                    ++i2;
                }
            }
            this.currentDegree = 0;
        }
    }

    @Override
    protected StepInterpolator doCopy() {
        return new GraggBulirschStoerStepInterpolator(this);
    }

    public void computeCoefficients(int mu, double h) {
        if (this.polynoms == null || this.polynoms.length <= mu + 4) {
            this.resetTables(mu + 4);
        }
        this.currentDegree = mu + 4;
        int i2 = 0;
        while (i2 < this.currentState.length) {
            double yp0 = h * this.y0Dot[i2];
            double yp1 = h * this.y1Dot[i2];
            double ydiff = this.y1[i2] - this.currentState[i2];
            double aspl = ydiff - yp1;
            double bspl = yp0 - ydiff;
            this.polynoms[0][i2] = this.currentState[i2];
            this.polynoms[1][i2] = ydiff;
            this.polynoms[2][i2] = aspl;
            this.polynoms[3][i2] = bspl;
            if (mu < 0) {
                return;
            }
            double ph0 = 0.5 * (this.currentState[i2] + this.y1[i2]) + 0.125 * (aspl + bspl);
            this.polynoms[4][i2] = 16.0 * (this.yMidDots[0][i2] - ph0);
            if (mu > 0) {
                double ph1 = ydiff + 0.25 * (aspl - bspl);
                this.polynoms[5][i2] = 16.0 * (this.yMidDots[1][i2] - ph1);
                if (mu > 1) {
                    double ph2 = yp1 - yp0;
                    this.polynoms[6][i2] = 16.0 * (this.yMidDots[2][i2] - ph2 + this.polynoms[4][i2]);
                    if (mu > 2) {
                        double ph3 = 6.0 * (bspl - aspl);
                        this.polynoms[7][i2] = 16.0 * (this.yMidDots[3][i2] - ph3 + 3.0 * this.polynoms[5][i2]);
                        int j = 4;
                        while (j <= mu) {
                            double fac1 = 0.5 * (double)j * (double)(j - 1);
                            double fac2 = 2.0 * fac1 * (double)(j - 2) * (double)(j - 3);
                            this.polynoms[j + 4][i2] = 16.0 * (this.yMidDots[j][i2] + fac1 * this.polynoms[j + 2][i2] - fac2 * this.polynoms[j][i2]);
                            ++j;
                        }
                    }
                }
            }
            ++i2;
        }
    }

    public double estimateError(double[] scale) {
        double error = 0.0;
        if (this.currentDegree >= 5) {
            int i2 = 0;
            while (i2 < scale.length) {
                double e = this.polynoms[this.currentDegree][i2] / scale[i2];
                error += e * e;
                ++i2;
            }
            error = FastMath.sqrt(error / (double)scale.length) * this.errfac[this.currentDegree - 5];
        }
        return error;
    }

    @Override
    protected void computeInterpolatedStateAndDerivatives(double theta, double oneMinusThetaH) {
        int dimension = this.currentState.length;
        double oneMinusTheta = 1.0 - theta;
        double theta05 = theta - 0.5;
        double tOmT = theta * oneMinusTheta;
        double t4 = tOmT * tOmT;
        double t4Dot = 2.0 * tOmT * (1.0 - 2.0 * theta);
        double dot1 = 1.0 / this.h;
        double dot2 = theta * (2.0 - 3.0 * theta) / this.h;
        double dot3 = ((3.0 * theta - 4.0) * theta + 1.0) / this.h;
        int i2 = 0;
        while (i2 < dimension) {
            double p0 = this.polynoms[0][i2];
            double p1 = this.polynoms[1][i2];
            double p2 = this.polynoms[2][i2];
            double p3 = this.polynoms[3][i2];
            this.interpolatedState[i2] = p0 + theta * (p1 + oneMinusTheta * (p2 * theta + p3 * oneMinusTheta));
            this.interpolatedDerivatives[i2] = dot1 * p1 + dot2 * p2 + dot3 * p3;
            if (this.currentDegree > 3) {
                double cDot = 0.0;
                double c = this.polynoms[this.currentDegree][i2];
                int j = this.currentDegree - 1;
                while (j > 3) {
                    double d = 1.0 / (double)(j - 3);
                    cDot = d * (theta05 * cDot + c);
                    c = this.polynoms[j][i2] + c * d * theta05;
                    --j;
                }
                int n = i2;
                this.interpolatedState[n] = this.interpolatedState[n] + t4 * c;
                int n2 = i2;
                this.interpolatedDerivatives[n2] = this.interpolatedDerivatives[n2] + (t4 * cDot + t4Dot * c) / this.h;
            }
            ++i2;
        }
        if (this.h == 0.0) {
            System.arraycopy(this.yMidDots[1], 0, this.interpolatedDerivatives, 0, dimension);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int dimension = this.currentState == null ? -1 : this.currentState.length;
        this.writeBaseExternal(out);
        out.writeInt(this.currentDegree);
        int k = 0;
        while (k <= this.currentDegree) {
            int l = 0;
            while (l < dimension) {
                out.writeDouble(this.polynoms[k][l]);
                ++l;
            }
            ++k;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        double t = this.readBaseExternal(in);
        int dimension = this.currentState == null ? -1 : this.currentState.length;
        int degree = in.readInt();
        this.resetTables(degree);
        this.currentDegree = degree;
        int k = 0;
        while (k <= this.currentDegree) {
            int l = 0;
            while (l < dimension) {
                this.polynoms[k][l] = in.readDouble();
                ++l;
            }
            ++k;
        }
        this.setInterpolatedTime(t);
    }
}

