/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.ode.nonstiff;

import org.apache.commons.math.ode.DerivativeException;
import org.apache.commons.math.ode.nonstiff.RungeKuttaStepInterpolator;
import org.apache.commons.math.ode.sampling.StepInterpolator;

class MidpointStepInterpolator
extends RungeKuttaStepInterpolator {
    private static final long serialVersionUID = -865524111506042509L;

    public MidpointStepInterpolator() {
    }

    public MidpointStepInterpolator(MidpointStepInterpolator interpolator) {
        super(interpolator);
    }

    @Override
    protected StepInterpolator doCopy() {
        return new MidpointStepInterpolator(this);
    }

    @Override
    protected void computeInterpolatedStateAndDerivatives(double theta, double oneMinusThetaH) throws DerivativeException {
        double coeff1 = oneMinusThetaH * theta;
        double coeff2 = oneMinusThetaH * (1.0 + theta);
        double coeffDot2 = 2.0 * theta;
        double coeffDot1 = 1.0 - coeffDot2;
        int i2 = 0;
        while (i2 < this.interpolatedState.length) {
            double yDot1 = this.yDotK[0][i2];
            double yDot2 = this.yDotK[1][i2];
            this.interpolatedState[i2] = this.currentState[i2] + coeff1 * yDot1 - coeff2 * yDot2;
            this.interpolatedDerivatives[i2] = coeffDot1 * yDot1 + coeffDot2 * yDot2;
            ++i2;
        }
    }
}

