/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.ode.nonstiff;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.commons.math.ode.AbstractIntegrator;
import org.apache.commons.math.ode.sampling.AbstractStepInterpolator;

abstract class RungeKuttaStepInterpolator
extends AbstractStepInterpolator {
    protected double[][] yDotK;
    protected AbstractIntegrator integrator;

    protected RungeKuttaStepInterpolator() {
        this.yDotK = null;
        this.integrator = null;
    }

    public RungeKuttaStepInterpolator(RungeKuttaStepInterpolator interpolator) {
        super(interpolator);
        if (interpolator.currentState != null) {
            int dimension = this.currentState.length;
            this.yDotK = new double[interpolator.yDotK.length][];
            int k = 0;
            while (k < interpolator.yDotK.length) {
                this.yDotK[k] = new double[dimension];
                System.arraycopy(interpolator.yDotK[k], 0, this.yDotK[k], 0, dimension);
                ++k;
            }
        } else {
            this.yDotK = null;
        }
        this.integrator = null;
    }

    public void reinitialize(AbstractIntegrator rkIntegrator, double[] y, double[][] yDotArray, boolean forward) {
        this.reinitialize(y, forward);
        this.yDotK = yDotArray;
        this.integrator = rkIntegrator;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeBaseExternal(out);
        int n = this.currentState == null ? -1 : this.currentState.length;
        int kMax = this.yDotK == null ? -1 : this.yDotK.length;
        out.writeInt(kMax);
        int k = 0;
        while (k < kMax) {
            int i2 = 0;
            while (i2 < n) {
                out.writeDouble(this.yDotK[k][i2]);
                ++i2;
            }
            ++k;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        double t = this.readBaseExternal(in);
        int n = this.currentState == null ? -1 : this.currentState.length;
        int kMax = in.readInt();
        this.yDotK = kMax < 0 ? null : new double[kMax][];
        int k = 0;
        while (k < kMax) {
            this.yDotK[k] = n < 0 ? null : new double[n];
            int i2 = 0;
            while (i2 < n) {
                this.yDotK[k][i2] = in.readDouble();
                ++i2;
            }
            ++k;
        }
        this.integrator = null;
        if (this.currentState != null) {
            this.setInterpolatedTime(t);
        } else {
            this.interpolatedTime = t;
        }
    }
}

