/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization;

import org.apache.commons.math.optimization.RealConvergenceChecker;
import org.apache.commons.math.optimization.RealPointValuePair;
import org.apache.commons.math.util.FastMath;

public class SimpleRealPointChecker
implements RealConvergenceChecker {
    private static final double DEFAULT_RELATIVE_THRESHOLD = (double)1.110223E-14f;
    private static final double DEFAULT_ABSOLUTE_THRESHOLD = 2.2250738585072014E-306;
    private final double relativeThreshold;
    private final double absoluteThreshold;

    public SimpleRealPointChecker() {
        this.relativeThreshold = 1.110223E-14f;
        this.absoluteThreshold = 2.2250738585072014E-306;
    }

    public SimpleRealPointChecker(double relativeThreshold, double absoluteThreshold) {
        this.relativeThreshold = relativeThreshold;
        this.absoluteThreshold = absoluteThreshold;
    }

    @Override
    public boolean converged(int iteration, RealPointValuePair previous, RealPointValuePair current) {
        double[] p = previous.getPoint();
        double[] c = current.getPoint();
        int i2 = 0;
        while (i2 < p.length) {
            double size;
            double difference = FastMath.abs(p[i2] - c[i2]);
            if (difference > (size = FastMath.max(FastMath.abs(p[i2]), FastMath.abs(c[i2]))) * this.relativeThreshold && difference > this.absoluteThreshold) {
                return false;
            }
            ++i2;
        }
        return true;
    }
}

