/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization.general;

import java.util.Arrays;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.optimization.OptimizationException;
import org.apache.commons.math.optimization.VectorialPointValuePair;
import org.apache.commons.math.optimization.general.AbstractLeastSquaresOptimizer;
import org.apache.commons.math.util.FastMath;

public class LevenbergMarquardtOptimizer
extends AbstractLeastSquaresOptimizer {
    private int solvedCols;
    private double[] diagR;
    private double[] jacNorm;
    private double[] beta;
    private int[] permutation;
    private int rank;
    private double lmPar;
    private double[] lmDir;
    private double initialStepBoundFactor;
    private double costRelativeTolerance;
    private double parRelativeTolerance;
    private double orthoTolerance;
    private double qrRankingThreshold;

    public LevenbergMarquardtOptimizer() {
        this.setMaxIterations(1000);
        this.setConvergenceChecker(null);
        this.setInitialStepBoundFactor(100.0);
        this.setCostRelativeTolerance(1.0E-10);
        this.setParRelativeTolerance(1.0E-10);
        this.setOrthoTolerance(1.0E-10);
        this.setQRRankingThreshold(Double.MIN_NORMAL);
    }

    public void setInitialStepBoundFactor(double initialStepBoundFactor) {
        this.initialStepBoundFactor = initialStepBoundFactor;
    }

    public void setCostRelativeTolerance(double costRelativeTolerance) {
        this.costRelativeTolerance = costRelativeTolerance;
    }

    public void setParRelativeTolerance(double parRelativeTolerance) {
        this.parRelativeTolerance = parRelativeTolerance;
    }

    public void setOrthoTolerance(double orthoTolerance) {
        this.orthoTolerance = orthoTolerance;
    }

    public void setQRRankingThreshold(double threshold) {
        this.qrRankingThreshold = threshold;
    }

    @Override
    protected VectorialPointValuePair doOptimize() throws FunctionEvaluationException, OptimizationException, IllegalArgumentException {
        this.solvedCols = Math.min(this.rows, this.cols);
        this.diagR = new double[this.cols];
        this.jacNorm = new double[this.cols];
        this.beta = new double[this.cols];
        this.permutation = new int[this.cols];
        this.lmDir = new double[this.cols];
        double delta = 0.0;
        double xNorm = 0.0;
        double[] diag = new double[this.cols];
        double[] oldX = new double[this.cols];
        double[] oldRes = new double[this.rows];
        double[] oldObj = new double[this.rows];
        double[] qtf = new double[this.rows];
        double[] work1 = new double[this.cols];
        double[] work2 = new double[this.cols];
        double[] work3 = new double[this.cols];
        this.updateResidualsAndCost();
        this.lmPar = 0.0;
        boolean firstIteration = true;
        VectorialPointValuePair current = new VectorialPointValuePair(this.point, this.objective);
        block0: while (true) {
            int j;
            int i2 = 0;
            while (i2 < this.rows) {
                qtf[i2] = this.wresiduals[i2];
                ++i2;
            }
            this.incrementIterationsCounter();
            VectorialPointValuePair previous = current;
            this.updateJacobian();
            this.qrDecomposition();
            this.qTy(qtf);
            int k = 0;
            while (k < this.solvedCols) {
                int pk = this.permutation[k];
                this.wjacobian[k][pk] = this.diagR[pk];
                ++k;
            }
            if (firstIteration) {
                xNorm = 0.0;
                k = 0;
                while (k < this.cols) {
                    double dk = this.jacNorm[k];
                    if (dk == 0.0) {
                        dk = 1.0;
                    }
                    double xk = dk * this.point[k];
                    xNorm += xk * xk;
                    diag[k] = dk;
                    ++k;
                }
                delta = (xNorm = FastMath.sqrt(xNorm)) == 0.0 ? this.initialStepBoundFactor : this.initialStepBoundFactor * xNorm;
            }
            double maxCosine = 0.0;
            if (this.cost != 0.0) {
                j = 0;
                while (j < this.solvedCols) {
                    int pj = this.permutation[j];
                    double s = this.jacNorm[pj];
                    if (s != 0.0) {
                        double sum = 0.0;
                        int i3 = 0;
                        while (i3 <= j) {
                            sum += this.wjacobian[i3][pj] * qtf[i3];
                            ++i3;
                        }
                        maxCosine = FastMath.max(maxCosine, FastMath.abs(sum) / (s * this.cost));
                    }
                    ++j;
                }
            }
            if (maxCosine <= this.orthoTolerance) {
                this.updateResidualsAndCost();
                current = new VectorialPointValuePair(this.point, this.objective);
                return current;
            }
            j = 0;
            while (j < this.cols) {
                diag[j] = FastMath.max(diag[j], this.jacNorm[j]);
                ++j;
            }
            double ratio = 0.0;
            do {
                if (!(ratio < 1.0E-4)) continue block0;
                int j2 = 0;
                while (j2 < this.solvedCols) {
                    int pj = this.permutation[j2];
                    oldX[pj] = this.point[pj];
                    ++j2;
                }
                double previousCost = this.cost;
                double[] tmpVec = this.residuals;
                this.residuals = oldRes;
                oldRes = tmpVec;
                tmpVec = this.objective;
                this.objective = oldObj;
                oldObj = tmpVec;
                this.determineLMParameter(qtf, delta, diag, work1, work2, work3);
                double lmNorm = 0.0;
                int j3 = 0;
                while (j3 < this.solvedCols) {
                    int pj = this.permutation[j3];
                    this.lmDir[pj] = -this.lmDir[pj];
                    this.point[pj] = oldX[pj] + this.lmDir[pj];
                    double s = diag[pj] * this.lmDir[pj];
                    lmNorm += s * s;
                    ++j3;
                }
                lmNorm = FastMath.sqrt(lmNorm);
                if (firstIteration) {
                    delta = FastMath.min(delta, lmNorm);
                }
                this.updateResidualsAndCost();
                double actRed = -1.0;
                if (0.1 * this.cost < previousCost) {
                    double r = this.cost / previousCost;
                    actRed = 1.0 - r * r;
                }
                int j4 = 0;
                while (j4 < this.solvedCols) {
                    int pj = this.permutation[j4];
                    double dirJ = this.lmDir[pj];
                    work1[j4] = 0.0;
                    int i4 = 0;
                    while (i4 <= j4) {
                        int n = i4;
                        work1[n] = work1[n] + this.wjacobian[i4][pj] * dirJ;
                        ++i4;
                    }
                    ++j4;
                }
                double coeff1 = 0.0;
                int j5 = 0;
                while (j5 < this.solvedCols) {
                    coeff1 += work1[j5] * work1[j5];
                    ++j5;
                }
                double pc2 = previousCost * previousCost;
                double coeff2 = this.lmPar * lmNorm * lmNorm / pc2;
                double preRed = (coeff1 /= pc2) + 2.0 * coeff2;
                double dirDer = -(coeff1 + coeff2);
                double d = ratio = preRed == 0.0 ? 0.0 : actRed / preRed;
                if (ratio <= 0.25) {
                    double tmp;
                    double d2 = tmp = actRed < 0.0 ? 0.5 * dirDer / (dirDer + 0.5 * actRed) : 0.5;
                    if (0.1 * this.cost >= previousCost || tmp < 0.1) {
                        tmp = 0.1;
                    }
                    delta = tmp * FastMath.min(delta, 10.0 * lmNorm);
                    this.lmPar /= tmp;
                } else if (this.lmPar == 0.0 || ratio >= 0.75) {
                    delta = 2.0 * lmNorm;
                    this.lmPar *= 0.5;
                }
                if (ratio >= 1.0E-4) {
                    firstIteration = false;
                    xNorm = 0.0;
                    int k2 = 0;
                    while (k2 < this.cols) {
                        double xK = diag[k2] * this.point[k2];
                        xNorm += xK * xK;
                        ++k2;
                    }
                    xNorm = FastMath.sqrt(xNorm);
                    current = new VectorialPointValuePair(this.point, this.objective);
                    if (this.checker != null && this.checker.converged(this.getIterations(), previous, current)) {
                        return current;
                    }
                } else {
                    this.cost = previousCost;
                    int j6 = 0;
                    while (j6 < this.solvedCols) {
                        int pj = this.permutation[j6];
                        this.point[pj] = oldX[pj];
                        ++j6;
                    }
                    tmpVec = this.residuals;
                    this.residuals = oldRes;
                    oldRes = tmpVec;
                    tmpVec = this.objective;
                    this.objective = oldObj;
                    oldObj = tmpVec;
                }
                if (this.checker == null && (FastMath.abs(actRed) <= this.costRelativeTolerance && preRed <= this.costRelativeTolerance && ratio <= 2.0 || delta <= this.parRelativeTolerance * xNorm)) {
                    return current;
                }
                if (FastMath.abs(actRed) <= 2.2204E-16 && preRed <= 2.2204E-16 && ratio <= 2.0) {
                    throw new OptimizationException(LocalizedFormats.TOO_SMALL_COST_RELATIVE_TOLERANCE, this.costRelativeTolerance);
                }
                if (!(delta <= 2.2204E-16 * xNorm)) continue;
                throw new OptimizationException(LocalizedFormats.TOO_SMALL_PARAMETERS_RELATIVE_TOLERANCE, this.parRelativeTolerance);
            } while (!(maxCosine <= 2.2204E-16));
            break;
        }
        throw new OptimizationException(LocalizedFormats.TOO_SMALL_ORTHOGONALITY_TOLERANCE, this.orthoTolerance);
    }

    private void determineLMParameter(double[] qy, double delta, double[] diag, double[] work1, double[] work2, double[] work3) {
        double sum;
        int pj;
        int j;
        int j2 = 0;
        while (j2 < this.rank) {
            this.lmDir[this.permutation[j2]] = qy[j2];
            ++j2;
        }
        j2 = this.rank;
        while (j2 < this.cols) {
            this.lmDir[this.permutation[j2]] = 0.0;
            ++j2;
        }
        int k = this.rank - 1;
        while (k >= 0) {
            int pk = this.permutation[k];
            double ypk = this.lmDir[pk] / this.diagR[pk];
            int i2 = 0;
            while (i2 < k) {
                int n = this.permutation[i2];
                this.lmDir[n] = this.lmDir[n] - ypk * this.wjacobian[i2][pk];
                ++i2;
            }
            this.lmDir[pk] = ypk;
            --k;
        }
        double dxNorm = 0.0;
        int j3 = 0;
        while (j3 < this.solvedCols) {
            double s;
            int pj2 = this.permutation[j3];
            work1[pj2] = s = diag[pj2] * this.lmDir[pj2];
            dxNorm += s * s;
            ++j3;
        }
        double fp = (dxNorm = FastMath.sqrt(dxNorm)) - delta;
        if (fp <= 0.1 * delta) {
            this.lmPar = 0.0;
            return;
        }
        double parl = 0.0;
        if (this.rank == this.solvedCols) {
            j = 0;
            while (j < this.solvedCols) {
                int n = pj = this.permutation[j];
                work1[n] = work1[n] * (diag[pj] / dxNorm);
                ++j;
            }
            double sum2 = 0.0;
            j = 0;
            while (j < this.solvedCols) {
                double s;
                pj = this.permutation[j];
                sum = 0.0;
                int i3 = 0;
                while (i3 < j) {
                    sum += this.wjacobian[i3][pj] * work1[this.permutation[i3]];
                    ++i3;
                }
                work1[pj] = s = (work1[pj] - sum) / this.diagR[pj];
                sum2 += s * s;
                ++j;
            }
            parl = fp / (delta * sum2);
        }
        double sum2 = 0.0;
        j = 0;
        while (j < this.solvedCols) {
            pj = this.permutation[j];
            sum = 0.0;
            int i4 = 0;
            while (i4 <= j) {
                sum += this.wjacobian[i4][pj] * qy[i4];
                ++i4;
            }
            sum2 += (sum /= diag[pj]) * sum;
            ++j;
        }
        double gNorm = FastMath.sqrt(sum2);
        double paru = gNorm / delta;
        if (paru == 0.0) {
            paru = 2.2251E-308 / FastMath.min(delta, 0.1);
        }
        this.lmPar = FastMath.min(paru, FastMath.max(this.lmPar, parl));
        if (this.lmPar == 0.0) {
            this.lmPar = gNorm / dxNorm;
        }
        int countdown = 10;
        while (countdown >= 0) {
            int pj3;
            int pj4;
            if (this.lmPar == 0.0) {
                this.lmPar = FastMath.max(2.2251E-308, 0.001 * paru);
            }
            double sPar = FastMath.sqrt(this.lmPar);
            int j4 = 0;
            while (j4 < this.solvedCols) {
                pj4 = this.permutation[j4];
                work1[pj4] = sPar * diag[pj4];
                ++j4;
            }
            this.determineLMDirection(qy, work1, work2, work3);
            dxNorm = 0.0;
            j4 = 0;
            while (j4 < this.solvedCols) {
                double s;
                pj4 = this.permutation[j4];
                work3[pj4] = s = diag[pj4] * this.lmDir[pj4];
                dxNorm += s * s;
                ++j4;
            }
            dxNorm = FastMath.sqrt(dxNorm);
            double previousFP = fp;
            fp = dxNorm - delta;
            if (FastMath.abs(fp) <= 0.1 * delta || parl == 0.0 && fp <= previousFP && previousFP < 0.0) {
                return;
            }
            int j5 = 0;
            while (j5 < this.solvedCols) {
                pj3 = this.permutation[j5];
                work1[pj3] = work3[pj3] * diag[pj3] / dxNorm;
                ++j5;
            }
            j5 = 0;
            while (j5 < this.solvedCols) {
                int n = pj3 = this.permutation[j5];
                work1[n] = work1[n] / work2[j5];
                double tmp = work1[pj3];
                int i5 = j5 + 1;
                while (i5 < this.solvedCols) {
                    int n2 = this.permutation[i5];
                    work1[n2] = work1[n2] - this.wjacobian[i5][pj3] * tmp;
                    ++i5;
                }
                ++j5;
            }
            sum2 = 0.0;
            j5 = 0;
            while (j5 < this.solvedCols) {
                double s = work1[this.permutation[j5]];
                sum2 += s * s;
                ++j5;
            }
            double correction = fp / (delta * sum2);
            if (fp > 0.0) {
                parl = FastMath.max(parl, this.lmPar);
            } else if (fp < 0.0) {
                paru = FastMath.min(paru, this.lmPar);
            }
            this.lmPar = FastMath.max(parl, this.lmPar + correction);
            --countdown;
        }
    }

    private void determineLMDirection(double[] qy, double[] diag, double[] lmDiag, double[] work) {
        int pj;
        int j = 0;
        while (j < this.solvedCols) {
            pj = this.permutation[j];
            int i2 = j + 1;
            while (i2 < this.solvedCols) {
                this.wjacobian[i2][pj] = this.wjacobian[j][this.permutation[i2]];
                ++i2;
            }
            this.lmDir[j] = this.diagR[pj];
            work[j] = qy[j];
            ++j;
        }
        j = 0;
        while (j < this.solvedCols) {
            pj = this.permutation[j];
            double dpj = diag[pj];
            if (dpj != 0.0) {
                Arrays.fill(lmDiag, j + 1, lmDiag.length, 0.0);
            }
            lmDiag[j] = dpj;
            double qtbpj = 0.0;
            int k = j;
            while (k < this.solvedCols) {
                int pk = this.permutation[k];
                if (lmDiag[k] != 0.0) {
                    double cos;
                    double sin;
                    double rkk = this.wjacobian[k][pk];
                    if (FastMath.abs(rkk) < FastMath.abs(lmDiag[k])) {
                        double cotan = rkk / lmDiag[k];
                        sin = 1.0 / FastMath.sqrt(1.0 + cotan * cotan);
                        cos = sin * cotan;
                    } else {
                        double tan = lmDiag[k] / rkk;
                        cos = 1.0 / FastMath.sqrt(1.0 + tan * tan);
                        sin = cos * tan;
                    }
                    this.wjacobian[k][pk] = cos * rkk + sin * lmDiag[k];
                    double temp = cos * work[k] + sin * qtbpj;
                    qtbpj = -sin * work[k] + cos * qtbpj;
                    work[k] = temp;
                    int i3 = k + 1;
                    while (i3 < this.solvedCols) {
                        double rik = this.wjacobian[i3][pk];
                        double temp2 = cos * rik + sin * lmDiag[i3];
                        lmDiag[i3] = -sin * rik + cos * lmDiag[i3];
                        this.wjacobian[i3][pk] = temp2;
                        ++i3;
                    }
                }
                ++k;
            }
            lmDiag[j] = this.wjacobian[j][this.permutation[j]];
            this.wjacobian[j][this.permutation[j]] = this.lmDir[j];
            ++j;
        }
        int nSing = this.solvedCols;
        int j2 = 0;
        while (j2 < this.solvedCols) {
            if (lmDiag[j2] == 0.0 && nSing == this.solvedCols) {
                nSing = j2;
            }
            if (nSing < this.solvedCols) {
                work[j2] = 0.0;
            }
            ++j2;
        }
        if (nSing > 0) {
            j2 = nSing - 1;
            while (j2 >= 0) {
                int pj2 = this.permutation[j2];
                double sum = 0.0;
                int i4 = j2 + 1;
                while (i4 < nSing) {
                    sum += this.wjacobian[i4][pj2] * work[i4];
                    ++i4;
                }
                work[j2] = (work[j2] - sum) / lmDiag[j2];
                --j2;
            }
        }
        j2 = 0;
        while (j2 < this.lmDir.length) {
            this.lmDir[this.permutation[j2]] = work[j2];
            ++j2;
        }
    }

    private void qrDecomposition() throws OptimizationException {
        int k = 0;
        while (k < this.cols) {
            this.permutation[k] = k;
            double norm2 = 0.0;
            int i2 = 0;
            while (i2 < this.wjacobian.length) {
                double akk = this.wjacobian[i2][k];
                norm2 += akk * akk;
                ++i2;
            }
            this.jacNorm[k] = FastMath.sqrt(norm2);
            ++k;
        }
        k = 0;
        while (k < this.cols) {
            double betak;
            int nextColumn = -1;
            double ak2 = Double.NEGATIVE_INFINITY;
            int i3 = k;
            while (i3 < this.cols) {
                double norm2 = 0.0;
                int j = k;
                while (j < this.wjacobian.length) {
                    double aki = this.wjacobian[j][this.permutation[i3]];
                    norm2 += aki * aki;
                    ++j;
                }
                if (Double.isInfinite(norm2) || Double.isNaN(norm2)) {
                    throw new OptimizationException(LocalizedFormats.UNABLE_TO_PERFORM_QR_DECOMPOSITION_ON_JACOBIAN, this.rows, this.cols);
                }
                if (norm2 > ak2) {
                    nextColumn = i3;
                    ak2 = norm2;
                }
                ++i3;
            }
            if (ak2 <= this.qrRankingThreshold) {
                this.rank = k;
                return;
            }
            int pk = this.permutation[nextColumn];
            this.permutation[nextColumn] = this.permutation[k];
            this.permutation[k] = pk;
            double akk = this.wjacobian[k][pk];
            double alpha = akk > 0.0 ? -FastMath.sqrt(ak2) : FastMath.sqrt(ak2);
            this.beta[pk] = betak = 1.0 / (ak2 - akk * alpha);
            this.diagR[pk] = alpha;
            double[] dArray = this.wjacobian[k];
            int n = pk;
            dArray[n] = dArray[n] - alpha;
            int dk = this.cols - 1 - k;
            while (dk > 0) {
                double gamma = 0.0;
                int j = k;
                while (j < this.wjacobian.length) {
                    gamma += this.wjacobian[j][pk] * this.wjacobian[j][this.permutation[k + dk]];
                    ++j;
                }
                gamma *= betak;
                j = k;
                while (j < this.wjacobian.length) {
                    double[] dArray2 = this.wjacobian[j];
                    int n2 = this.permutation[k + dk];
                    dArray2[n2] = dArray2[n2] - gamma * this.wjacobian[j][pk];
                    ++j;
                }
                --dk;
            }
            ++k;
        }
        this.rank = this.solvedCols;
    }

    private void qTy(double[] y) {
        int k = 0;
        while (k < this.cols) {
            int pk = this.permutation[k];
            double gamma = 0.0;
            int i2 = k;
            while (i2 < this.rows) {
                gamma += this.wjacobian[i2][pk] * y[i2];
                ++i2;
            }
            gamma *= this.beta[pk];
            i2 = k;
            while (i2 < this.rows) {
                int n = i2;
                y[n] = y[n] - gamma * this.wjacobian[i2][pk];
                ++i2;
            }
            ++k;
        }
    }
}

