/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization.general;

import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.solvers.BrentSolver;
import org.apache.commons.math.analysis.solvers.UnivariateRealSolver;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.optimization.GoalType;
import org.apache.commons.math.optimization.OptimizationException;
import org.apache.commons.math.optimization.RealPointValuePair;
import org.apache.commons.math.optimization.general.AbstractScalarDifferentiableOptimizer;
import org.apache.commons.math.optimization.general.ConjugateGradientFormula;
import org.apache.commons.math.optimization.general.Preconditioner;
import org.apache.commons.math.util.FastMath;

public class NonLinearConjugateGradientOptimizer
extends AbstractScalarDifferentiableOptimizer {
    private final ConjugateGradientFormula updateFormula;
    private Preconditioner preconditioner;
    private UnivariateRealSolver solver;
    private double initialStep;

    public NonLinearConjugateGradientOptimizer(ConjugateGradientFormula updateFormula) {
        this.updateFormula = updateFormula;
        this.preconditioner = null;
        this.solver = null;
        this.initialStep = 1.0;
    }

    public void setPreconditioner(Preconditioner preconditioner) {
        this.preconditioner = preconditioner;
    }

    public void setLineSearchSolver(UnivariateRealSolver lineSearchSolver) {
        this.solver = lineSearchSolver;
    }

    public void setInitialStep(double initialStep) {
        this.initialStep = initialStep <= 0.0 ? 1.0 : initialStep;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected RealPointValuePair doOptimize() throws FunctionEvaluationException, OptimizationException, IllegalArgumentException {
        try {
            if (this.preconditioner == null) {
                this.preconditioner = new IdentityPreconditioner();
            }
            if (this.solver == null) {
                this.solver = new BrentSolver();
            }
            n = this.point.length;
            r = this.computeObjectiveGradient(this.point);
            if (this.goal == GoalType.MINIMIZE) {
                i = 0;
                while (i < n) {
                    r[i] = -r[i];
                    ++i;
                }
            }
            steepestDescent = this.preconditioner.precondition(this.point, r);
            searchDirection = (double[])steepestDescent.clone();
            delta = 0.0;
            i = 0;
            while (i < n) {
                delta += r[i] * searchDirection[i];
                ++i;
            }
            current = null;
            block4: while (true) {
                objective = this.computeObjectiveValue(this.point);
                previous = current;
                current = new RealPointValuePair(this.point, objective);
                if (previous != null && this.checker.converged(this.getIterations(), previous, current)) {
                    return current;
                }
                this.incrementIterationsCounter();
                dTd = 0.0;
                var17_19 = searchDirection;
                var16_18 = searchDirection.length;
                var15_16 = 0;
                while (var15_16 < var16_18) {
                    di = var17_19[var15_16];
                    dTd += di * di;
                    ++var15_16;
                }
                lsf = new LineSearchFunction(searchDirection);
                step = this.solver.solve(lsf, 0.0, this.findUpperBound(lsf, 0.0, this.initialStep));
                i = 0;
                while (i < this.point.length) {
                    v0 = i;
                    this.point[v0] = this.point[v0] + step * searchDirection[i];
                    ++i;
                }
                r = this.computeObjectiveGradient(this.point);
                if (this.goal == GoalType.MINIMIZE) {
                    i = 0;
                    while (i < n) {
                        r[i] = -r[i];
                        ++i;
                    }
                }
                deltaOld = delta;
                newSteepestDescent = this.preconditioner.precondition(this.point, r);
                delta = 0.0;
                i = 0;
                while (i < n) {
                    delta += r[i] * newSteepestDescent[i];
                    ++i;
                }
                if (this.updateFormula == ConjugateGradientFormula.FLETCHER_REEVES) {
                    beta = delta / deltaOld;
                } else {
                    deltaMid = 0.0;
                    i = 0;
                    while (i < r.length) {
                        deltaMid += r[i] * steepestDescent[i];
                        ++i;
                    }
                    beta = (delta - deltaMid) / deltaOld;
                }
                steepestDescent = newSteepestDescent;
                if (this.getIterations() % n == 0 || beta < 0.0) {
                    searchDirection = (double[])steepestDescent.clone();
                    continue;
                }
                i = 0;
                while (true) {
                    if (i < n) ** break;
                    continue block4;
                    searchDirection[i] = steepestDescent[i] + beta * searchDirection[i];
                    ++i;
                }
                break;
            }
        }
        catch (ConvergenceException ce) {
            throw new OptimizationException(ce);
        }
    }

    private double findUpperBound(UnivariateRealFunction f, double a, double h) throws FunctionEvaluationException, OptimizationException {
        double yA;
        double yB = yA = f.value(a);
        double step = h;
        while (step < Double.MAX_VALUE) {
            double b = a + step;
            yB = f.value(b);
            if (yA * yB <= 0.0) {
                return b;
            }
            step *= FastMath.max(2.0, yA / yB);
        }
        throw new OptimizationException(LocalizedFormats.UNABLE_TO_BRACKET_OPTIMUM_IN_LINE_SEARCH, new Object[0]);
    }

    private static class IdentityPreconditioner
    implements Preconditioner {
        private IdentityPreconditioner() {
        }

        @Override
        public double[] precondition(double[] variables, double[] r) {
            return (double[])r.clone();
        }
    }

    private class LineSearchFunction
    implements UnivariateRealFunction {
        private final double[] searchDirection;

        public LineSearchFunction(double[] searchDirection) {
            this.searchDirection = searchDirection;
        }

        @Override
        public double value(double x) throws FunctionEvaluationException {
            double[] shiftedPoint = (double[])NonLinearConjugateGradientOptimizer.this.point.clone();
            int i2 = 0;
            while (i2 < shiftedPoint.length) {
                int n = i2;
                shiftedPoint[n] = shiftedPoint[n] + x * this.searchDirection[i2];
                ++i2;
            }
            double[] gradient = NonLinearConjugateGradientOptimizer.this.computeObjectiveGradient(shiftedPoint);
            double dotProduct = 0.0;
            int i3 = 0;
            while (i3 < gradient.length) {
                dotProduct += gradient[i3] * this.searchDirection[i3];
                ++i3;
            }
            return dotProduct;
        }
    }
}

