/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.random;

import org.apache.commons.math.DimensionMismatchException;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.NotPositiveDefiniteMatrixException;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.random.NormalizedRandomGenerator;
import org.apache.commons.math.random.RandomVectorGenerator;
import org.apache.commons.math.util.FastMath;

public class CorrelatedRandomVectorGenerator
implements RandomVectorGenerator {
    private final double[] mean;
    private final NormalizedRandomGenerator generator;
    private final double[] normalized;
    private RealMatrix root;
    private int rank;

    public CorrelatedRandomVectorGenerator(double[] mean, RealMatrix covariance, double small, NormalizedRandomGenerator generator) throws NotPositiveDefiniteMatrixException, DimensionMismatchException {
        int order = covariance.getRowDimension();
        if (mean.length != order) {
            throw new DimensionMismatchException(mean.length, order);
        }
        this.mean = (double[])mean.clone();
        this.decompose(covariance, small);
        this.generator = generator;
        this.normalized = new double[this.rank];
    }

    public CorrelatedRandomVectorGenerator(RealMatrix covariance, double small, NormalizedRandomGenerator generator) throws NotPositiveDefiniteMatrixException {
        int order = covariance.getRowDimension();
        this.mean = new double[order];
        int i2 = 0;
        while (i2 < order) {
            this.mean[i2] = 0.0;
            ++i2;
        }
        this.decompose(covariance, small);
        this.generator = generator;
        this.normalized = new double[this.rank];
    }

    public NormalizedRandomGenerator getGenerator() {
        return this.generator;
    }

    public RealMatrix getRootMatrix() {
        return this.root;
    }

    public int getRank() {
        return this.rank;
    }

    private void decompose(RealMatrix covariance, double small) throws NotPositiveDefiniteMatrixException {
        int order = covariance.getRowDimension();
        double[][] c = covariance.getData();
        double[][] b = new double[order][order];
        int[] swap = new int[order];
        int[] index = new int[order];
        int i2 = 0;
        while (i2 < order) {
            index[i2] = i2;
            ++i2;
        }
        this.rank = 0;
        boolean loop = true;
        while (loop) {
            double sqrt;
            int ir;
            swap[this.rank] = this.rank;
            int i3 = this.rank + 1;
            while (i3 < order) {
                int ii = index[i3];
                int isi = index[swap[i3]];
                if (c[ii][ii] > c[isi][isi]) {
                    swap[this.rank] = i3;
                }
                ++i3;
            }
            if (swap[this.rank] != this.rank) {
                int tmp = index[this.rank];
                index[this.rank] = index[swap[this.rank]];
                index[swap[this.rank]] = tmp;
            }
            if (c[ir = index[this.rank]][ir] < small) {
                if (this.rank == 0) {
                    throw new NotPositiveDefiniteMatrixException();
                }
                int i4 = this.rank;
                while (i4 < order) {
                    if (c[index[i4]][index[i4]] < -small) {
                        throw new NotPositiveDefiniteMatrixException();
                    }
                    ++i4;
                }
                ++this.rank;
                loop = false;
                continue;
            }
            b[this.rank][this.rank] = sqrt = FastMath.sqrt(c[ir][ir]);
            double inverse = 1.0 / sqrt;
            int i5 = this.rank + 1;
            while (i5 < order) {
                double e;
                int ii = index[i5];
                b[i5][this.rank] = e = inverse * c[ii][ir];
                double[] dArray = c[ii];
                int n = ii;
                dArray[n] = dArray[n] - e * e;
                int j = this.rank + 1;
                while (j < i5) {
                    double f;
                    int ij = index[j];
                    c[ii][ij] = f = c[ii][ij] - e * b[j][this.rank];
                    c[ij][ii] = f;
                    ++j;
                }
                ++i5;
            }
            boolean bl = loop = ++this.rank < order;
        }
        this.root = MatrixUtils.createRealMatrix(order, this.rank);
        i2 = 0;
        while (i2 < order) {
            int j = 0;
            while (j < this.rank) {
                this.root.setEntry(index[i2], j, b[i2][j]);
                ++j;
            }
            ++i2;
        }
    }

    @Override
    public double[] nextVector() {
        int i2 = 0;
        while (i2 < this.rank) {
            this.normalized[i2] = this.generator.nextNormalizedDouble();
            ++i2;
        }
        double[] correlated = new double[this.mean.length];
        int i3 = 0;
        while (i3 < correlated.length) {
            correlated[i3] = this.mean[i3];
            int j = 0;
            while (j < this.rank) {
                int n = i3;
                correlated[n] = correlated[n] + this.root.getEntry(i3, j) * this.normalized[j];
                ++j;
            }
            ++i3;
        }
        return correlated;
    }
}

