/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.random;

import java.io.Serializable;
import org.apache.commons.math.random.BitsStreamGenerator;
import org.apache.commons.math.util.FastMath;

public class MersenneTwister
extends BitsStreamGenerator
implements Serializable {
    private static final long serialVersionUID = 8661194735290153518L;
    private static final int N = 624;
    private static final int M = 397;
    private static final int[] MAG01;
    private int[] mt = new int[624];
    private int mti;

    static {
        int[] nArray = new int[2];
        nArray[1] = -1727483681;
        MAG01 = nArray;
    }

    public MersenneTwister() {
        this.setSeed(System.currentTimeMillis());
    }

    public MersenneTwister(int seed) {
        this.setSeed(seed);
    }

    public MersenneTwister(int[] seed) {
        this.setSeed(seed);
    }

    public MersenneTwister(long seed) {
        this.setSeed(seed);
    }

    @Override
    public void setSeed(int seed) {
        long longMT = seed;
        this.mt[0] = (int)longMT;
        this.mti = 1;
        while (this.mti < 624) {
            longMT = 1812433253L * (longMT ^ longMT >> 30) + (long)this.mti & 0xFFFFFFFFL;
            this.mt[this.mti] = (int)longMT;
            ++this.mti;
        }
    }

    @Override
    public void setSeed(int[] seed) {
        long l;
        long l1;
        long l0;
        if (seed == null) {
            this.setSeed(System.currentTimeMillis());
            return;
        }
        this.setSeed(19650218);
        int i2 = 1;
        int j = 0;
        int k = FastMath.max(624, seed.length);
        while (k != 0) {
            l0 = (long)this.mt[i2] & Integer.MAX_VALUE | (this.mt[i2] < 0 ? 0x80000000L : 0L);
            l1 = (long)this.mt[i2 - 1] & Integer.MAX_VALUE | (this.mt[i2 - 1] < 0 ? 0x80000000L : 0L);
            l = (l0 ^ (l1 ^ l1 >> 30) * 1664525L) + (long)seed[j] + (long)j;
            this.mt[i2] = (int)(l & 0xFFFFFFFFL);
            ++j;
            if (++i2 >= 624) {
                this.mt[0] = this.mt[623];
                i2 = 1;
            }
            if (j >= seed.length) {
                j = 0;
            }
            --k;
        }
        k = 623;
        while (k != 0) {
            l0 = (long)this.mt[i2] & Integer.MAX_VALUE | (this.mt[i2] < 0 ? 0x80000000L : 0L);
            l1 = (long)this.mt[i2 - 1] & Integer.MAX_VALUE | (this.mt[i2 - 1] < 0 ? 0x80000000L : 0L);
            l = (l0 ^ (l1 ^ l1 >> 30) * 1566083941L) - (long)i2;
            this.mt[i2] = (int)(l & 0xFFFFFFFFL);
            if (++i2 >= 624) {
                this.mt[0] = this.mt[623];
                i2 = 1;
            }
            --k;
        }
        this.mt[0] = Integer.MIN_VALUE;
    }

    @Override
    public void setSeed(long seed) {
        this.setSeed(new int[]{(int)(seed >>> 32), (int)(seed & 0xFFFFFFFFL)});
    }

    @Override
    protected int next(int bits) {
        int y;
        if (this.mti >= 624) {
            int mtCurr;
            int mtNext = this.mt[0];
            int k = 0;
            while (k < 227) {
                mtCurr = mtNext;
                mtNext = this.mt[k + 1];
                y = mtCurr & Integer.MIN_VALUE | mtNext & Integer.MAX_VALUE;
                this.mt[k] = this.mt[k + 397] ^ y >>> 1 ^ MAG01[y & 1];
                ++k;
            }
            k = 227;
            while (k < 623) {
                mtCurr = mtNext;
                mtNext = this.mt[k + 1];
                y = mtCurr & Integer.MIN_VALUE | mtNext & Integer.MAX_VALUE;
                this.mt[k] = this.mt[k + -227] ^ y >>> 1 ^ MAG01[y & 1];
                ++k;
            }
            y = mtNext & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ y >>> 1 ^ MAG01[y & 1];
            this.mti = 0;
        }
        y = this.mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        return y >>> 32 - bits;
    }
}

