/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.clustering;

import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.math.stat.clustering.Clusterable;
import org.apache.commons.math.util.MathUtils;

public class EuclideanIntegerPoint
implements Clusterable<EuclideanIntegerPoint>,
Serializable {
    private static final long serialVersionUID = 3946024775784901369L;
    private final int[] point;

    public EuclideanIntegerPoint(int[] point) {
        this.point = point;
    }

    public int[] getPoint() {
        return this.point;
    }

    @Override
    public double distanceFrom(EuclideanIntegerPoint p) {
        return MathUtils.distance(this.point, p.getPoint());
    }

    @Override
    public EuclideanIntegerPoint centroidOf(Collection<EuclideanIntegerPoint> points) {
        int[] centroid = new int[this.getPoint().length];
        for (EuclideanIntegerPoint p : points) {
            int i2 = 0;
            while (i2 < centroid.length) {
                int n = i2;
                centroid[n] = centroid[n] + p.getPoint()[i2];
                ++i2;
            }
        }
        int i3 = 0;
        while (i3 < centroid.length) {
            int n = i3++;
            centroid[n] = centroid[n] / points.size();
        }
        return new EuclideanIntegerPoint(centroid);
    }

    public boolean equals(Object other) {
        if (!(other instanceof EuclideanIntegerPoint)) {
            return false;
        }
        int[] otherPoint = ((EuclideanIntegerPoint)other).getPoint();
        if (this.point.length != otherPoint.length) {
            return false;
        }
        int i2 = 0;
        while (i2 < this.point.length) {
            if (this.point[i2] != otherPoint[i2]) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 0;
        int[] nArray = this.point;
        int n = this.point.length;
        int n2 = 0;
        while (n2 < n) {
            Integer i2 = nArray[n2];
            hashCode += i2.hashCode() * 13 + 7;
            ++n2;
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder("(");
        int[] coordinates = this.getPoint();
        int i2 = 0;
        while (i2 < coordinates.length) {
            buff.append(coordinates[i2]);
            if (i2 < coordinates.length - 1) {
                buff.append(",");
            }
            ++i2;
        }
        buff.append(")");
        return buff.toString();
    }
}

