/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.clustering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.apache.commons.math.exception.ConvergenceException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.stat.clustering.Cluster;
import org.apache.commons.math.stat.clustering.Clusterable;
import org.apache.commons.math.stat.descriptive.moment.Variance;

public class KMeansPlusPlusClusterer<T extends Clusterable<T>> {
    private final Random random;
    private final EmptyClusterStrategy emptyStrategy;

    public KMeansPlusPlusClusterer(Random random) {
        this(random, EmptyClusterStrategy.LARGEST_VARIANCE);
    }

    public KMeansPlusPlusClusterer(Random random, EmptyClusterStrategy emptyStrategy) {
        this.random = random;
        this.emptyStrategy = emptyStrategy;
    }

    public List<Cluster<T>> cluster(Collection<T> points, int k, int maxIterations) {
        List<Cluster<T>> clusters = KMeansPlusPlusClusterer.chooseInitialCenters(points, k, this.random);
        KMeansPlusPlusClusterer.assignPointsToClusters(clusters, points);
        int max = maxIterations < 0 ? Integer.MAX_VALUE : maxIterations;
        int count = 0;
        while (count < max) {
            boolean clusteringChanged = false;
            ArrayList<Cluster<T>> newClusters = new ArrayList<Cluster<T>>();
            for (Cluster<T> cluster : clusters) {
                Clusterable newCenter;
                if (cluster.getPoints().isEmpty()) {
                    switch (this.emptyStrategy) {
                        case LARGEST_VARIANCE: {
                            newCenter = this.getPointFromLargestVarianceCluster(clusters);
                            break;
                        }
                        case LARGEST_POINTS_NUMBER: {
                            newCenter = this.getPointFromLargestNumberCluster(clusters);
                            break;
                        }
                        case FARTHEST_POINT: {
                            newCenter = this.getFarthestPoint(clusters);
                            break;
                        }
                        default: {
                            throw new ConvergenceException(LocalizedFormats.EMPTY_CLUSTER_IN_K_MEANS);
                        }
                    }
                    clusteringChanged = true;
                } else {
                    newCenter = (Clusterable)cluster.getCenter().centroidOf(cluster.getPoints());
                    if (!newCenter.equals(cluster.getCenter())) {
                        clusteringChanged = true;
                    }
                }
                newClusters.add(new Cluster<Clusterable>(newCenter));
            }
            if (!clusteringChanged) {
                return clusters;
            }
            KMeansPlusPlusClusterer.assignPointsToClusters(newClusters, points);
            clusters = newClusters;
            ++count;
        }
        return clusters;
    }

    private static <T extends Clusterable<T>> void assignPointsToClusters(Collection<Cluster<T>> clusters, Collection<T> points) {
        for (Clusterable p : points) {
            Cluster<Clusterable> cluster = KMeansPlusPlusClusterer.getNearestCluster(clusters, p);
            cluster.addPoint(p);
        }
    }

    private static <T extends Clusterable<T>> List<Cluster<T>> chooseInitialCenters(Collection<T> points, int k, Random random) {
        ArrayList<T> pointSet = new ArrayList<T>(points);
        ArrayList<Cluster<T>> resultSet = new ArrayList<Cluster<T>>();
        Clusterable firstPoint = (Clusterable)pointSet.remove(random.nextInt(pointSet.size()));
        resultSet.add(new Cluster<Clusterable>(firstPoint));
        double[] dx2 = new double[pointSet.size()];
        block0: while (resultSet.size() < k) {
            int sum = 0;
            int i2 = 0;
            while (i2 < pointSet.size()) {
                Clusterable p = (Clusterable)pointSet.get(i2);
                Cluster<Clusterable> nearest = KMeansPlusPlusClusterer.getNearestCluster(resultSet, p);
                double d = p.distanceFrom(nearest.getCenter());
                sum = (int)((double)sum + d * d);
                dx2[i2] = sum;
                ++i2;
            }
            double r = random.nextDouble() * (double)sum;
            int i3 = 0;
            while (i3 < dx2.length) {
                if (dx2[i3] >= r) {
                    Clusterable p = (Clusterable)pointSet.remove(i3);
                    resultSet.add(new Cluster<Clusterable>(p));
                    continue block0;
                }
                ++i3;
            }
        }
        return resultSet;
    }

    private T getPointFromLargestVarianceCluster(Collection<Cluster<T>> clusters) {
        double maxVariance = Double.NEGATIVE_INFINITY;
        Cluster<T> selected = null;
        for (Cluster<T> cluster : clusters) {
            if (cluster.getPoints().isEmpty()) continue;
            T center = cluster.getCenter();
            Variance stat = new Variance();
            for (Clusterable point : cluster.getPoints()) {
                stat.increment(point.distanceFrom(center));
            }
            double variance = stat.getResult();
            if (!(variance > maxVariance)) continue;
            maxVariance = variance;
            selected = cluster;
        }
        if (selected == null) {
            throw new ConvergenceException(LocalizedFormats.EMPTY_CLUSTER_IN_K_MEANS);
        }
        List selectedPoints = selected.getPoints();
        return (T)((Clusterable)selectedPoints.remove(this.random.nextInt(selectedPoints.size())));
    }

    private T getPointFromLargestNumberCluster(Collection<Cluster<T>> clusters) {
        int maxNumber = 0;
        Cluster<T> selected = null;
        for (Cluster<T> cluster : clusters) {
            int number = cluster.getPoints().size();
            if (number <= maxNumber) continue;
            maxNumber = number;
            selected = cluster;
        }
        if (selected == null) {
            throw new ConvergenceException(LocalizedFormats.EMPTY_CLUSTER_IN_K_MEANS);
        }
        List selectedPoints = selected.getPoints();
        return (T)((Clusterable)selectedPoints.remove(this.random.nextInt(selectedPoints.size())));
    }

    private T getFarthestPoint(Collection<Cluster<T>> clusters) {
        double maxDistance = Double.NEGATIVE_INFINITY;
        Cluster<T> selectedCluster = null;
        int selectedPoint = -1;
        for (Cluster<T> cluster : clusters) {
            T center = cluster.getCenter();
            List<T> points = cluster.getPoints();
            int i2 = 0;
            while (i2 < points.size()) {
                double distance = ((Clusterable)points.get(i2)).distanceFrom(center);
                if (distance > maxDistance) {
                    maxDistance = distance;
                    selectedCluster = cluster;
                    selectedPoint = i2;
                }
                ++i2;
            }
        }
        if (selectedCluster == null) {
            throw new ConvergenceException(LocalizedFormats.EMPTY_CLUSTER_IN_K_MEANS);
        }
        return (T)((Clusterable)selectedCluster.getPoints().remove(selectedPoint));
    }

    private static <T extends Clusterable<T>> Cluster<T> getNearestCluster(Collection<Cluster<T>> clusters, T point) {
        double minDistance = Double.MAX_VALUE;
        Cluster<T> minCluster = null;
        for (Cluster<T> c : clusters) {
            double distance = point.distanceFrom(c.getCenter());
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            minCluster = c;
        }
        return minCluster;
    }

    public static enum EmptyClusterStrategy {
        LARGEST_VARIANCE,
        LARGEST_POINTS_NUMBER,
        FARTHEST_POINT,
        ERROR;

    }
}

