/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.correlation;

import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.linear.BlockRealMatrix;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.stat.descriptive.moment.Mean;
import org.apache.commons.math.stat.descriptive.moment.Variance;

public class Covariance {
    private final RealMatrix covarianceMatrix;
    private final int n;

    public Covariance() {
        this.covarianceMatrix = null;
        this.n = 0;
    }

    public Covariance(double[][] data, boolean biasCorrected) {
        this(new BlockRealMatrix(data), biasCorrected);
    }

    public Covariance(double[][] data) {
        this(data, true);
    }

    public Covariance(RealMatrix matrix, boolean biasCorrected) {
        this.checkSufficientData(matrix);
        this.n = matrix.getRowDimension();
        this.covarianceMatrix = this.computeCovarianceMatrix(matrix, biasCorrected);
    }

    public Covariance(RealMatrix matrix) {
        this(matrix, true);
    }

    public RealMatrix getCovarianceMatrix() {
        return this.covarianceMatrix;
    }

    public int getN() {
        return this.n;
    }

    protected RealMatrix computeCovarianceMatrix(RealMatrix matrix, boolean biasCorrected) {
        int dimension = matrix.getColumnDimension();
        Variance variance = new Variance(biasCorrected);
        BlockRealMatrix outMatrix = new BlockRealMatrix(dimension, dimension);
        int i2 = 0;
        while (i2 < dimension) {
            int j = 0;
            while (j < i2) {
                double cov = this.covariance(matrix.getColumn(i2), matrix.getColumn(j), biasCorrected);
                outMatrix.setEntry(i2, j, cov);
                outMatrix.setEntry(j, i2, cov);
                ++j;
            }
            outMatrix.setEntry(i2, i2, variance.evaluate(matrix.getColumn(i2)));
            ++i2;
        }
        return outMatrix;
    }

    protected RealMatrix computeCovarianceMatrix(RealMatrix matrix) {
        return this.computeCovarianceMatrix(matrix, true);
    }

    protected RealMatrix computeCovarianceMatrix(double[][] data, boolean biasCorrected) {
        return this.computeCovarianceMatrix(new BlockRealMatrix(data), biasCorrected);
    }

    protected RealMatrix computeCovarianceMatrix(double[][] data) {
        return this.computeCovarianceMatrix(data, true);
    }

    public double covariance(double[] xArray, double[] yArray, boolean biasCorrected) throws IllegalArgumentException {
        Mean mean = new Mean();
        double result = 0.0;
        int length = xArray.length;
        if (length != yArray.length) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_SIMPLE, length, yArray.length);
        }
        if (length < 2) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.INSUFFICIENT_DIMENSION, length, 2);
        }
        double xMean = mean.evaluate(xArray);
        double yMean = mean.evaluate(yArray);
        int i2 = 0;
        while (i2 < length) {
            double xDev = xArray[i2] - xMean;
            double yDev = yArray[i2] - yMean;
            result += (xDev * yDev - result) / (double)(i2 + 1);
            ++i2;
        }
        return biasCorrected ? result * ((double)length / (double)(length - 1)) : result;
    }

    public double covariance(double[] xArray, double[] yArray) throws IllegalArgumentException {
        return this.covariance(xArray, yArray, true);
    }

    private void checkSufficientData(RealMatrix matrix) {
        int nRows = matrix.getRowDimension();
        int nCols = matrix.getColumnDimension();
        if (nRows < 2 || nCols < 2) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.INSUFFICIENT_ROWS_AND_COLUMNS, nRows, nCols);
        }
    }
}

