/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive.moment;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.math.DimensionMismatchException;
import org.apache.commons.math.stat.descriptive.moment.Mean;

public class VectorialMean
implements Serializable {
    private static final long serialVersionUID = 8223009086481006892L;
    private final Mean[] means;

    public VectorialMean(int dimension) {
        this.means = new Mean[dimension];
        int i2 = 0;
        while (i2 < dimension) {
            this.means[i2] = new Mean();
            ++i2;
        }
    }

    public void increment(double[] v) throws DimensionMismatchException {
        if (v.length != this.means.length) {
            throw new DimensionMismatchException(v.length, this.means.length);
        }
        int i2 = 0;
        while (i2 < v.length) {
            this.means[i2].increment(v[i2]);
            ++i2;
        }
    }

    public double[] getResult() {
        double[] result = new double[this.means.length];
        int i2 = 0;
        while (i2 < result.length) {
            result[i2] = this.means[i2].getResult();
            ++i2;
        }
        return result;
    }

    public long getN() {
        return this.means.length == 0 ? 0L : this.means[0].getN();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.means);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VectorialMean)) {
            return false;
        }
        VectorialMean other = (VectorialMean)obj;
        return Arrays.equals(this.means, other.means);
    }
}

