/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.transform;

import java.io.Serializable;
import java.lang.reflect.Array;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.complex.Complex;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.util.FastMath;

public class FastFourierTransformer
implements Serializable {
    static final long serialVersionUID = 5138259215438106000L;
    private RootsOfUnity roots = new RootsOfUnity();

    public Complex[] transform(double[] f) throws IllegalArgumentException {
        return this.fft(f, false);
    }

    public Complex[] transform(UnivariateRealFunction f, double min, double max, int n) throws FunctionEvaluationException, IllegalArgumentException {
        double[] data = FastFourierTransformer.sample(f, min, max, n);
        return this.fft(data, false);
    }

    public Complex[] transform(Complex[] f) throws IllegalArgumentException {
        this.roots.computeOmega(f.length);
        return this.fft(f);
    }

    public Complex[] transform2(double[] f) throws IllegalArgumentException {
        double scaling_coefficient = 1.0 / FastMath.sqrt(f.length);
        return FastFourierTransformer.scaleArray(this.fft(f, false), scaling_coefficient);
    }

    public Complex[] transform2(UnivariateRealFunction f, double min, double max, int n) throws FunctionEvaluationException, IllegalArgumentException {
        double[] data = FastFourierTransformer.sample(f, min, max, n);
        double scaling_coefficient = 1.0 / FastMath.sqrt(n);
        return FastFourierTransformer.scaleArray(this.fft(data, false), scaling_coefficient);
    }

    public Complex[] transform2(Complex[] f) throws IllegalArgumentException {
        this.roots.computeOmega(f.length);
        double scaling_coefficient = 1.0 / FastMath.sqrt(f.length);
        return FastFourierTransformer.scaleArray(this.fft(f), scaling_coefficient);
    }

    public Complex[] inversetransform(double[] f) throws IllegalArgumentException {
        double scaling_coefficient = 1.0 / (double)f.length;
        return FastFourierTransformer.scaleArray(this.fft(f, true), scaling_coefficient);
    }

    public Complex[] inversetransform(UnivariateRealFunction f, double min, double max, int n) throws FunctionEvaluationException, IllegalArgumentException {
        double[] data = FastFourierTransformer.sample(f, min, max, n);
        double scaling_coefficient = 1.0 / (double)n;
        return FastFourierTransformer.scaleArray(this.fft(data, true), scaling_coefficient);
    }

    public Complex[] inversetransform(Complex[] f) throws IllegalArgumentException {
        this.roots.computeOmega(-f.length);
        double scaling_coefficient = 1.0 / (double)f.length;
        return FastFourierTransformer.scaleArray(this.fft(f), scaling_coefficient);
    }

    public Complex[] inversetransform2(double[] f) throws IllegalArgumentException {
        double scaling_coefficient = 1.0 / FastMath.sqrt(f.length);
        return FastFourierTransformer.scaleArray(this.fft(f, true), scaling_coefficient);
    }

    public Complex[] inversetransform2(UnivariateRealFunction f, double min, double max, int n) throws FunctionEvaluationException, IllegalArgumentException {
        double[] data = FastFourierTransformer.sample(f, min, max, n);
        double scaling_coefficient = 1.0 / FastMath.sqrt(n);
        return FastFourierTransformer.scaleArray(this.fft(data, true), scaling_coefficient);
    }

    public Complex[] inversetransform2(Complex[] f) throws IllegalArgumentException {
        this.roots.computeOmega(-f.length);
        double scaling_coefficient = 1.0 / FastMath.sqrt(f.length);
        return FastFourierTransformer.scaleArray(this.fft(f), scaling_coefficient);
    }

    protected Complex[] fft(double[] f, boolean isInverse) throws IllegalArgumentException {
        FastFourierTransformer.verifyDataSet(f);
        Complex[] F = new Complex[f.length];
        if (f.length == 1) {
            F[0] = new Complex(f[0], 0.0);
            return F;
        }
        int N = f.length >> 1;
        Complex[] c = new Complex[N];
        int i2 = 0;
        while (i2 < N) {
            c[i2] = new Complex(f[2 * i2], f[2 * i2 + 1]);
            ++i2;
        }
        this.roots.computeOmega(isInverse ? -N : N);
        Complex[] z = this.fft(c);
        this.roots.computeOmega(isInverse ? -2 * N : 2 * N);
        F[0] = new Complex(2.0 * (z[0].getReal() + z[0].getImaginary()), 0.0);
        F[N] = new Complex(2.0 * (z[0].getReal() - z[0].getImaginary()), 0.0);
        int i3 = 1;
        while (i3 < N) {
            Complex A = z[N - i3].conjugate();
            Complex B = z[i3].add(A);
            Complex C = z[i3].subtract(A);
            Complex D = new Complex(-this.roots.getOmegaImaginary(i3), this.roots.getOmegaReal(i3));
            F[i3] = B.subtract(C.multiply(D));
            F[2 * N - i3] = F[i3].conjugate();
            ++i3;
        }
        return FastFourierTransformer.scaleArray(F, 0.5);
    }

    protected Complex[] fft(Complex[] data) throws IllegalArgumentException {
        int n = data.length;
        Complex[] f = new Complex[n];
        FastFourierTransformer.verifyDataSet(data);
        if (n == 1) {
            f[0] = data[0];
            return f;
        }
        if (n == 2) {
            f[0] = data[0].add(data[1]);
            f[1] = data[0].subtract(data[1]);
            return f;
        }
        int ii = 0;
        int i2 = 0;
        while (i2 < n) {
            f[i2] = data[ii];
            int k = n >> 1;
            while (ii >= k && k > 0) {
                ii -= k;
                k >>= 1;
            }
            ii += k;
            ++i2;
        }
        i2 = 0;
        while (i2 < n) {
            Complex a = f[i2].add(f[i2 + 1]);
            Complex b = f[i2 + 2].add(f[i2 + 3]);
            Complex c = f[i2].subtract(f[i2 + 1]);
            Complex d = f[i2 + 2].subtract(f[i2 + 3]);
            Complex e1 = c.add(d.multiply(Complex.I));
            Complex e2 = c.subtract(d.multiply(Complex.I));
            f[i2] = a.add(b);
            f[i2 + 2] = a.subtract(b);
            f[i2 + 1] = this.roots.isForward() ? e2 : e1;
            f[i2 + 3] = this.roots.isForward() ? e1 : e2;
            i2 += 4;
        }
        i2 = 4;
        while (i2 < n) {
            int m = n / (i2 << 1);
            int j = 0;
            while (j < n) {
                int k = 0;
                while (k < i2) {
                    int k_times_m = k * m;
                    double omega_k_times_m_real = this.roots.getOmegaReal(k_times_m);
                    double omega_k_times_m_imaginary = this.roots.getOmegaImaginary(k_times_m);
                    Complex z = new Complex(f[i2 + j + k].getReal() * omega_k_times_m_real - f[i2 + j + k].getImaginary() * omega_k_times_m_imaginary, f[i2 + j + k].getReal() * omega_k_times_m_imaginary + f[i2 + j + k].getImaginary() * omega_k_times_m_real);
                    f[i2 + j + k] = f[j + k].subtract(z);
                    f[j + k] = f[j + k].add(z);
                    ++k;
                }
                j += i2 << 1;
            }
            i2 <<= 1;
        }
        return f;
    }

    public static double[] sample(UnivariateRealFunction f, double min, double max, int n) throws FunctionEvaluationException, IllegalArgumentException {
        if (n <= 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NOT_POSITIVE_NUMBER_OF_SAMPLES, n);
        }
        FastFourierTransformer.verifyInterval(min, max);
        double[] s = new double[n];
        double h = (max - min) / (double)n;
        int i2 = 0;
        while (i2 < n) {
            s[i2] = f.value(min + (double)i2 * h);
            ++i2;
        }
        return s;
    }

    public static double[] scaleArray(double[] f, double d) {
        int i2 = 0;
        while (i2 < f.length) {
            int n = i2++;
            f[n] = f[n] * d;
        }
        return f;
    }

    public static Complex[] scaleArray(Complex[] f, double d) {
        int i2 = 0;
        while (i2 < f.length) {
            f[i2] = new Complex(d * f[i2].getReal(), d * f[i2].getImaginary());
            ++i2;
        }
        return f;
    }

    public static boolean isPowerOf2(long n) {
        return n > 0L && (n & n - 1L) == 0L;
    }

    public static void verifyDataSet(double[] d) throws IllegalArgumentException {
        if (!FastFourierTransformer.isPowerOf2(d.length)) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NOT_POWER_OF_TWO_CONSIDER_PADDING, d.length);
        }
    }

    public static void verifyDataSet(Object[] o) throws IllegalArgumentException {
        if (!FastFourierTransformer.isPowerOf2(o.length)) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NOT_POWER_OF_TWO_CONSIDER_PADDING, o.length);
        }
    }

    public static void verifyInterval(double lower, double upper) throws IllegalArgumentException {
        if (lower >= upper) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.ENDPOINTS_NOT_AN_INTERVAL, lower, upper);
        }
    }

    public Object mdfft(Object mdca, boolean forward) throws IllegalArgumentException {
        MultiDimensionalComplexMatrix mdcm = (MultiDimensionalComplexMatrix)new MultiDimensionalComplexMatrix(mdca).clone();
        int[] dimensionSize = mdcm.getDimensionSizes();
        int i2 = 0;
        while (i2 < dimensionSize.length) {
            this.mdfft(mdcm, forward, i2, new int[0]);
            ++i2;
        }
        return mdcm.getArray();
    }

    private void mdfft(MultiDimensionalComplexMatrix mdcm, boolean forward, int d, int[] subVector) throws IllegalArgumentException {
        int[] dimensionSize = mdcm.getDimensionSizes();
        if (subVector.length == dimensionSize.length) {
            Complex[] temp = new Complex[dimensionSize[d]];
            int i2 = 0;
            while (i2 < dimensionSize[d]) {
                subVector[d] = i2;
                temp[i2] = mdcm.get(subVector);
                ++i2;
            }
            temp = forward ? this.transform2(temp) : this.inversetransform2(temp);
            i2 = 0;
            while (i2 < dimensionSize[d]) {
                subVector[d] = i2;
                mdcm.set(temp[i2], subVector);
                ++i2;
            }
        } else {
            int[] vector = new int[subVector.length + 1];
            System.arraycopy(subVector, 0, vector, 0, subVector.length);
            if (subVector.length == d) {
                vector[d] = 0;
                this.mdfft(mdcm, forward, d, vector);
            } else {
                int i3 = 0;
                while (i3 < dimensionSize[subVector.length]) {
                    vector[subVector.length] = i3++;
                    this.mdfft(mdcm, forward, d, vector);
                }
            }
        }
    }

    private static class MultiDimensionalComplexMatrix
    implements Cloneable {
        protected int[] dimensionSize;
        protected Object multiDimensionalComplexArray;

        public MultiDimensionalComplexMatrix(Object multiDimensionalComplexArray) {
            Object[] array;
            this.multiDimensionalComplexArray = multiDimensionalComplexArray;
            int numOfDimensions = 0;
            Object lastDimension = multiDimensionalComplexArray;
            while (lastDimension instanceof Object[]) {
                array = (Object[])lastDimension;
                ++numOfDimensions;
                lastDimension = array[0];
            }
            this.dimensionSize = new int[numOfDimensions];
            numOfDimensions = 0;
            lastDimension = multiDimensionalComplexArray;
            while (lastDimension instanceof Object[]) {
                array = (Object[])lastDimension;
                this.dimensionSize[numOfDimensions++] = array.length;
                lastDimension = array[0];
            }
        }

        public Complex get(int ... vector) throws IllegalArgumentException {
            if (vector == null) {
                if (this.dimensionSize.length > 0) {
                    throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_SIMPLE, 0, this.dimensionSize.length);
                }
                return null;
            }
            if (vector.length != this.dimensionSize.length) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_SIMPLE, vector.length, this.dimensionSize.length);
            }
            Object lastDimension = this.multiDimensionalComplexArray;
            int i2 = 0;
            while (i2 < this.dimensionSize.length) {
                lastDimension = ((Object[])lastDimension)[vector[i2]];
                ++i2;
            }
            return (Complex)lastDimension;
        }

        public Complex set(Complex magnitude, int ... vector) throws IllegalArgumentException {
            if (vector == null) {
                if (this.dimensionSize.length > 0) {
                    throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_SIMPLE, 0, this.dimensionSize.length);
                }
                return null;
            }
            if (vector.length != this.dimensionSize.length) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_SIMPLE, vector.length, this.dimensionSize.length);
            }
            Object[] lastDimension = (Object[])this.multiDimensionalComplexArray;
            int i2 = 0;
            while (i2 < this.dimensionSize.length - 1) {
                lastDimension = (Object[])lastDimension[vector[i2]];
                ++i2;
            }
            Complex lastValue = (Complex)lastDimension[vector[this.dimensionSize.length - 1]];
            lastDimension[vector[this.dimensionSize.length - 1]] = magnitude;
            return lastValue;
        }

        public int[] getDimensionSizes() {
            return (int[])this.dimensionSize.clone();
        }

        public Object getArray() {
            return this.multiDimensionalComplexArray;
        }

        public Object clone() {
            MultiDimensionalComplexMatrix mdcm = new MultiDimensionalComplexMatrix(Array.newInstance(Complex.class, this.dimensionSize));
            this.clone(mdcm);
            return mdcm;
        }

        private void clone(MultiDimensionalComplexMatrix mdcm) {
            int[] nextVector;
            int[][] vectorList;
            int[] vector = new int[this.dimensionSize.length];
            int size = 1;
            int i2 = 0;
            while (i2 < this.dimensionSize.length) {
                size *= this.dimensionSize[i2];
                ++i2;
            }
            int[][] nArray = vectorList = new int[size][this.dimensionSize.length];
            int n = vectorList.length;
            int n2 = 0;
            while (n2 < n) {
                nextVector = nArray[n2];
                System.arraycopy(vector, 0, nextVector, 0, this.dimensionSize.length);
                int i3 = 0;
                while (i3 < this.dimensionSize.length) {
                    int n3 = i3;
                    vector[n3] = vector[n3] + 1;
                    if (vector[i3] < this.dimensionSize[i3]) break;
                    vector[i3] = 0;
                    ++i3;
                }
                ++n2;
            }
            nArray = vectorList;
            n = vectorList.length;
            n2 = 0;
            while (n2 < n) {
                nextVector = nArray[n2];
                mdcm.set(this.get(nextVector), nextVector);
                ++n2;
            }
        }
    }

    private static class RootsOfUnity
    implements Serializable {
        private static final long serialVersionUID = 6404784357747329667L;
        private int omegaCount = 0;
        private double[] omegaReal = null;
        private double[] omegaImaginaryForward = null;
        private double[] omegaImaginaryInverse = null;
        private boolean isForward = true;

        public synchronized boolean isForward() throws IllegalStateException {
            if (this.omegaCount == 0) {
                throw MathRuntimeException.createIllegalStateException(LocalizedFormats.ROOTS_OF_UNITY_NOT_COMPUTED_YET, new Object[0]);
            }
            return this.isForward;
        }

        public synchronized void computeOmega(int n) throws IllegalArgumentException {
            if (n == 0) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.CANNOT_COMPUTE_0TH_ROOT_OF_UNITY, new Object[0]);
            }
            this.isForward = n > 0;
            int absN = FastMath.abs(n);
            if (absN == this.omegaCount) {
                return;
            }
            double t = Math.PI * 2 / (double)absN;
            double cosT = FastMath.cos(t);
            double sinT = FastMath.sin(t);
            this.omegaReal = new double[absN];
            this.omegaImaginaryForward = new double[absN];
            this.omegaImaginaryInverse = new double[absN];
            this.omegaReal[0] = 1.0;
            this.omegaImaginaryForward[0] = 0.0;
            this.omegaImaginaryInverse[0] = 0.0;
            int i2 = 1;
            while (i2 < absN) {
                this.omegaReal[i2] = this.omegaReal[i2 - 1] * cosT + this.omegaImaginaryForward[i2 - 1] * sinT;
                this.omegaImaginaryForward[i2] = this.omegaImaginaryForward[i2 - 1] * cosT - this.omegaReal[i2 - 1] * sinT;
                this.omegaImaginaryInverse[i2] = -this.omegaImaginaryForward[i2];
                ++i2;
            }
            this.omegaCount = absN;
        }

        public synchronized double getOmegaReal(int k) throws IllegalStateException, IllegalArgumentException {
            if (this.omegaCount == 0) {
                throw MathRuntimeException.createIllegalStateException(LocalizedFormats.ROOTS_OF_UNITY_NOT_COMPUTED_YET, new Object[0]);
            }
            if (k < 0 || k >= this.omegaCount) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.OUT_OF_RANGE_ROOT_OF_UNITY_INDEX, k, 0, this.omegaCount - 1);
            }
            return this.omegaReal[k];
        }

        public synchronized double getOmegaImaginary(int k) throws IllegalStateException, IllegalArgumentException {
            if (this.omegaCount == 0) {
                throw MathRuntimeException.createIllegalStateException(LocalizedFormats.ROOTS_OF_UNITY_NOT_COMPUTED_YET, new Object[0]);
            }
            if (k < 0 || k >= this.omegaCount) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.OUT_OF_RANGE_ROOT_OF_UNITY_INDEX, k, 0, this.omegaCount - 1);
            }
            return this.isForward ? this.omegaImaginaryForward[k] : this.omegaImaginaryInverse[k];
        }
    }
}

