/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.util;

import org.apache.commons.math.exception.DimensionMismatchException;
import org.apache.commons.math.exception.NotStrictlyPositiveException;
import org.apache.commons.math.exception.OutOfRangeException;

public class MultidimensionalCounter
implements Iterable<Integer> {
    private final int dimension;
    private final int[] uniCounterOffset;
    private final int[] size;
    private final int totalSize;
    private final int last;

    public MultidimensionalCounter(int ... size) {
        this.dimension = size.length;
        this.size = this.copyOf(size, this.dimension);
        this.uniCounterOffset = new int[this.dimension];
        this.last = this.dimension - 1;
        int tS = size[this.last];
        int i2 = 0;
        while (i2 < this.last) {
            int count = 1;
            int j = i2 + 1;
            while (j < this.dimension) {
                count *= size[j];
                ++j;
            }
            this.uniCounterOffset[i2] = count;
            tS *= size[i2];
            ++i2;
        }
        this.uniCounterOffset[this.last] = 0;
        if (tS <= 0) {
            throw new NotStrictlyPositiveException(tS);
        }
        this.totalSize = tS;
    }

    public Iterator iterator() {
        return new Iterator();
    }

    public int getDimension() {
        return this.dimension;
    }

    public int[] getCounts(int index) {
        if (index < 0 || index >= this.totalSize) {
            throw new OutOfRangeException(index, (Number)0, this.totalSize);
        }
        int[] indices = new int[this.dimension];
        int count = 0;
        int i2 = 0;
        while (i2 < this.last) {
            int idx = 0;
            int offset = this.uniCounterOffset[i2];
            while (count <= index) {
                count += offset;
                ++idx;
            }
            count -= offset;
            indices[i2] = --idx;
            ++i2;
        }
        int idx = 1;
        while (count < index) {
            count += idx;
            ++idx;
        }
        indices[this.last] = --idx;
        return indices;
    }

    public int getCount(int ... c) throws OutOfRangeException {
        if (c.length != this.dimension) {
            throw new DimensionMismatchException(c.length, this.dimension);
        }
        int count = 0;
        int i2 = 0;
        while (i2 < this.dimension) {
            int index = c[i2];
            if (index < 0 || index >= this.size[i2]) {
                throw new OutOfRangeException(index, (Number)0, this.size[i2] - 1);
            }
            count += this.uniCounterOffset[i2] * c[i2];
            ++i2;
        }
        return count + c[this.last];
    }

    public int getSize() {
        return this.totalSize;
    }

    public int[] getSizes() {
        return this.copyOf(this.size, this.dimension);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int i2 = 0;
        while (i2 < this.dimension) {
            sb.append("[").append(this.getCount(i2++)).append("]");
        }
        return sb.toString();
    }

    private int[] copyOf(int[] source, int newLen) {
        int[] output = new int[newLen];
        System.arraycopy(source, 0, output, 0, Math.min(source.length, newLen));
        return output;
    }

    public class Iterator
    implements java.util.Iterator<Integer> {
        private final int[] counter;
        private int count;

        Iterator() {
            this.counter = new int[MultidimensionalCounter.this.dimension];
            this.count = -1;
            this.counter[((MultidimensionalCounter)MultidimensionalCounter.this).last] = -1;
        }

        @Override
        public boolean hasNext() {
            int i2 = 0;
            while (i2 < MultidimensionalCounter.this.dimension) {
                if (this.counter[i2] != MultidimensionalCounter.this.size[i2] - 1) {
                    return true;
                }
                ++i2;
            }
            return false;
        }

        @Override
        public Integer next() {
            int i2 = MultidimensionalCounter.this.last;
            while (i2 >= 0) {
                if (this.counter[i2] != MultidimensionalCounter.this.size[i2] - 1) {
                    int n = i2;
                    this.counter[n] = this.counter[n] + 1;
                    break;
                }
                this.counter[i2] = 0;
                --i2;
            }
            return ++this.count;
        }

        public int getCount() {
            return this.count;
        }

        public int[] getCounts() {
            return MultidimensionalCounter.this.copyOf(this.counter, MultidimensionalCounter.this.dimension);
        }

        public int getCount(int dim) {
            return this.counter[dim];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

