/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.OutputStream;
import org.apache.fop.Version;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FormattingResults;
import org.apache.fop.fo.FOTreeBuilder;
import org.xml.sax.helpers.DefaultHandler;

public class Fop {
    private String outputFormat = null;
    private OutputStream stream = null;
    private FOUserAgent foUserAgent = null;
    private FOTreeBuilder foTreeBuilder = null;

    public Fop(String outputFormat, FOUserAgent ua, OutputStream stream) throws FOPException {
        this.outputFormat = outputFormat;
        this.foUserAgent = ua;
        if (this.foUserAgent == null) {
            this.foUserAgent = FopFactory.newInstance().newFOUserAgent();
        }
        this.stream = stream;
        this.createDefaultHandler();
    }

    public Fop(String outputFormat, FOUserAgent ua) throws FOPException {
        this.outputFormat = outputFormat;
        this.foUserAgent = ua;
        if (this.foUserAgent == null) {
            this.foUserAgent = FopFactory.newInstance().newFOUserAgent();
        }
        this.createDefaultHandler();
    }

    public Fop(String outputFormat) {
        this.outputFormat = outputFormat;
        this.foUserAgent = FopFactory.newInstance().newFOUserAgent();
    }

    public FOUserAgent getUserAgent() {
        return this.foUserAgent;
    }

    public void setOutputStream(OutputStream stream) {
        this.stream = stream;
    }

    private void createDefaultHandler() throws FOPException {
        this.foTreeBuilder = new FOTreeBuilder(this.outputFormat, this.foUserAgent, this.stream);
    }

    public DefaultHandler getDefaultHandler() throws FOPException {
        if (this.foTreeBuilder == null) {
            this.createDefaultHandler();
        }
        return this.foTreeBuilder;
    }

    public FormattingResults getResults() {
        if (this.foTreeBuilder == null) {
            throw new IllegalStateException("Results are only available after calling getDefaultHandler().");
        }
        return this.foTreeBuilder.getResults();
    }

    public static String getVersion() {
        return Version.getVersion();
    }
}

