/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.CodePointMapping;
import org.apache.fop.fonts.CustomFont;

public class SingleByteFont
extends CustomFont {
    private static Log log = LogFactory.getLog(class$org$apache$fop$fonts$SingleByteFont == null ? (class$org$apache$fop$fonts$SingleByteFont = SingleByteFont.class$("org.apache.fop.fonts.SingleByteFont")) : class$org$apache$fop$fonts$SingleByteFont);
    private CodePointMapping mapping;
    private String encoding = "WinAnsiEncoding";
    private int[] width = null;
    static /* synthetic */ Class class$org$apache$fop$fonts$SingleByteFont;

    public SingleByteFont() {
        this.updateMapping();
    }

    protected void updateMapping() {
        this.mapping = CodePointMapping.getMapping(this.getEncoding());
    }

    public boolean isEmbeddable() {
        return this.getEmbedFileName() != null || this.getEmbedResourceName() != null;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
        this.updateMapping();
    }

    public int getWidth(int i2, int size) {
        return size * this.width[i2];
    }

    public int[] getWidths() {
        int[] arr = new int[this.width.length];
        System.arraycopy(this.width, 0, arr, 0, this.width.length - 1);
        return arr;
    }

    public char mapChar(char c) {
        char d = this.mapping.mapChar(c);
        if (d != '\u0000') {
            return d;
        }
        log.warn("Glyph " + c + " not available in font " + this.getFontName());
        return '#';
    }

    public boolean hasChar(char c) {
        return this.mapping.mapChar(c) > '\u0000';
    }

    public void setWidth(int index, int width) {
        if (this.width == null) {
            this.width = new int[256];
        }
        this.width[index] = width;
    }

    public char[] getCharsUsed() {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

